/* 
 * (c) Copyright 1989, 1990, 1991, 1992 OPEN SOFTWARE FOUNDATION, INC. 
 * ALL RIGHTS RESERVED 
*/ 
/* 
 * Motif Release 1.2
*/ 
#ifdef REV_INFO
#ifndef lint
static char rcsid[] = "$RCSfile: FetchCL.c,v $ $Revision: 1.5.2.2 $ $Date: 1992/04/08 15:52:21 $"
#endif
#endif

#include <MrmTest.h>

/*
 * Data for summary
 */

#define NUM_TESTS		7
#define TEST_DESCRIP_LENGTH	38

struct TestInfo FetchColorLiteralInfo[NUM_TESTS] = 
{
    {"Fetch non-exported color              ", MrmNOT_FOUND,	NULL},
    {"Fetch nonexistent color               ", MrmNOT_FOUND,	NULL},
    {"Fetch color from nonexistent hierarchy", MrmBAD_HIERARCHY,	NULL},
    {"Fetch valid color                     ", MrmSUCCESS,	NULL},
    {"Fetch valid color                     ", MrmSUCCESS,	NULL},
    {"Fetch valid color                     ", MrmSUCCESS,	NULL},
    {"Fetch valid color                     ", MrmSUCCESS,	NULL},
};

/*
 * External declarations
 */

extern MrmHierarchy	s_MrmHierarchy;
extern MrmType		class;

extern Widget		widgetmain;

extern String		summary();

/*
 * Local declarations
 */

#define VALID_TEST1	1
#define VALID_TEST2	2
#define FINISH		3

Display		*dsp;
Colormap	cmap;

Widget		button1 = NULL,
		button2 = NULL,
		test_top = NULL,
		test_box = NULL;

int		iteration = 1;

void continue_proc(w, tag, reason)
     Widget		w;
     int		*tag;
     unsigned long	*reason;
{ 	

    String	msg_valid_tst1 = "There should now be two buttons in the second window.\nThe buttons should have labels which read\n   Button1               Button2\nThe colors should be: background - red, foreground - yellow.\n\nAlso, note that there should be four Mrm Toolkit Warning\nmessages on stdout/stderr about MrmFAILUREs.\n\nPress the continue button to continue the test.";

    String	msg_valid_tst2 = "The two buttons should still have the same labels, but the\ncolors should be: background - blue, foreground - white.\n\nPress the continue button to continue the test.";

    Arg		args[2];
    int		nargs;

    Pixel	blue,
		white,
    		red,
    		yellow,
    		bad_color;

    XmString	message;

    String	summary_msg;

    int		i;

    if(iteration == VALID_TEST1)
    {
	iteration++;

/*
 * Get display, colormap
 */

	dsp = XtDisplay(widgetmain);
	
	cmap = DefaultColormap(dsp, DefaultScreen(dsp));

/*
 * Try to fetch a color which is not exported
 */

	FetchColorLiteralInfo[0].actual_return = 
	MrmFetchColorLiteral(s_MrmHierarchy,
			    "bad_color1",
			     dsp,
			     cmap,
			     &bad_color);
	
/*
 * Try to fetch a color which is nonexistent
 */

	FetchColorLiteralInfo[1].actual_return = 
	MrmFetchColorLiteral(s_MrmHierarchy,
			    "bad_color2",
			     dsp,
			     cmap,
			     &bad_color);
	
/*
 * Try to fetch a color from a NULL hierarchy
 */

	FetchColorLiteralInfo[2].actual_return = 
	MrmFetchColorLiteral(NULL,
			    "red",
			     dsp,
			     cmap,
			     &bad_color);

/*
 * Create top level shell widget as parent for test_box widget
 */
	
	test_top = XtAppCreateShell("test_top",
				    "TEST_TOP",
				    topLevelShellWidgetClass,
				    dsp,
				    NULL, 0);
/*
 * Fetch test_box widget
 */

	if(MrmFetchWidget(s_MrmHierarchy,	/* id of uid hierarchy	   */
			  "test_box",		/* uil name of widget	   */
			  test_top,		/* parent of widget	   */
			  &test_box,		/* ptr to widget id	   */
			  &class)		/* ptr to widget class	   */
	   != MrmSUCCESS)
	{
	    error_proc("Can't fetch test_box widget\n");
	}

/*
 * Get ID's of button widgets
 */

	button1 = XtNameToWidget(test_box, "button1");
	button2 = XtNameToWidget(test_box, "button2");

/*
 * Fetch the colors for the buttons for valid test 1
 */

	FetchColorLiteralInfo[3].actual_return =
	MrmFetchColorLiteral(s_MrmHierarchy,
			     "red",
			     dsp,
			     cmap,
			     &red);
	
	FetchColorLiteralInfo[4].actual_return =
	MrmFetchColorLiteral(s_MrmHierarchy,
			     "yellow",
			     dsp,
			     cmap,
			     &yellow);

/*
 * Set background and foreground colors for button widgets
 */

	nargs = 0;
	XtSetArg(args[nargs], XmNbackground, red); nargs++;
	XtSetArg(args[nargs], XmNforeground, yellow); nargs++;
	XtSetValues(button1, args, nargs);
	XtSetValues(button2, args, nargs);

/*
 * Manage test_box widget
 */

	XtManageChild(test_box);

/*
 * Realize top level shell widget
 */

	XtRealizeWidget(test_top);

/*
 * Replace the instruction message with "valid test 1" message
 */

	message = XmStringCreateLtoR(msg_valid_tst1, XmSTRING_DEFAULT_CHARSET);

	nargs = 0;
	XtSetArg(args[nargs], XmNmessageString, message); nargs++;
	XtSetValues(widgetmain, args, nargs);
			       
    }
    else if(iteration == VALID_TEST2)
    {
	iteration++;

/*
 * Fetch the colors for the buttons for valid test 1
 */

	FetchColorLiteralInfo[5].actual_return =
	MrmFetchColorLiteral(s_MrmHierarchy,
			     "blue",
			     dsp,
			     cmap,
			     &blue);
	
	FetchColorLiteralInfo[6].actual_return =
	MrmFetchColorLiteral(s_MrmHierarchy,
			     "white",
			     dsp,
			     cmap,
			     &white);

/*
 * Set background and foreground colors for button widgets
 */

	nargs = 0;
	XtSetArg(args[nargs], XmNbackground, blue ); nargs++;
	XtSetArg(args[nargs], XmNforeground, white ); nargs++;
	XtSetValues(button1, args, nargs);
	XtSetValues(button2, args, nargs);
	
/*
 * Replace the instruction message with description of valid test 2 results
 */

	message = XmStringCreateLtoR(msg_valid_tst2, XmSTRING_DEFAULT_CHARSET);

	nargs = 0;
	XtSetArg(args[nargs], XmNmessageString, message); nargs++;
	XtSetValues(widgetmain, args, nargs);
			       
    }
    else if(iteration == FINISH)
    {
	iteration++;

/*
 * Replace the instruction message with test end message
 */

	summary_msg = summary(NUM_TESTS,
			      TEST_DESCRIP_LENGTH,
			      FetchColorLiteralInfo);

	fprintf (stdout, summary_msg);

	message = XmStringCreateLtoR(summary_msg, XmSTRING_DEFAULT_CHARSET);

	nargs = 0;
	XtSetArg(args[nargs], XmNmessageString, message); nargs++;
	XtSetValues(widgetmain, args, nargs);
    }
}
