/* 
 * (c) Copyright 1989, 1990, 1991, 1992 OPEN SOFTWARE FOUNDATION, INC. 
 * ALL RIGHTS RESERVED 
*/ 
/* 
 * Motif Release 1.2
*/ 
/*   $RCSfile: ABrowse.h,v $ $Revision: 1.4 $ $Date: 92/03/13 16:51:14 $ */

/**********************************************************
 * ABrowse.h: Public header file for ABrowse Widget Class *
 **********************************************************/

#ifndef _ABrowse_h
#define _ABrowse_h

#include <X11/Constraint.h>

/* Parameters:

 Name		     Class		RepType		Default Value
 ----		     -----		-------		-------------
 background	     Background		Pixel		XtDefaultBackground
 border		     BorderColor	Pixel		XtDefaultForeground
 borderWidth	     BorderWidth	Dimension	1
 buttonBackground    Background		Pixel		White
 buttonForeground    Foreground		Pixel		Black
 defaultDistance     Thickness		int		4
 destroyCallback     Callback		Pointer		NULL
 height		     Height		Dimension	computed at realize
 helpCallback	     Callback		Pointer		NULL
 imageBackground     Background		Pixel		White
 imageForeground     Foreground		Pixel		Black
 images		     Images		Pointer		NULL
 mappedWhenManaged   MappedWhenManaged	Boolean		True
 numImages	     NumImages		Int		0
 quitCallback	     Callback		Pointer		NULL
 sensitive	     Sensitive		Boolean		True
 width		     Width		Dimension	computed at realize
 x		     Position		Position	0
 y		     Position		Position	0

*/

/* Constraint parameters:

 Name		     Class		RepType		Default Value
 ----		     -----		-------		-------------
 bottom		     Edge		XtEdgeType	XtRubber
 fromHoriz	     Widget		Widget		(left edge of form)
 fromVert	     Widget		Widget		(top of form)
 horizDistance	     Thickness		int		defaultDistance
 left		     Edge		XtEdgeType	XtRubber
 resizable	     Boolean		Boolean		False
 right		     Edge		XtEdgeType	XtRubber
 top		     Edge		XtEdgeType	XtRubber
 vertDistance	     Thickness		int		defaultDistance

*/

#define XtNimages		"images"
#define XtNnumImages		"numImages"
#define XtNimageBackground	"imageBackground"
#define XtNimageForeground	"imageForeground"
#define XtNbuttonBackground	"buttonBackground"
#define XtNbuttonForeground	"buttonForeground"
#define XtNhelpCallback		"helpCallback"
#define XtNquitCallback		"quitCallback"

#define XtCImages		"Images"
#define XtCNumImages		"NumImages"

typedef struct _ABrowseClassRec	*ABrowseWidgetClass;
typedef struct _ABrowseRec	*ABrowseWidget;

extern WidgetClass		abrowseWidgetClass;

extern Widget			XtCreateABrowse();

#endif _ABrowse_h
