/* 
 * (c) Copyright 1989, 1990, 1991, 1992 OPEN SOFTWARE FOUNDATION, INC. 
 * ALL RIGHTS RESERVED 
*/ 
/* 
 * Motif Release 1.2
*/ 
#ifdef REV_INFO
#ifndef lint
static char rcsid[] = "$RCSfile: TestInit.c,v $ $Revision: 1.5.2.2 $ $Date: 1992/03/19 21:03:29 $"
#endif
#endif
#include "testlib.h"

#define  MAX_CLASS_LEN  256

XtAppContext     app_context;	/* Global Application Context */
Display          *display;	/* Global Display variable */
Widget           Shell1;	/* Global TopLevel Application Shell */
Window		 rootWindow;	/* Global Toplevel Root Window */
Screen		 * screen;	/* Global TopLevel screen */

/* extern varaibles from CommonExtraResources */

extern Arg       CommonExtraArgs[MAX_ARGS];
extern Cardinal  CommonExtraN;

char CommonAppClass[MAX_CLASS_LEN] = "XMcommon";

/* forward declarations */

static void             ManualSignalQuit();
static void 		ManualRegressionSignal();


/*************************************************************************
*                                                                        *
*       Name:           CommonTestInit()                                 *
*								 	 *
*	Purpose:	This routine will Initialize Xt, create a app    *
*			context, create a connnection to the display     *
*			and create an toplevel application shell. Shell1 *
*			and display are global variable and will be used *
*			in other routines.				 *
*									 *
*	Return:		Nothing						 *
*									 *
*************************************************************************/

#ifdef _NO_PROTO
void CommonTestInit(argc, argv)
int  	argc;
char 	**argv;
#else /* _NO_PROTO */
void CommonTestInit(int argc, char **argv)
#endif /* _NO_PROTO */

{
     int 	n, i;
     Arg 	args[MAX_ARGS];

#ifdef REGRESSION
     signal(SIGHUP,  ManualRegressionSignal);
     signal(SIGINT,  ManualRegressionSignal);
     signal(SIGQUIT, ManualRegressionSignal);
     signal(SIGKILL, ManualRegressionSignal);
     signal(SIGBUS,  ManualRegressionSignal);
     signal(SIGSEGV, ManualRegressionSignal);

     /* the following was suggested to handle cases where
	user exits via Mwm Close, but it loops infinitely.
	Fix some day. */

     /* atexit (ManualRegressionSignal); */

#else
     signal(SIGHUP,  ManualSignalQuit);
     signal(SIGINT,  ManualSignalQuit);
     signal(SIGQUIT, ManualSignalQuit);
     signal(SIGKILL, ManualSignalQuit);
     signal(SIGBUS,  ManualSignalQuit);
     signal(SIGSEGV, ManualSignalQuit);

     /* atexit (ManualSignalQuit); */

#endif


     n = 0;

     /*
        merge in Extra arguments in the args list for the creation
        of the application shell. Args are set by CommonExtraResources().

        Special Case: If the CommonExtraArgs[i].name is "CommonAppClass"
        then we want to change the name of the ApplicationClass and we
        will extract that value from CommonExtraArgs[i].value

     */

     if (CommonExtraN > 0) {
        for (i = 0 ; i < CommonExtraN; i++) {
                if (strcmp(CommonExtraArgs[i].name, "CommonAppClass") == 0)
                        strcpy(CommonAppClass, 
 			       (char *) CommonExtraArgs[i].value);
                else {
                        args[n].name = CommonExtraArgs[i].name;
                        args[n++].value = CommonExtraArgs[i].value;
                }
        }
     }

     /*
      *  Initialize malloc checking.  Note: a side effect of this
      *  is that the above signals will be redefined to call 
      *  MallocExit.
     */

     MallocInit();

     XtToolkitInitialize();
     app_context = XtCreateApplicationContext();
     display = XtOpenDisplay(app_context, NULL, argv[0], CommonAppClass,
     				NULL, 0, &argc, argv);
     if (display == NULL) {
      	  fprintf(stderr, "%s:  Can't open display\n", argv[0]);
       	  exit(1);
     }

     CommonGetOptions(&argc, argv);

     rootWindow = XDefaultRootWindow(display);
	
     XtSetArg(args[n], XmNallowShellResize, True);  	n++;
     Shell1 = XtAppCreateShell(argv[0], CommonAppClass, 
		          applicationShellWidgetClass, display, args, n);

     screen = XtScreen(Shell1);

}
	
static void  ManualSignalQuit(sig, code, scp)
int sig, code;
struct sigcontext *scp;
{
     char sigstring[256];

     switch (sig) {
	case SIGHUP:	strcpy(sigstring, "hangup");
			break;
	case SIGINT:	strcpy(sigstring, "interrupt");
			break;
	case SIGQUIT:	strcpy(sigstring, "quit");
			break;
	case SIGKILL:	strcpy(sigstring, "kill");
			break;
	case SIGSEGV:	strcpy(sigstring, "segmentation violation");
			break;
	case SIGBUS:	strcpy(sigstring, "bus error");
			break;
	default:	strcpy(sigstring, "undetermined");
			break;
     }
     printf("%s signal received: Begin exiting ... please standby ... \n",
	    sigstring);

     fflush(stdout);

     exit(0);
}

static void  ManualRegressionSignal(sig, code, scp)
int sig, code;
struct sigcontext *scp;
{
     char sigstring[256];

     switch (sig) {
	case SIGHUP:	strcpy(sigstring, "hangup");
			break;
	case SIGINT:	strcpy(sigstring, "interrupt");
			break;
	case SIGQUIT:	strcpy(sigstring, "quit");
			break;
	case SIGKILL:	strcpy(sigstring, "kill");
			break;
	case SIGSEGV:	strcpy(sigstring, "segmentation violation");
			break;
	case SIGBUS:	strcpy(sigstring, "bus error");
			break;
	default:	strcpy(sigstring, "undetermined");
			break;
     }

     printf("WARNING: %s signal received from test %s\n            Begin exiting ... please standby ... \n", sigstring, TestName);

     /* flush stdout */

     fflush(stdout);

     /* even on an interrupt, write out summary */

     if (InstructionBox != NULL) 
     	XtCallCallbacks (XmMessageBoxGetChild(InstructionBox,
                                              XmDIALOG_CANCEL_BUTTON),
                         XmNactivateCallback, NULL);
     else
	exit(0);

}
