/* 
 * (c) Copyright 1989, 1990, 1991, 1992 OPEN SOFTWARE FOUNDATION, INC. 
 * ALL RIGHTS RESERVED 
*/ 
/* 
 * Motif Release 1.2
*/ 
#ifdef REV_INFO
#ifndef lint
static char rcsid[] = "$RCSfile: Font.c,v $ $Revision: 1.3 $ $Date: 92/03/13 18:32:17 $"
#endif
#endif
#include "testlib.h"

/*************************************************************************
*									 *
*	Name:		CommonGetFontList()				 *
*									 *
*	Purpose:	This function will given a name of a desired     *
*			return a appropriate Font List. If the font      *
*			cannot be found, the default font will be	 *
*			used. default_font is either read from the       *
*			command line or from testlib.h (DEFAULT_FONT)	 *
*									 *
*	Return:		Appropriate font list corresponding to string    *
*			input.						 *
*									 *
*************************************************************************/

#ifdef _NO_PROTO
XmFontList CommonGetFontList(fontstr)
char *fontstr;
#else /* _NO_PROTO */
XmFontList CommonGetFontList(char *fontstr)
#endif /* _NO_PROTO */

{

#ifdef MOTIF1_1
    XFontStruct   *newfont;
#else
    XmFontListEntry fixed_font;
    XmFontListEntry fontlistEntry;
    static int  count = 0;
#endif
    XmFontList    fontlist;

#ifdef MOTIF1_1

    if (!(newfont = XLoadQueryFont (display, fontstr)))
    	newfont = XLoadQueryFont (display, default_font);
    fontlist = XmFontListCreate (newfont, XmSTRING_DEFAULT_CHARSET);

#else

    if (count == 0) {
        fixed_font = XmFontListEntryLoad(display, "fixed", XmFONT_IS_FONT,
                                         XmFONTLIST_DEFAULT_TAG);
        count++;
    }

    if ((fontlistEntry = XmFontListEntryLoad(display, fontstr, XmFONT_IS_FONT,
                                        XmFONTLIST_DEFAULT_TAG)) == NULL)
        fontlistEntry = fixed_font;

    fontlist = XmFontListAppendEntry(NULL, fontlistEntry);

#endif

	return(fontlist);

}
