/* 
 * (c) Copyright 1989, 1990, 1991, 1992 OPEN SOFTWARE FOUNDATION, INC. 
 * ALL RIGHTS RESERVED 
*/ 
/* 
 * Motif Release 1.2
*/ 
#ifdef REV_INFO
#ifndef lint
static char rcsid[] = "$RCSfile: memory.c,v $ $Revision: 1.3 $ $Date: 92/03/13 18:31:25 $"
#endif
#endif
/*
 * (c) Copyright 1990 Conor P. Cahill (uunet!virtech!cpcahil).  
 * You may copy, distribute, and use this software as long as this
 * copyright statement is not removed.
 */

#include <stdio.h>
#include "Malloc.h"

#ifdef _NO_PROTO
char *memccpy(ptr1, ptr2, ch, len)
register char *ptr1;
register char *ptr2;
int ch;
int len;
#else  /* _NO_PROTO */
char *memccpy(register char *ptr1, register char *ptr2, int ch, int len)
#endif /* _NO_PROTO */
{
  int check;
  register int i;
  char *rtn;

  /*
   * I know that the assignment could be done in the following, but
   * I wanted to perform a check before any assignment, so first I 
   * determine the length, check the pointers and then do the assignment.
   */

  for( i=0; (i < len) && (ptr2[i] != ch); i++)
    {
    }
  if( ptr2[i] == ch )
    {
      check = i+1;
    }
  else
    {
      check = len;
    }

  if (m_check_string)
    {
      malloc_check_data("memccpy", ptr1, check);
      malloc_check_data("memccpy", ptr2, check);
    }
	
  /*
   * if we found the character...
   */

  if( i < len )
    {
      rtn = ptr1+i+1;
      i++;
    }
  else
    {
      rtn = (char *) 0;
    }

  while( i-- )
    {
      *(ptr1++) = *(ptr2++);
    }
	
  return(rtn);
}

#ifdef _NO_PROTO
char *memchr(ptr1,ch,len)
register char	*ptr1;
register int ch;
int len;
#else  /* _NO_PROTO */
char *memchr(register char *ptr1, register int ch, int len)
#endif /* _NO_PROTO */
{
  int i;

  for( i=0; (i < len) && (ptr1[i] != (char) ch); i++)
    {
    }

  if (m_check_string)
    malloc_check_data("memchr", ptr1, i);

  if( i < len )
    {
      return( ptr1+i );
    }
  else
    {
      return( (char *) 0);	
    }
}

#ifdef _NO_PROTO
char *memcpy(ptr1, ptr2, len)
register char	* ptr1;
register char	* ptr2;
register int	  len;
#else  /* _NO_PROTO */
char *memcpy(register char *ptr1, register char *ptr2, register int len)
#endif /* _NO_PROTO */
{
  char		* rtn = ptr1;

  if (m_check_string)
    {
      malloc_check_data("memcpy", ptr1, len);
      malloc_check_data("memcpy", ptr2, len);
    }
	
  /*
   * while the normal memcpy does not guarrantee that it will 
   * handle overlapping memory correctly, we will try...
   */

  if( ptr1 > ptr2  && ptr1 < (ptr2+len))
    {
      ptr1 += (len-1);
      ptr2 += (len-1);
      while( len-- > 0 )
	{
	  *(ptr1--) = *(ptr2--);
	}
    }
  else
    {
      while( len-- > 0 )
	{
	  *(ptr1++) = *(ptr2++);
	}
    }
	
  return(rtn);
}

#ifdef _NO_PROTO
size_t memcmp(ptr1, ptr2, len)
register char	* ptr1;
register char	* ptr2;
register int	  len;
#else  /* _NO_PROTO */
size_t memcmp(register char *ptr1, register char *ptr2, register int len)
#endif /* _NO_PROTO */
{
  if (m_check_string)
    {
      malloc_check_data("memcmp", ptr1, len);
      malloc_check_data("memcmp", ptr2, len);
    }

  while( --len >= 0 && (*ptr1 == *ptr2) )
    {
      ptr1++;
      ptr2++;
    }

  /*
   * If stopped by len, return 0
   */

  if (len < 0)
    {
      return (0);
    }

  return( *ptr1 - *ptr2 );
}

#ifdef _NO_PROTO
char *memset(ptr1, ch, len)
register char	*ptr1;
register int  ch;
register int  len;
#else  /* _NO_PROTO */
char *memset(register char *ptr1, register int ch, register int len)
#endif /* _NO_PROTO */
{
  char *rtn = ptr1;

  if (m_check_string)
    malloc_check_data("memset", ptr1, len);

  while( len-- )
    {
      *(ptr1++) = ch;
    }

  return(rtn);
}

#ifdef _NO_PROTO
char *bcopy(ptr2,ptr1,len)
char *ptr2;
char *ptr1;
int len;
#else  /* _NO_PROTO */
char *bcopy(char *ptr2, char *ptr1, int len)
#endif /* _NO_PROTO */
{
  return(memcpy(ptr1,ptr2,len));
}

#ifdef _NO_PROTO
char *bzero(ptr1,len)
char	* ptr1;
int	  len;
#else  /* _NO_PROTO */
char *bzero(char *ptr1, int len)
#endif /* _NO_PROTO */
{
  return(memset(ptr1,'\0',len));
}

#ifdef _NO_PROTO
int bcmp(ptr2, ptr1, len)
char *ptr1;
char *ptr2;
int  len;
#else  /* _NO_PROTO */
int bcmp(char *ptr1, char *ptr2, int len)
#endif /* _NO_PROTO */
{
  return( memcmp(ptr1,ptr2,len) );
}


