/* 
 * (c) Copyright 1989, 1990, 1991, 1992 OPEN SOFTWARE FOUNDATION, INC. 
 * ALL RIGHTS RESERVED 
*/ 
/* 
 * Motif Release 1.2
*/ 
#ifdef REV_INFO
#ifndef lint
static char rcsid[] = "$RCSfile: MallocInit.c,v $ $Revision: 1.3 $ $Date: 92/03/13 18:31:04 $"
#endif
#endif
/*
 * FILE: MallocInit.c
 * (Based on Conor Cahill's Malloc Library - see copyright statement)
 *
 * (c) Copyright 1990 Conor P. Cahill (uunet!virtech!cpcahil).  
 * You may copy, distribute, and use this software as long as this
 * copyright statement is not removed.
 */

#include <stdio.h>
#include <signal.h>
#include "Malloc.h"

/* #include <Xm/Xm.h> */
/* #include <X11/Xatom.h> */
/* #include <Xm/Protocols.h> */
/* void close_handler(); */ 

#ifdef _NO_PROTO
static int Mallopt();
static int m_parse();
#else
static int Mallopt(int cmd, char *value);
static int m_parse(char *str);
#endif

/*
 * Function:    MallocInit()
 *
 * Purpose:     To initialize the pointers and variables use by the
 *	        malloc() debugging library
 *
 * Arguments:   shell_widget - not used any more
 *              display_id - not used anymore
 *
 * Returns:     Void
 *
 * Narrative:	Just initialize all the needed variables.  Specify any
 *              signals to trap.  Use Mallopt to set any options taken
 *		from the environment.
 */

#ifdef _NO_PROTO
void MallocInit()
#else /* _NO_PROTO */
void MallocInit()
#endif /* _NO_PROTO */

/* Widget shell_widget;
   Display *display_id; */
{
  
  char *cptr;				
  char *getenv();

  /*
   * If already initialized...
   */

  if (malloc_inited) { return; }

  malloc_outfd = fileno(stderr);

  /*
   *  Establish signals - attempt to call MallocExit whenever task exits
   *   Note: this overrides any previously defined signals
   */

  signal(SIGHUP, MallocExit);
  signal(SIGINT, MallocExit);
  signal(SIGQUIT, MallocExit);
  signal(SIGKILL, MallocExit);
  signal(SIGTERM, MallocExit);
  signal(SIGSEGV, MallocExit);

  /* 
   *  Trap the window menu "Close" 
   *    NOTE:  not anymore!  (can uncomment all commented code to 
   *    change this)
   */

  /*
   * Intern the atom for DELETE WINDOW
   */

/*  delwin_atom = XmInternAtom(display_id, "WM_DELETE_WINDOW", False);
 */

  /*
   * Add the protocols to the window manager
   */

/*  XmAddWMProtocols(
		   shell_widget,   
		   &delwin_atom,   
		   1);             
*/

/*  XmAddWMProtocolCallback(
			  shell_widget,
			  delwin_atom, 
			  close_handler
			  NULL);        
*/

  /*
   *  Set up malloc tracking.  Initialize malloc root pointer.
   */

  malloc_root = NULL;  

  /*
   *  Set up environment variables
   *   Those currently looked at:
   *       MALLOC_ALLOC_CHAR
   *       MALLOC_FREE_CHAR
   *       MALLOC_OUT_FILE
   *       MALLOC_END_DUMP
   *       MALLOC_LOG_INFO
   */

  /*
   *  If the user specified a character to be filled when memory
   *   is allocated, note this.
   */

  if ((cptr=getenv("MALLOC_ALLOC_CHAR")) != NULL)
    {  m_alloc_char = cptr[0]; }

  /*
   *  If the user specified a character to be filled when memory
   *   is freed, note this.
   */

  if ((cptr=getenv("MALLOC_FREE_CHAR")) != NULL)
    { m_free_char = cptr[0]; }

  /*
   *  Override stdout, put output to this file
   */

  if ((cptr=getenv("MALLOC_OUT_FILE")) != NULL)
    { Mallopt(MALLOC_OUT_FILE, cptr); }	

  /*
   *  Check for any other env variables 
   */

  if ((cptr=getenv("MALLOC_END_DUMP")) != NULL)
    { Mallopt(MALLOC_END_DUMP, cptr); }

  if ((cptr=getenv("MALLOC_LOG_INFO")) != NULL)
    { Mallopt(MALLOC_LOG_INFO, cptr); }

  if ((cptr=getenv("MALLOC_CHECK_STRING")) != NULL)
    { Mallopt(MALLOC_CHECK_STRING, cptr);  }

  /*
   *  Can progress malloc tracking
   */

  malloc_inited = True;
  bytes_in_use = 0;
  alloc_requests_in_use = 0;
  total_bytes_allocated = 0;
  total_alloc_requests = 0;
  return;
}

/* 

void close_handler(w, client_data, ev)
Widget w;
caddr_t client_data;
XEvent *ev;
{
  XClientMessageEvent *cm_ev;

  if (ev->type == ClientMessage)
    {
      cm_ev = (XClientMessageEvent*)ev;

      if (cm_ev->data.l[0] == delwin_atom)
	{
	  MallocExit();
	}
    }
}  
*/

/*
 * Function:	Mallopt()
 *
 * Purpose:	to set options for the malloc debugging library
 *
 * Arguments:	cmd - which option
 *		value - option value
 *
 * Returns:	nothing of any value
 *
 * Narrative:	Note that malloc_outfd has been initialized to stdout 
 *              before entering this function
 *
 */

#ifdef _NO_PROTO
static int Mallopt(cmd,value)
int cmd;
char *value;
#else /* _NO_PROTO */
static int Mallopt(int cmd, char *value)
#endif /* _NO_PROTO */

{
  int i;
  char *s;
  char *type = "a+";

  switch(cmd)
    {
    case MALLOC_CHECK_STRING:
      
      /*
       *  Parse for allowable values of MALLOC_CHECK_STRING
       *   True, False, true, false, 1, 0
       */
      
      if ((i = m_parse(value)) == -1)
	m_check_string = False;  	/* set the default */
      else
	m_check_string = i;
      break;

    case MALLOC_END_DUMP:
      
      /*
       *  Parse for allowable values of MALLOC_END_DUMP:
       *   True, False, true, false, 1, 0
       */
      
      if ((i = m_parse(value)) == -1)
	m_end_dump = True;  	/* set the default */
      else
	m_end_dump = i;
      break;
      
    case MALLOC_LOG_INFO:
      
      /*
       *  Parse for allowable values of MALLOC_LOG_INFO:
       *   True, False, true, false, 1, 0
       */
      
      if ((i = m_parse(value)) == -1)
	m_log_info = False;  	/* set the default */
      else
	m_log_info = i;
      break;

    case MALLOC_OUT_FILE:

      
      /*
       *  Try to open the file.
       */

      malloc_outfp = fopen(value, type);

      /*  
       *  If not successful...
       */

      if (malloc_outfp == NULL)
	{
	  (void) write(malloc_outfd,
		       "Unable to open malloc error file: ",
		       (unsigned) 34);

	  for (s=value; *s; s++)
	    {
	      /* do nothing */;
			    }
	  (void) write(malloc_outfd,value,
		       (unsigned)(s-value));
	  (void) write(malloc_outfd,"\n",(unsigned)1);
	}
      else
	/*
	 *  Successfully opened file.  
	 */
	{
	  malloc_outfd = fileno(malloc_outfp);
	}
      
      break;

    default:
      return(1);
      break;
    }

  return(0);
}

#ifdef _NO_PROTO
static int m_parse(str)
char *str;
#else /* _NO_PROTO */
static int m_parse(char *str)
#endif /* _NO_PROTO */

{
  int count;

  count = strlen(str);
  if (count == 0) return (-1); 	/* return if nothing there */

  if ((str[0] == 'T') || (str[0] == 't'))
    {
      if (count == 4)
	{
	  return ((str[1] == 'r') && (str[2] == 'u') && (str[3] == 'e'));
	}	
      else
	{ return (-1);}
    }
  else /* first char not 'T' or 't' */

    if ((str[0] == 'F') || (str[0] == 'f'))
      {
	if (count == 5)
	  {
	    return !((str[1] == 'a') && (str[2] == 'l') &&
		     (str[3] == 's') && (str[4] == 'e'));
	  }
	else
	  { return (-1); }
      }

    else  /* first char not 'F' or 'f' */

      if (count == 1)
	{
	  if (str[0] == '1')
	    { return (True); }
	  else if (str[0] == '0')
	    { return (False); }
	}
      else
	return (-1);
}

