/* 
 * (c) Copyright 1989, 1990, 1991, 1992 OPEN SOFTWARE FOUNDATION, INC. 
 * ALL RIGHTS RESERVED 
*/ 
/* 
 * Motif Release 1.2
*/ 
#ifdef REV_INFO
#ifndef lint
static char rcsid[] = "$RCSfile: DNDLabel1.c,v $ $Revision: 1.5 $ $Date: 92/03/13 18:29:35 $"
#endif
#endif
/*
 *	File:	DNDLabel1.c
 *
 *	A program to be run as one of the clients to test Drag and Drop
 *
 */

#include <testlib.h>

/*  Global Variables  */
Widget    RowColumn1;
Widget    Label1;

Boolean	use_instruction_box;


void  main (argc, argv)
int		argc;
char	**argv;
{

    register int       n;
    Arg                args[MAX_ARGS];
    XmString           tcs;


	use_instruction_box = True;

    CommonTestInit(argc, argv);

	if (UserData != NULL)
		ProcessCommandArgs();
    
    n = 0;
    XtSetArg(args[n], XmNwidth,  400);  n++;
    XtSetArg(args[n], XmNheight, 300);  n++;
    XtSetValues(Shell1, args, n);

    XtRealizeWidget(Shell1);

    /* create and realize a rowcolumn container widget */
    n = 0;
    XtSetArg(args[n], XmNisAligned, FALSE);  n++;
    RowColumn1 = XmCreateRowColumn(Shell1, "RowColumn1", args, n);
    XtManageChild(RowColumn1);

    /* make a string label widget */
    n = 0;
    tcs = XmStringLtoRCreate("Two-Line\nLabel String", 
							 XmSTRING_DEFAULT_CHARSET);
    XtSetArg(args[n], XmNlabelString, tcs);  n++;
    XtSetArg(args[n], XmNalignment, XmALIGNMENT_CENTER); n++;
    XtSetArg(args[n], XmNrecomputeSize, TRUE); n++;
    Label1 = XmCreateLabel(RowColumn1, "Label1", args, n);
    XtManageChild(Label1);

	XtFree((char *)tcs);

	if (use_instruction_box == True) {

		CommonPause();

	}

    XtAppMainLoop(app_context);

}


#define	WORD_LEN	32

ProcessCommandArgs()
{

	char	*user_data;
	char	next_word[WORD_LEN + 1];
	int     num_spaces;

	user_data = UserData;

	while (*user_data != '\0') {

		get_next_word(user_data, next_word, &num_spaces);
		user_data += (strlen(next_word) + num_spaces);

		if (strcmp(next_word, "-noinstruct") == 0) {
			use_instruction_box = False;
			continue;

		}

	}

	free(UserData);

}


get_next_word(source, dest, spaces)
char	*source;
char	*dest;
int		*spaces;
{

	int	n;
	int	space_count;

	space_count = 0;

	while (isspace(*source)) {
		source++;
		space_count++;
	}

	n = 0;
	while (!isspace(*source) && *source != '\0' && n < WORD_LEN) {
		*dest++ = *source++;
		n++;
	}
	*dest = '\0';
	*spaces = space_count;

}
