#!/bin/sh
#
# Copyright (c) 1990,1991, OPEN SOFTWARE FOUNDATION, INC.
# ALL RIGHTS RESERVED
#
# $Header: /project/docsrc/src/sml/RCS/sml_tree.sh,v 1.5 91/11/26 12:07:32 bowe Exp $
#
# Translation of all subdirectories from $1 (or current directory)
# to parallel tree in $1/sml (or $2).
# *.mm is translated in sml, and man[1-8]/* in rsml,
# all other files are copied, all logs concatanated in cat.log
#
#set -x
DEFAULT_DTE_LIBDIR=/project/tools/libdata

if [ -z "$DTE_LIBDIR" ] ; then DTE_LIBDIR=$DEFAULT_DTE_LIBDIR ; fi
if [ -z "$SML_DIR" ]    ; then SML_DIR=$DTE_LIBDIR/sml ; fi

if [ ! -d "$SML_DIR" ] ; then
    echo "Could not find sml data files.  $SML_DIR does not exist."
    exit 1
fi
export SML_DIR

#if [ -z "$SML_SHARE_DIR" ] ; then
#	SML_SHARE_DIR=/project/docsrc/bin
#fi
export SML_SHARE_DIR

SOURCE=`pwd`
if [ "$#" != 0 ]; then
	SOURCE=$1
fi
current=`pwd`
full=`echo $SOURCE | sed -e 's/^\/\(.*\)//`
if [ "$full" != "" ]; then
	SOURCE=$current/$SOURCE
fi
#tail=`echo $SOURCE | sed -e 's/.*\///'`
#L_ROOT="$SOURCE"
#NEW_DIR=$L_ROOT/SML/$tail
NEW_DIR=$SOURCE/SML
if [ $# -gt 1 ]; then
	NEW_DIR=$2
	if [ ! -d $NEW_DIR ]; then
		mkdir $NEW_DIR
	fi
fi
full=`echo $NEW_DIR | sed -e 's/^\/\(.*\)//`
if [ "$full" != "" ]; then
	NEW_DIR=$current/$NEW_DIR
fi
#set -x
if [ "${LOG_DIR+1}" != 1 ]; then
	LOG_DIR=$SOURCE
	if [ -r $LOG_DIR/cat.log ]; then
		rm $LOG_DIR/cat.log
		echo " " > $LOG_DIR/cat.log
	fi
	mkdir $NEW_DIR
fi
#set -
export LOG_DIR
from_dir="$SOURCE"
to_dir="$NEW_DIR"
cd $from_dir
from_list=`ls`
#set -x
for work in $from_list; do
	if [ ! -d "$work" ]; then
		case "$work" in
			*.mm)
#
#		translate *.mm files to sml
#
				sml_trans.bin -f -out $to_dir/$work \
				-synt $SML_DIR/sml.desc -old $SML_DIR/mm.desc $work
				cat SML.log >> $LOG_DIR/cat.log
			;;
		*.[1-8])
#
#		translate man pages to rsml
#
			sml_trans.bin -f -old $SML_DIR/man.desc \
			-synt $SML_DIR/rsml.desc -out $to_dir/$work $work
			cat SML.log >> $LOG_DIR/cat.log
			;;
		*)	
			cp $work $to_dir/$work
			;;
		esac
	else
		if [ "$from_dir/$work" != "$to_dir" ]; then
			mkdir $to_dir/$work
			if [ "$work" = "Sync" ]; then
				cp -r $work $to_dir/$work
			else
#				$SML_SHARE_DIR/$0 $from_dir/$work $to_dir/$work
				$0 $from_dir/$work $to_dir/$work
			fi
		fi
	fi
done
#set -
echo All set for $SOURCE and $NEW_DIR
