#!/bin/sh

#  Copyright (c) 1991, OPEN SOFTWARE FOUNDATION, INC.
#  ALL RIGHTS RESERVED
#
#  Shell program to scale and add cut marks to PS (EPS) file produced
#  by Elan's troff/eps.
#
#  J.Bowe, June 1991  (K.Flowers did the original PS part)
#
#  $Header: /project/docsrc/src/dte/RCS/add-cutmark.sh,v 1.1 91/07/03 08:41:43 bowe Exp $

scale="0.82"
width="7.97"
height="10.84"
edit=false
verbose=false
help=false

files=""

while [ $# -gt 0 ] ; do
    case "$1" in
	-edit)	edit=true		;;
	-scale)	shift ; scale="$1"	;;
	-w)	shift ; width="$1"	;;
	-h)	shift ; height="$1"	;;
	-v)	verbose=true		;;
	-help)	help=true		;;
	*)	files="$files $1"	;;
    esac
    shift
done

if $help ; then
    cmd=`basename $0`
    cat <<E-O-F
Usage: $cmd [ -scale <scale> ] [ file ... ]
    This will scale and add cut marks to PostScript files created with
    Elan's eps program.  This aids in production.  By default, output
    is sent to stdout.

Options:
    -edit	edit the files on the command line.
		[ default is to send to stdout ]
    -scale S	set scale to S  [ default 0.82 ]
    -help	print this help message
Examples:
    $cmd file1.ps file2.ps | lpr
    $cmd -edit *.ps
E-O-F
    exit 0
fi

stmp=/tmp/sed-$$.cut
ptmp=/tmp/ps-$$.cut

trap "rm -f $stmp ; exit $?" 0 1 2 3 4 15

cat >$stmp <<E-O-F
/0.2400 dup scale/{
a\\
$scale $scale scale
n
a\\
% ------------------------\\
300 300 translate\\
/cutmarks {\\
% bottom left\\
-.53 inch .5 inch sub -.53 inch moveto\\
-.53 inch .25 inch sub -.53 inch lineto\\
-.53 inch -.53 inch .5 inch sub moveto\\
-.53 inch -.53 inch .25 inch sub lineto\\
% bottom right\\
$width inch .5 inch add -.53 inch moveto\\
$width inch .25 inch add -.53 inch lineto\\
$width inch -.53 inch .5 inch sub moveto\\
$width inch -.53 inch .25 inch sub lineto\\
% top left\\
-.53 inch .5 inch sub $height inch moveto\\
-.53 inch .25 inch sub $height inch lineto\\
-.53 inch $height inch .5 inch add moveto\\
-.53 inch $height inch .25 inch add lineto\\
% top right\\
$width inch .5 inch add $height inch moveto\\
$width inch .25 inch add $height inch lineto\\
$width inch $height inch .5 inch add moveto\\
$width inch $height inch .25 inch add lineto\\
stroke } def\\
/*showpage /showpage load def\\
/showpage { cutmarks *showpage } def\\
% ------------------------
b done
}
: done
/./{
n
b done
}
E-O-F

if [ -z "$files" -o "$files" = "-" ] ; then
    cat $f | sed -f $stmp
else
    for f in $files ; do
	if $verbose ; then echo "Processing $f" >/dev/tty ; fi
	if $edit ; then
	    sed -f $stmp $f > $ptmp
	    mv $ptmp $f
	else
	    sed -f $stmp $f
	fi
    done
fi

