.H 2 "Hyphens"
.iX "hyphens"
.iX "punctuation" "hyphens"
.iX "-;" "dashes" "hyphens"
.P
Use hyphens in the following situations:
.BL 
.LI
Hyphenate an adjectival compound if it begins with 
any of the following combining forms: 
.TS 
tab(@);
lw(1.25i) l.
.sp 4p
quasi-@quasi-official document
all-@all-inclusive code
cross-@The listing is cross-referenced.
self-@The program is self-indexing.
half-@The code is half-written
.sp 6p
.TE
.R
.LI
Do not hyphenate an adjective and
noun used as an adjective if both parts have all uppercase letters.  
.DS 1
the ANSI COBOL standard
.DE
.LI
Hyphenate an adjectival phrase when it precedes
the noun it modifies.  
.DS 1
State-of-the-art design is a major objective in the plan.
.DE
.LI
Avoid using a prefix with hyphenated or compound words.  Rewrite
the sentence without the compound term.
.TS 
tab(@);
lw(2.5i) l.
.sp 4p
non-computer-using banks@banks that do not use computers
non-file-oriented device@a device that is not file-oriented
.sp 6p
.TE
.R
.LI
Do not hyphenate an adverb-adjective compound in
which the adverb cannot be misread as a simple adjective that modifies
the noun. 
.DS 1
less frequently used utility
.DE
.LI
Do not hyphenate a compound that is made up of an adverb that ends in
.I -ly
followed by a participle or adjective.
.DS 1
a frequently used utility
a highly complex program
.DE
.iX "numbers" "punctuating"
.iX "punctuating" "numbers"
.iX "hyphenating" "numbers"
.LI
Hyphenate a fraction written as words.
.iX "hyphenating" "fractions"
.iX "fractions" "hyphenating"
.DS 1
three-fourths
one and one-half
one-third
.DE
.LI
In tables and figures, use a hyphen to indicate a range of numbers. 
.iX "numbers" "in tables"
.iX "numbers" "in figures"
.iX "tables" "numbers in"
.iX "figures" "numbers in"
.DS 1
12-20
.DE
.LI
Use a hyphen between a number and word combined to form a unit modifier.
.DS 1
4-digit format
24-hour notation
.DE
.LI
Do not use a hyphen with the following prefixes:
.TS 
tab(@);
lw(.5i) lw(2.0i) lw(.5i) l.
.sp 4p
anti@antilogarithm@multi@multiprogramming
bi@bidirectional@non@nonexistent
co@coexist@over@overlay
dis@disassemble@pre@preassembler
extra@extracurricular@pseudo@pseudodevice
infra@infrared@re@reedit
inter@interrecord@re@resubmit
intra@intrastate@sub@subprogram
macro@macrograph@super@superset
micro@microprocessor@ultra@ultrasound
mid@midrange@un@unconditional
mis@miscalculate@@
.sp 6p
.TE
.R
.LI
If the prefix ends in the same letter as the first letter of the
root word, retain the first letter of the root word.  Do not hyphenate.  
.TS 
tab(@);
lw(1.5i) l.
.sp 4p
enter@reenter
numeric@nonnumeric
record@interrecord
ride@override
satisfied@dissatisfied
.sp 6p
.TE
.R
.P
Exceptions to this rule are the prefixes
.I anti
and
.I multi .  
These two prefixes require a hyphen when the root word
begins with an
.I i .  
.TS 
tab(@);
lw(1.5i) l.
.sp 4p
inflation@anti-inflation
integration@anti-integration
industry@multi-industry
.sp 6p
.TE
.R
.LI
Hyphenate prefixed words if the root element is all uppercase letters,
an initial capital letter, a number expressed as a figure, or if 
the root element is a hyphenated compound.
.DS 1
non-ASCII code
non-English speaking
pre-200 series
non-direct-vector
.DE
.LI
Use a hyphen if adding a prefix to a word results in a homograph 
whose meaning would otherwise be unclear. 
.TS 
tab(@);
lw(1.25i) l.
.sp 4p
re-collect@recollect
re-cover@recover
re-create@recreate
re-search@research
re-solve@resolve
re-store@restore
.sp 6p
.TE
.R
.P
However, avoid using hyphenated constructions. These can cause 
problems in translation.
.LE
.H 2 "Imperative "
.iX "imperative"
.iX "-:" "imperative" "tense"
.iX "mood"
.P
Use the imperative to give directions. 
.DS 1
Follow the steps outlined in Section 5.1.
Enter your username and password.
.DE
.H 2 "Its"
.iX "Its"
.P
.I Its
is the possessive pronoun of it.  Use it when you are
referring to the possessive of a third person, singular, neuter pronoun.
.DS 1
The program is very big, so its execution time is long.
Because the disk is very sensitive, its protective envelope is lead-coated.
.DE
.P
.I It's
is a contraction for 
.I "it is" .
OSF documentation avoids the use of contractions; use
.I "it is" .
