/*
 * 5799-WZQ (C) COPYRIGHT = NONE
 * LICENSED MATERIALS - PROPERTY OF IBM
 */
/* $Header:mailstats.c 12.0$ */
/* $ACIS:mailstats.c 12.0$ */
/* $Source: /ibm/acis/usr/src/usr.lib/sendmail/aux/RCS/mailstats.c,v $ */

#ifndef lint
static char *rcsid = "$Header:mailstats.c 12.0$";
#endif

#include <sys/nfs_defines.h>

/*
**  Sendmail
**  Copyright (c) 1983  Eric P. Allman
**  Berkeley, California
**
**  Copyright (c) 1983 Regents of the University of California.
**  All rights reserved.  The Berkeley software License Agreement
**  specifies the terms and conditions for redistribution.
*/

#ifndef lint
char copyright[] =
"@(#) Copyright (c) 1980 Regents of the University of California.\n\
 All rights reserved.\n";
#endif not lint

#ifndef YP

#ifndef lint
static char	SccsId[] = "@(#)mailstats.c	5.3 (Berkeley) 5/2/86";
#endif not lint


# include "../src/sendmail.h"
# include "../src/mailstats.h"

/*
**  MAILSTATS -- print mail statistics.
**
**	Flags:
**		-Ffile		Name of statistics file.
**
**	Exit Status:
**		zero.
*/

main(argc, argv)
	char  **argv;
{
	register int fd;
	struct statistics stat;
	char *sfile = "/usr/lib/sendmail.st";
	register int i;
	extern char *ctime();


	fd = open(sfile, 0);
	if (fd < 0)
	{
		perror(sfile);
	}
	if (read(fd, &stat, sizeof stat) != sizeof stat ||
	    stat.stat_size != sizeof stat)
	{
		(void) fprintf(stderr, "File size change\n");
		exit(EX_OSERR);
	}

	printf("Statistics from %s", ctime(&stat.stat_itime));
	printf(" M msgsfr bytes_from  msgsto   bytes_to\n");
	for (i = 0; i < MAXMAILERS; i++)
	{
		if (stat.stat_nf[i] == 0 && stat.stat_nt[i] == 0)
			continue;
		printf("%2d ", i);
		printf("%6ld %10ldK ", stat.stat_nf[i], stat.stat_bf[i]);
		printf("%6ld %10ldK\n", stat.stat_nt[i], stat.stat_bt[i]);
	}
}

#else !YP

/* @(#)mailstats.c	1.3 87/09/08 3.2/4.3NFSSRC */
# include <sys/types.h>
# include <sys/stat.h>
# include <stdio.h>
# include "../src/conf.h"
# include "mailstats.h"

#ifndef lint
static char sccsid[] = "@(#)mailstats.c 1.4 86/07/16 SMI"; /* From UCB 4.1 7/25/83 */
#endif

/*
**  MAILSTATS -- print mail statistics.
**
**	Arguments: 
**		file		Name of statistics file.
**
**	Exit Status:
**		zero.
*/

main(argc, argv)
	char  **argv;
{
	register int fd;
	struct statistics st;
	char *sfile = "/etc/sendmail.st";
	register int i;
	struct stat sbuf;
	extern char *ctime();

	if (argc > 1) sfile = argv[1];

	fd = open(sfile, 0);
	if (fd < 0)
	{
		perror(sfile);
		exit(1);
	}
	fstat(fd, &sbuf);
	if (read(fd, &st, sizeof st) != sizeof st ||
	    st.stat_size != sizeof st)
	{
		(void) sprintf(stderr, "File size change\n");
		exit(1);
	}

	printf("Mail statistics from %24.24s", ctime(&st.stat_itime));
	printf(" to %s\n", ctime(&sbuf.st_mtime));
	printf("  Mailer   msgs from  bytes from    msgs to    bytes to\n");
	for (i = 0; i < MAXMAILERS; i++)
	{
		if (st.stat_nf[i] == 0 && st.stat_nt[i] == 0)
			continue;
		printf("%2d %-10s", i, st.stat_names[i]);
		if (st.stat_nf[i])
		  printf("%6ld %10ldK ", st.stat_nf[i], st.stat_bf[i]);
		else
		  printf("                   ");
		if (st.stat_nt[i])
		  printf("%10ld %10ldK\n", st.stat_nt[i], st.stat_bt[i]);
		else
		  printf("\n");
	}
}

#endif !YP
