/*
 * 5799-WZQ (C) COPYRIGHT = NONE
 * LICENSED MATERIALS - PROPERTY OF IBM
 */
/* $Header:tanh.c 12.0$ */
/* $ACIS:tanh.c 12.0$ */
/* $Source: /ibm/acis/usr/src/usr.lib/libom/RCS/tanh.c,v $ */

#ifndef lint
static char *rcsid = "$Header:tanh.c 12.0$";
#endif

/*	@(#)tanh.c	4.1	12/25/82	*/

/*
	tanh(arg) computes the hyperbolic tangent of its floating
	point argument.

	sinh and cosh are called except for large arguments, which
	would cause overflow improperly.
*/

double sinh(), cosh();

double
tanh(arg)
double arg;
{
	double sign;

	sign = 1.;
	if(arg < 0.){
		arg = -arg;
		sign = -1.;
	}

	if(arg > 21.)
		return(sign);

	return(sign*sinh(arg)/cosh(arg));
}
