/* $Header:atrig.c 12.0$ */
/* $ACIS:atrig.c 12.0$ */
/* $Source: /ibm/acis/usr/src/usr.lib/libm/IEEE/RCS/atrig.c,v $ */

#ifndef lint
static char *rcsid = "$Header:atrig.c 12.0$";
#endif

/* 
 * Copyright (c) 1985 Regents of the University of California.
 * 
 * Use and reproduction of this software are granted  in  accordance  with
 * the terms and conditions specified in  the  Berkeley  Software  License
 * Agreement (in particular, this entails acknowledgement of the programs'
 * source, and inclusion of this notice) with the additional understanding
 * that  all  recipients  should regard themselves as participants  in  an
 * ongoing  research  project and hence should  feel  obligated  to report
 * their  experiences (good or bad) with these elementary function  codes,
 * using "sendbug 4bsd-bugs@BERKELEY", to the authors.
 */

#ifndef lint
static char sccsid[] = "%W% (Berkeley) %G%";
#endif not lint


/* ASIN(X), ACOS(X), ATAN(X)
 * RETURN ARC SINE, ARC COS, AND ARC TANGENT OF X
 * DOUBLE PRECISION (IEEE DOUBLE 53 bits, VAX D FORMAT 56 bits)
 * CODED IN C BY K.C. NG, 4/16/85. 
 *
 * Required system supported functions:
 *	copysign(x,y)
 *	sqrt(x)
 *
 * Required kernel function:
 *	atan2(y,x) 
 *
 * Method :                  
 *	asin(x) = atan2(x,sqrt(1-x*x)); for better accuracy, 1-x*x is 
 *		  computed as follows
 *			1-x*x                     if x <  0.5, 
 *			2*(1-|x|)-(1-|x|)*(1-|x|) if x >= 0.5.
 *
 *			      ________
 *                           / 1 - x
 *	acos(x) = 2*atan2(  / -------- , 1 ) .
 *                        \/   1 + x
 *
 *	atan(x) = atan2(x,1.0). 
 *
 * Special cases:
 *	if x is NaN, return x itself;
 *	if |x|>1, asin(x) and acos(x) return NaN.
 *
 * Accuracy:
 * 1)  If atan2() uses machine PI, then
 * 
 *	atrig(x) returns (PI/pi) * (the exact atrig of x) nearly rounded,
 *	where atrig is one of acos, asin, or atan; and PI is the exact pi
 *	rounded to machine precision (see atan2 for details):
 *
 *	in decimal:
 *		pi = 3.141592653589793 23846264338327 ..... 
 *    53 bits   PI = 3.141592653589793 115997963 ..... ,
 *    56 bits   PI = 3.141592653589793 227020265 ..... ,  
 *
 *	in hexadecimal:
 *		pi = 3.243F6A8885A308D313198A2E....
 *    53 bits   PI = 3.243F6A8885A30  =  2 * 1.921FB54442D18	error=.276ulps
 *    56 bits   PI = 3.243F6A8885A308 =  4 * .C90FDAA22168C2    error=.206ulps
 *	
 *	In a test run with more than 200,000 random arguments on a VAX, the 
 *	maximum observed errors in ulps (units of the last place) were
 *		acos:  2.07 ulps      (comparing (PI/pi)*(exact acos(x)));
 *		asin:  2.06 ulps      (comparing (PI/pi)*(exact asin(x)));
 *		atan:  0.86 ulps      (comparing (PI/pi)*(exact atan(x))).
 *
 * 2)  If atan2() uses true pi, then
 *
 *	atrig(x) returns the exact atrig(x) with errors below about 2 ulps.
 *
 *	In a test run with more than 1,024,000 random arguments on a VAX, the 
 *	maximum observed errors in ulps (units of the last place) were
 *		acos  :  2.15 ulps
 *		asin  :  1.99 ulps
 *		atan  :  .850 ulps
 */

#include <errno.h>
extern errno;

#ifdef VAX
static long	NaN_[] = {0x8000, 0x0};
#define NaN	(*(double *) NaN_)
#endif
static double one=1.0;

#ifdef RTFL
double _asin(x)
#else
double asin(x)
#endif
double x;
{
	double s,t,copysign(),atan2(),sqrt();
	if(isnan(x)) return(x);
	if((s=copysign(x,one)) <= one) 
	    if(s <= 0.5)
		return(atan2(x,sqrt(one-x*x)));
	    else 
		{ t=one-s; s=t+t; return(atan2(x,sqrt(s-t*t))); }

	else {
	    errno = EDOM;
#ifdef VAX
	    return (NaN);
#else
	    return((x-x)/(x-x));	/* return NaN if |x| > 1 */
#endif
	}
}

#ifdef RTFL
double _acos(x)
#else
double acos(x)
#endif
double x;
{
	double t,copysign(),atan2(),sqrt();
	if(isnan(x)) return(x);
	if(copysign(x,one) <= one) 
	{
	    if( x != -1.0) t=atan2(sqrt((one-x)/(one+x)),one);
	    else           t=atan2(one,0.0);	/* t = PI/2 */
	    return(t+t);
	}
	else {
	    errno = EDOM;
#ifdef VAX
	    return (NaN);
#else
	    return((x-x)/(x-x));	/* return NaN if |x| > 1 */
#endif
	}
}

