/* $Header:shift_l.c 12.0$ */
/* $ACIS:shift_l.c 12.0$ */
/* $Source: /ibm/acis/usr/src/usr.lib/libF77/RCS/shift_l.c,v $ */

#ifndef lint
static char *rcsid = "$Header:shift_l.c 12.0$";
#endif

/* @(#)shift_l.c	5.1 - 86/12/09 - 09:12:40 */
#include "bit.h"

/* Logically shift m k-places. If k > NBLI, m = undefined.
 * k > 0 => left shift.
 * k < 0 => right shift.
 * k = 0 => no shift.
 */

long shft_l(m,k)
long *m, *k;
{
	long l;
	short left;

	left = (*k > 0);
	l = left ? *k : -*k;

	if (l > 0 && l < NBLI)
		if (left)
			return(*m << l);
		else
			return( (*m >> l) & F77mask[NBLI - l] );
	else if (l == 0)
		return(*m);
	else return(0L);
}
