/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1986,1987,1988
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:rdb.c 12.0$ */
/* $ACIS:rdb.c 12.0$ */
/* $Source: /ibm/acis/usr/sys/standca/RCS/rdb.c,v $ */

#ifndef lint
static char *rcsid = "$Header:rdb.c 12.0$";
#endif

#include "debug.h"
#include "cmds.h"		       /* the debugger commands */
#include "../h/reboot.h"
#include "../machine/rdb.h"
#include "../machine/cpu.h"

/*
 * interface to debugger that emulates RDB
 */

int getchar_timeout = 1000000;
char getchar_char = '\r';
int iar_mask;
char save_buffer[80 * 25 * 2];	       /* room for the screen */
char *screen_save = save_buffer;       /* the save buffer */

extern int lastdebugcmd;

startup(howto,devtype)
	register howto, devtype;       /* howto=r11, devtype=r10 */
{
	static init_flag = 0;
	static first_time = 0;
	extern char edata, end;
	register char *p;

	if (!init_flag) {
		for (p = &edata; p < &end; ++p)
			*p = 0;	       /* clear BSS */
/*	init_flag = 1;			/* reset the flag */
		_init();
		init_kbd();		/* make sure keyboard init'ed */
		_init_vectors(DEBUG_IRQ); /* take just what's needed */
		mtsr(SCR_ICS, 0x81);   /* set up default ics */
		symtab = (struct symtab *) RDB_SYMTAB; /* set up symbol table pointer */
		iar_mask = 0x0fffffff; /* ignore segment number */
		lastdebugcmd = GO;     /* provide appropriate default */
		if (howto < 0 || howto > (RB_ASKNAME | RB_SINGLE | RB_NOSYNC | RB_HALT | RB_INITNAME))
			howto = RB_ASKNAME | RB_SINGLE;	/* better come up single ! */
	}
	for (;;) {
		if ((!first_time++) || howto) /* don't call debugger if first time */
			debugger();
		getchar_timeout = 0;	/* let's be paranoid */
		callabs(KERNEL_START,howto,devtype);	/* call the kernel */
	}
}

/*
 * dummy version of exit so that if the user hits ^C they don't 
 * get dumped.
 */
exit(n)
{
	beep();
}
