/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1986
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:consdefs.h 12.0$ */
/* $ACIS:consdefs.h 12.0$ */
/* $Source: /ibm/acis/usr/sys/standca/RCS/consdefs.h,v $ */

#if !defined(lint) && !defined(LOCORE)  && defined(RCS_HDRS)
static char *rcsidconsdefs = "$Header:consdefs.h 12.0$";
#endif

#ifndef DEBUGF
#include "../machine/debug.h"
#endif

#define min(x,y) x < y ? x : y
#define max(x,y) x > y ? x : y

#define CRT_1 0x3b8		       /* crt port 1 */
#define PUT_SCR_REG(reg,value) OUT(0x3b4,reg); OUT(0x3b5,value);
#define PUT_SCR_REG_C(reg,value) OUT(0x3d4,reg); OUT(0x3d5,value);     /* EGA */

#ifdef DEBUG
#define LOCAL			       /* make it external */
#else
#define LOCAL	static		       /* make it local */
#endif

extern int edebug;
#define EDEBUG(cond, stmt) DEBUGF((edebug & cond), stmt)

#if !defined(DEBOUNCE)
#define DEBOUNCE        1
#endif

#define KYB_CNTIW 0x8407		  /* 8255 control port write */
#define KYB_CNTIR 0x8406		  /* 8255 control port read */
#define KYB_READ  0x8404		  /* 8255 data read */
#define KYB_WRITE 0x8400		  /* 8255 data write */
#define KBD_ADAPTOR_RESET 0xFB		  /* adaptor reset */
#define KBD_ADAPTOR_RELEASE 0x04	  /* adaptor release */
#define CRRB	0x8c60			  /* conponent reset reg B */

#define KYB_IIC_MASK	0x0F		  /* Interrupt Ident Code Mask */
#define KYB_INT		0x08		  /* Interrupt Received bit */
#define KYB_INFO	0x08		  /* Information Interrupt */
#define KYB_DATA	0x09		  /* Keyboard data int */
#define UART_DATA	0x0A		  /* Uart data int */
#define KYB_REQD	0x0B		  /* Return requested byte int */
#define UART_BLK	0x0C		  /* Block Transfer int */
#define KYB_UNASS	0x0D		  /* Unassigned */
#define KYB_SR		0x0E		  /* Softr Reset/Completion code */
#define KYB_EC		0x0F		  /* Detected an error condition */
#define KYB_BUSY	0x10		  /* Keyboard busy bit           */

#define IID_MASK	0x07		  /* mask for Ident code */
#define KBD_INFO	0x00		  /* information */
#define KBD_DATA	0x01		  /* value for data present */
#define KBD_UART	0x02		  /* byte from UART */
#define KBD_REQ		0x03		  /* returned requested byte */
#define KBD_BLOCK	0x04		  /* block request */
#define KBD_RESERVED	0x05		  /* reserved */
#define KBD_SELF_TEST	0x06
#define KBD_ERROR	0x07
#define KBD_TIMEOUT	0x100		  /* if we have timed out */

/*    Adapter commands                                               */

#define       EXTCMD      0x00		  /*  Extended command select  */
#define	        READ_STAT 0x12		  /* Read status byte from shared mem */
#define		SP_MEDIUM	0x42	  /*  set speaker medium	   */
#define       UARTCMD     0x04		  /*  Command to uart          */
 /*  These cmds return 2 datablocks                         */
#define         RSMOUSE   0x01		  /*  Reset  mouse             */
#define         QYMOUSE   0x73		  /*  Query  mouse             */
#define       UARTCNT     0x03		  /*  Control to uart          */
#define         MSTRANS   0x08		  /*  Enable mouse for transm. */
#define       KYBDCMD     0x01		  /*  Command to kybd          */
#define         KRESET    0xFF		  /*  Keyboard reset           */
#define		KRESEND	  0xFE		  /*  Keyboard resend */
#define		KECHO	  0xEE		  /*  Keyboard echo */
/* These defines will set a list of keys to the associated type */
#define		KSETMAKE  0xFD		  /*  Set key list to Make  */
#define		KSETMKBRK 0xFC		  /*  Set make/break */
#define		KSETRPT   0xFB		  /*  Set repeat [make/break] */
#define		KSETDBRPT 0xFA		  /*  Double rate repeat/make break */
/* These defines set all keys to the assoctiated type */
#define		KALLMAKE  0xF9		  /*  Set all keys to Make  */
#define		KALLMKBRK 0xF8		  /*  All to make/break */
#define		KALLRPT   0xF7		  /*  All repeat [make/break] */
#define		KDEAFULT  0xF6		  /*  All keys to default type */
/* Other keyboard commands */
#define         KDEFDS    0xF5		  /*  Kybd default disable     */
#define         KSCAN     0xF4		  /*  Kybd start scanning      */
#define         KRPTRD    0xF3		  /*  Set Kybd Repeat Rate/Delay */
#define         READID    0xF2		  /*  Read kybd id             */
#define         KTOGMENU  0xF1		  /*  Toggle Keytype Menu      */
#define         SETLED    0xED		  /*  Set kybd LEDs            */
#define       WRRAM       0x10		  /*  Write shr RAM            */
#define       RDRAM       0x00		  /*  Read  shr RAM            */
#define       RD1C        0x1C		  /*  Read shr RAM 0x1C.     */
#define       SETFCHI     0x08		  /*  Set freq counter hi byte */
#define         FCHI      0x01		  /*  Hi frequency byte        */
#define       SETFCLO     0x09		  /*  Set freq counter lo byte */
#define         FCLO      0xAC		  /*  Lo frequency byte        */
#define       SPKRON      0x02		  /*  Turn on speaker          */
#define         SPTIME    0X04		  /*  Speaker duration         */
#define       ENKYBD      0x3B		  /*  Enable kybd mode bit 11  */
#define       ENUART      0x3C		  /*  Enable UART mode bit 12  */
#define       RDVERS      0xE0		  /*  Read version             */
#define       DSLOCK      0x2D		  /*  Disable keylock, bit 13  */
#define       CMDREJ      0x7F		  /*  Command reject received  */
#define       POER        0xFF		  /*  Power-on error report.   */
#define       INFO        0x00		  /*  Int id for information   */


#define KYB_CONFIG	0xc3		  /* 8255 configuration value */

/* Keyboard leds */
#define	      NUM_LED     0x04		  /* Num lock led             */
#define	      CAPS_LED    0x02		  /* Caps lock led            */
#define	      SCROLL_LED  0x01		  /* Scroll lock led          */

/* Flags to tell set_defualt_key_types what you want */
#define STANDARD_MENU   0
#define ALT_MENU        1

#define HAVE_REPEAT_MKBRK ALT_MENU

/*
 * following bits are in KYB_CNTIR
 */
#define KYB_IBF		0x20		  /* IBF (input buffer full?) */
#define KYB_OBF		0x80		  /* OBF (output buffer full?) */
#define CMD(cmd,data) cmd + (data <<8)	/* pack data and command */

#ifdef DEBUG
#define TRACEF(x) if (cndebug) printf x			/* cndebugging stuff */
#else
#define TRACEF(x) 					/* cndebugging stuff */
#endif
