/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1988
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:os2lib.c 12.0$ */
/* $ACIS:os2lib.c 12.0$ */
/* $Source: /ibm/acis/usr/sys/os2code/RCS/os2lib.c,v $ */

/*
 * Copyright University of Southern California, 1988
 */

#include    	<subcalls.h>
#include    	<doscalls.h>
#include	"pctype.h"
#include	"pcparam.h"
#include	"rb.h"
#include	"bios.h"
#include	"os2ioctl.h"
#include	"os2data.h"

/* translate the virtual address ( in far format ) into physical adress */
u_long
physaddr(vaddr)
char	far 	*vaddr;
{
	struct	cbcb_paddr  addrbuf;
	int	ecode;


	addrbuf.paddr = (u_long)vaddr;

	if((ecode = DOSDEVIOCTL((char far *)&addrbuf,(char far *)&addrbuf,
					GETPADDR,PCIF_CAT,pcif_handle))!= 0) {
		 return (~(u_long)0);
	}
	return (addrbuf.paddr);
}

u_long
pcif_lock(addr)
char	far 	*addr;
{
	struct	cbcb_paddr  addrbuf;
	int	ecode;


	addrbuf.paddr = (u_long)addr;

	if((ecode = DOSDEVIOCTL((char far *)&addrbuf,(char far *)&addrbuf,
					PCIF_LOCK,PCIF_CAT,pcif_handle))!= 0) {
		 return ((u_long)0);
	}
	return (addrbuf.paddr); /* handle */
}

char far *
pcif_map(paddr,size)
u_long	paddr;
u_short size;
{
	struct	map_vaddr  addrbuf;
	int	ecode;


	addrbuf.paddr = paddr;
	addrbuf.size = size;

	if((ecode = DOSDEVIOCTL((char far *)&addrbuf,(char far *)&addrbuf,
					PCIF_MAP,PCIF_CAT,pcif_handle))!= 0) {
		 return ((u_long)0);
	}
	return ((char far *)addrbuf.paddr); /* virtual address */
}

void
pcif_unlock(handle)
u_long handle;
{
	struct	cbcb_paddr  addrbuf;


	addrbuf.paddr = handle;

	DOSDEVIOCTL((char far *)&addrbuf,(char far *)&addrbuf,
					PCIF_UNLOCK,PCIF_CAT,pcif_handle);
}

u_short
pcif_get_addr(flag)
	u_short *flag;
{
	struct get_pcif_addr addr;

	DOSDEVIOCTL((char far *)&addr,(char far *)&addr,PCIF_SET_ADDR,
							PCIF_CAT,pcif_handle);
	*flag = addr.pcif_flag;
	return(addr.pcif_addr);
}

int
fatal(msg,ecode)
char	*msg;
int	ecode;

{	printf("%s: fatal error: %s - Error Code %d\n", unix_name, msg, ecode);
	exit(ecode);
}

int
pcpanic(s)

{	fatal(s,0);
}
