/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1988
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:rvice.c 12.0$ */
/* $ACIS:rvice.c 12.0$ */
/* $Source: /ibm/acis/usr/sys/afsint/RCS/rvice.c,v $ */

#ifndef lint
static char *rcsid = "$Header:rvice.c 12.0$";
#endif

#include "../h/types.h"
#include "../h/socket.h"
#include "../h/file.h"
#include "../h/stat.h"
#include "../netinet/in.h"
#include "../h/time.h"
#include "../rpc/types.h"
#include "../rpc/xdr.h"

#define R_INTERNALS	1
#include "../afs/osi.h"
#include "../afs/r.h"
#undef R_INTERNALS

#include "../afsint/rvice.h"



bool_t
xdr_ViceFid(xdrs,objp)
	XDR *xdrs;
	ViceFid *objp;
{
	if (! xdr_u_long(xdrs, &objp->Volume)) {
		return(FALSE);
	}
	if (! xdr_u_long(xdrs, &objp->Vnode)) {
		return(FALSE);
	}
	if (! xdr_u_long(xdrs, &objp->Unique)) {
		return(FALSE);
	}
	return(TRUE);
}



bool_t
xdr_AFSFid(xdrs,objp)
	XDR *xdrs;
	AFSFid *objp;
{
	if (! xdr_u_long(xdrs, &objp->Volume)) {
		return(FALSE);
	}
	if (! xdr_u_long(xdrs, &objp->Vnode)) {
		return(FALSE);
	}
	if (! xdr_u_long(xdrs, &objp->Unique)) {
		return(FALSE);
	}
	return(TRUE);
}


bool_t
xdr_ViceDataType(xdrs,objp)
	XDR *xdrs;
	ViceDataType *objp;
{
	if (! xdr_long(xdrs, objp)) {
		return(FALSE);
	}
	return(TRUE);
}




bool_t
xdr_BD(xdrs,objp)
	XDR *xdrs;
	BD *objp;
{
	if (! xdr_long(xdrs, &objp->host)) {
		return(FALSE);
	}
	if (! xdr_long(xdrs, &objp->portal)) {
		return(FALSE);
	}
	if (! xdr_long(xdrs, &objp->session)) {
		return(FALSE);
	}
	return(TRUE);
}




bool_t
xdr_RBD(xdrs,objp)
	XDR *xdrs;
	RBD *objp;
{
	if (! xdr_long(xdrs, &objp->host)) {
		return(FALSE);
	}
	if (! xdr_long(xdrs, &objp->portal)) {
		return(FALSE);
	}
	if (! xdr_long(xdrs, &objp->session)) {
		return(FALSE);
	}
	return(TRUE);
}




bool_t
xdr_ViceStatus(xdrs,objp)
	XDR *xdrs;
	ViceStatus *objp;
{
	if (! xdr_u_long(xdrs, &objp->InterfaceVersion)) {
		return(FALSE);
	}
	if (! xdr_long(xdrs, &objp->VnodeType)) {
		return(FALSE);
	}
	if (! xdr_long(xdrs, &objp->LinkCount)) {
		return(FALSE);
	}
	if (! xdr_u_long(xdrs, &objp->Length)) {
		return(FALSE);
	}
	if (! xdr_u_long(xdrs, &objp->DataVersion)) {
		return(FALSE);
	}
	if (! xdr_u_long(xdrs, &objp->Date)) {
		return(FALSE);
	}
	if (! xdr_u_long(xdrs, &objp->Author)) {
		return(FALSE);
	}
	if (! xdr_u_long(xdrs, &objp->Owner)) {
		return(FALSE);
	}
	if (! xdr_u_long(xdrs, &objp->CallBackTime)) {
		return(FALSE);
	}
	if (! xdr_u_long(xdrs, &objp->MyAccess)) {
		return(FALSE);
	}
	if (! xdr_u_long(xdrs, &objp->AnyAccess)) {
		return(FALSE);
	}
	if (! xdr_u_long(xdrs, &objp->Mode)) {
		return(FALSE);
	}
	return(TRUE);
}



bool_t
xdr_AFSFetchStatus(xdrs,objp)
	XDR *xdrs;
	AFSFetchStatus *objp;
{
	if (! xdr_u_long(xdrs, &objp->InterfaceVersion)) {
		return(FALSE);
	}
	if (! xdr_u_long(xdrs, &objp->FileType)) {
		return(FALSE);
	}
	if (! xdr_u_long(xdrs, &objp->LinkCount)) {
		return(FALSE);
	}
	if (! xdr_u_long(xdrs, &objp->Length)) {
		return(FALSE);
	}
	if (! xdr_u_long(xdrs, &objp->DataVersion)) {
		return(FALSE);
	}
	if (! xdr_u_long(xdrs, &objp->Author)) {
		return(FALSE);
	}
	if (! xdr_u_long(xdrs, &objp->Owner)) {
		return(FALSE);
	}
	if (! xdr_u_long(xdrs, &objp->CallerAccess)) {
		return(FALSE);
	}
	if (! xdr_u_long(xdrs, &objp->AnonymousAccess)) {
		return(FALSE);
	}
	if (! xdr_u_long(xdrs, &objp->UnixModeBits)) {
		return(FALSE);
	}
	if (! xdr_u_long(xdrs, &objp->ParentVnode)) {
		return(FALSE);
	}
	if (! xdr_u_long(xdrs, &objp->ParentUnique)) {
		return(FALSE);
	}
	if (! xdr_u_long(xdrs, &objp->SegSize)) {
		return(FALSE);
	}
	if (! xdr_u_long(xdrs, &objp->ClientModTime)) {
		return(FALSE);
	}
	if (! xdr_u_long(xdrs, &objp->ServerModTime)) {
		return(FALSE);
	}
	if (! xdr_u_long(xdrs, &objp->Group)) {
		return(FALSE);
	}
	return(TRUE);
}




bool_t
xdr_AFSStoreStatus(xdrs,objp)
	XDR *xdrs;
	AFSStoreStatus *objp;
{
	if (! xdr_u_long(xdrs, &objp->Mask)) {
		return(FALSE);
	}
	if (! xdr_u_long(xdrs, &objp->ClientModTime)) {
		return(FALSE);
	}
	if (! xdr_u_long(xdrs, &objp->Owner)) {
		return(FALSE);
	}
	if (! xdr_u_long(xdrs, &objp->Group)) {
		return(FALSE);
	}
	if (! xdr_u_long(xdrs, &objp->UnixModeBits)) {
		return(FALSE);
	}
	if (! xdr_u_long(xdrs, &objp->SegSize)) {
		return(FALSE);
	}
	return(TRUE);
}




bool_t
xdr_AFSCallBack(xdrs,objp)
	XDR *xdrs;
	AFSCallBack *objp;
{
	if (! xdr_u_long(xdrs, &objp->CallBackVersion)) {
		return(FALSE);
	}
	if (! xdr_u_long(xdrs, &objp->ExpirationTime)) {
		return(FALSE);
	}
	if (! xdr_u_long(xdrs, &objp->CallBackType)) {
		return(FALSE);
	}
	return(TRUE);
}



bool_t
xdr_ViceVolumeType(xdrs,objp)
	XDR *xdrs;
	ViceVolumeType *objp;
{
	if (! xdr_long(xdrs, objp)) {
		return(FALSE);
	}
	return(TRUE);
}




bool_t
xdr_DiskName(xdrs,objp)
	XDR *xdrs;
	DiskName objp;
{
	if (! xdr_opaque(xdrs, objp, 32)) {
		return(FALSE);
	}
	return(TRUE);
}




bool_t
xdr_ViceDisk(xdrs,objp)
	XDR *xdrs;
	ViceDisk *objp;
{
	if (! xdr_long(xdrs, &objp->BlocksAvailable)) {
		return(FALSE);
	}
	if (! xdr_long(xdrs, &objp->TotalBlocks)) {
		return(FALSE);
	}
	if (! xdr_DiskName(xdrs, objp->Name)) {
		return(FALSE);
	}
	return(TRUE);
}




bool_t
xdr_ViceStatistics(xdrs,objp)
	XDR *xdrs;
	ViceStatistics *objp;
{
	if (! xdr_u_long(xdrs, &objp->CurrentMsgNumber)) {
		return(FALSE);
	}
	if (! xdr_u_long(xdrs, &objp->OldestMsgNumber)) {
		return(FALSE);
	}
	if (! xdr_u_long(xdrs, &objp->CurrentTime)) {
		return(FALSE);
	}
	if (! xdr_u_long(xdrs, &objp->BootTime)) {
		return(FALSE);
	}
	if (! xdr_u_long(xdrs, &objp->StartTime)) {
		return(FALSE);
	}
	if (! xdr_long(xdrs, &objp->CurrentConnections)) {
		return(FALSE);
	}
	if (! xdr_u_long(xdrs, &objp->TotalViceCalls)) {
		return(FALSE);
	}
	if (! xdr_u_long(xdrs, &objp->TotalFetchs)) {
		return(FALSE);
	}
	if (! xdr_u_long(xdrs, &objp->FetchDatas)) {
		return(FALSE);
	}
	if (! xdr_u_long(xdrs, &objp->FetchedBytes)) {
		return(FALSE);
	}
	if (! xdr_long(xdrs, &objp->FetchDataRate)) {
		return(FALSE);
	}
	if (! xdr_u_long(xdrs, &objp->TotalStores)) {
		return(FALSE);
	}
	if (! xdr_u_long(xdrs, &objp->StoreDatas)) {
		return(FALSE);
	}
	if (! xdr_u_long(xdrs, &objp->StoredBytes)) {
		return(FALSE);
	}
	if (! xdr_long(xdrs, &objp->StoreDataRate)) {
		return(FALSE);
	}
	if (! xdr_u_long(xdrs, &objp->TotalRPCBytesSent)) {
		return(FALSE);
	}
	if (! xdr_u_long(xdrs, &objp->TotalRPCBytesReceived)) {
		return(FALSE);
	}
	if (! xdr_u_long(xdrs, &objp->TotalRPCPacketsSent)) {
		return(FALSE);
	}
	if (! xdr_u_long(xdrs, &objp->TotalRPCPacketsReceived)) {
		return(FALSE);
	}
	if (! xdr_u_long(xdrs, &objp->TotalRPCPacketsLost)) {
		return(FALSE);
	}
	if (! xdr_u_long(xdrs, &objp->TotalRPCBogusPackets)) {
		return(FALSE);
	}
	if (! xdr_long(xdrs, &objp->SystemCPU)) {
		return(FALSE);
	}
	if (! xdr_long(xdrs, &objp->UserCPU)) {
		return(FALSE);
	}
	if (! xdr_long(xdrs, &objp->NiceCPU)) {
		return(FALSE);
	}
	if (! xdr_long(xdrs, &objp->IdleCPU)) {
		return(FALSE);
	}
	if (! xdr_long(xdrs, &objp->TotalIO)) {
		return(FALSE);
	}
	if (! xdr_long(xdrs, &objp->ActiveVM)) {
		return(FALSE);
	}
	if (! xdr_long(xdrs, &objp->TotalVM)) {
		return(FALSE);
	}
	if (! xdr_long(xdrs, &objp->EtherNetTotalErrors)) {
		return(FALSE);
	}
	if (! xdr_long(xdrs, &objp->EtherNetTotalWrites)) {
		return(FALSE);
	}
	if (! xdr_long(xdrs, &objp->EtherNetTotalInterupts)) {
		return(FALSE);
	}
	if (! xdr_long(xdrs, &objp->EtherNetGoodReads)) {
		return(FALSE);
	}
	if (! xdr_long(xdrs, &objp->EtherNetTotalBytesWritten)) {
		return(FALSE);
	}
	if (! xdr_long(xdrs, &objp->EtherNetTotalBytesRead)) {
		return(FALSE);
	}
	if (! xdr_long(xdrs, &objp->ProcessSize)) {
		return(FALSE);
	}
	if (! xdr_long(xdrs, &objp->WorkStations)) {
		return(FALSE);
	}
	if (! xdr_long(xdrs, &objp->ActiveWorkStations)) {
		return(FALSE);
	}
	if (! xdr_long(xdrs, &objp->Spare1)) {
		return(FALSE);
	}
	if (! xdr_long(xdrs, &objp->Spare2)) {
		return(FALSE);
	}
	if (! xdr_long(xdrs, &objp->Spare3)) {
		return(FALSE);
	}
	if (! xdr_long(xdrs, &objp->Spare4)) {
		return(FALSE);
	}
	if (! xdr_long(xdrs, &objp->Spare5)) {
		return(FALSE);
	}
	if (! xdr_long(xdrs, &objp->Spare6)) {
		return(FALSE);
	}
	if (! xdr_long(xdrs, &objp->Spare7)) {
		return(FALSE);
	}
	if (! xdr_long(xdrs, &objp->Spare8)) {
		return(FALSE);
	}
	if (! xdr_ViceDisk(xdrs, &objp->Disk1)) {
		return(FALSE);
	}
	if (! xdr_ViceDisk(xdrs, &objp->Disk2)) {
		return(FALSE);
	}
	if (! xdr_ViceDisk(xdrs, &objp->Disk3)) {
		return(FALSE);
	}
	if (! xdr_ViceDisk(xdrs, &objp->Disk4)) {
		return(FALSE);
	}
	if (! xdr_ViceDisk(xdrs, &objp->Disk5)) {
		return(FALSE);
	}
	if (! xdr_ViceDisk(xdrs, &objp->Disk6)) {
		return(FALSE);
	}
	if (! xdr_ViceDisk(xdrs, &objp->Disk7)) {
		return(FALSE);
	}
	if (! xdr_ViceDisk(xdrs, &objp->Disk8)) {
		return(FALSE);
	}
	if (! xdr_ViceDisk(xdrs, &objp->Disk9)) {
		return(FALSE);
	}
	if (! xdr_ViceDisk(xdrs, &objp->Disk10)) {
		return(FALSE);
	}
	return(TRUE);
}




bool_t
xdr_VolumeStatus(xdrs,objp)
	XDR *xdrs;
	VolumeStatus *objp;
{
	if (! xdr_long(xdrs, &objp->Vid)) {
		return(FALSE);
	}
	if (! xdr_long(xdrs, &objp->ParentId)) {
		return(FALSE);
	}
	if (! xdr_char(xdrs, &objp->Online)) {
		return(FALSE);
	}
	if (! xdr_char(xdrs, &objp->InService)) {
		return(FALSE);
	}
	if (! xdr_char(xdrs, &objp->Blessed)) {
		return(FALSE);
	}
	if (! xdr_char(xdrs, &objp->NeedsSalvage)) {
		return(FALSE);
	}
	if (! xdr_long(xdrs, &objp->Type)) {
		return(FALSE);
	}
	if (! xdr_long(xdrs, &objp->MinQuota)) {
		return(FALSE);
	}
	if (! xdr_long(xdrs, &objp->MaxQuota)) {
		return(FALSE);
	}
	if (! xdr_long(xdrs, &objp->BlocksInUse)) {
		return(FALSE);
	}
	if (! xdr_long(xdrs, &objp->PartBlocksAvail)) {
		return(FALSE);
	}
	if (! xdr_long(xdrs, &objp->PartMaxBlocks)) {
		return(FALSE);
	}
	return(TRUE);
}




bool_t
xdr_VolumeInfo(xdrs,objp)
	XDR *xdrs;
	VolumeInfo *objp;
{
	if (! xdr_u_long(xdrs, &objp->Vid)) {
		return(FALSE);
	}
	if (! xdr_long(xdrs, &objp->Type)) {
		return(FALSE);
	}
	if (! xdr_u_long(xdrs, &objp->Type0)) {
		return(FALSE);
	}
	if (! xdr_u_long(xdrs, &objp->Type1)) {
		return(FALSE);
	}
	if (! xdr_u_long(xdrs, &objp->Type2)) {
		return(FALSE);
	}
	if (! xdr_u_long(xdrs, &objp->Type3)) {
		return(FALSE);
	}
	if (! xdr_u_long(xdrs, &objp->Type4)) {
		return(FALSE);
	}
	if (! xdr_u_long(xdrs, &objp->ServerCount)) {
		return(FALSE);
	}
	if (! xdr_u_long(xdrs, &objp->Server0)) {
		return(FALSE);
	}
	if (! xdr_u_long(xdrs, &objp->Server1)) {
		return(FALSE);
	}
	if (! xdr_u_long(xdrs, &objp->Server2)) {
		return(FALSE);
	}
	if (! xdr_u_long(xdrs, &objp->Server3)) {
		return(FALSE);
	}
	if (! xdr_u_long(xdrs, &objp->Server4)) {
		return(FALSE);
	}
	if (! xdr_u_long(xdrs, &objp->Server5)) {
		return(FALSE);
	}
	if (! xdr_u_long(xdrs, &objp->Server6)) {
		return(FALSE);
	}
	if (! xdr_u_long(xdrs, &objp->Server7)) {
		return(FALSE);
	}
	return(TRUE);
}




bool_t
xdr_ViceFetchType(xdrs,objp)
	XDR *xdrs;
	ViceFetchType *objp;
{
	if (! xdr_long(xdrs, objp)) {
		return(FALSE);
	}
	return(TRUE);
}




bool_t
xdr_ViceStoreType(xdrs,objp)
	XDR *xdrs;
	ViceStoreType *objp;
{
	if (! xdr_long(xdrs, objp)) {
		return(FALSE);
	}
	return(TRUE);
}




bool_t
xdr_ViceLockType(xdrs,objp)
	XDR *xdrs;
	ViceLockType *objp;
{
	if (! xdr_long(xdrs, objp)) {
		return(FALSE);
	}
	return(TRUE);
}




bool_t
xdr_ViceOfflineType(xdrs,objp)
	XDR *xdrs;
	ViceOfflineType *objp;
{
	if (! xdr_long(xdrs, objp)) {
		return(FALSE);
	}
	return(TRUE);
}


