/*
 * 5799-WZQ (C) COPYRIGHT = NONE
 * LICENSED MATERIALS - PROPERTY OF IBM
 */
/* $Header:getservent.c 12.0$ */
/* $ACIS:getservent.c 12.0$ */
/* $Source: /ibm/acis/usr/src/lib/libc/net/yp/RCS/getservent.c,v $ */

#ifndef lint
static char *rcsid = "$Header:getservent.c 12.0$";
#endif

#include <sys/nfs_defines.h>

#ifdef VFS

/* @(#)getservent.c	1.5 87/09/11 3.2/4.3NFSSRC */
/*
 * Copyright (c) 1983 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 */

#if defined(LIBC_SCCS) && !defined(lint)
static char sccsid[] = "@(#)getservent.c	5.3 (Berkeley) 5/19/86";
#endif LIBC_SCCS and not lint

#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>
#include <netinet/in.h>
#include "../../yp/ypclnt.h"

#define	MAXALIASES	35

static char domain[256];
static char *current = NULL;	/* current entry, analogous to servf */
static int currentlen;
static struct servent *interpret();
struct servent *getservent();
char *inet_ntoa();
static char SERVDB[] = "/etc/services";
static FILE *servf = NULL;
static int usingyellow;		/* are yellow pages up? */
static char *any();
int _serv_stayopen;

setservent(f)
	int f;
{
	if (servf == NULL)
		servf = fopen(SERVDB, "r" );
	else
		rewind(servf);
	if (current)
		free(current);
	current = NULL;
	_serv_stayopen |= f;
	yellowup(1);	/* recompute whether yellow pages are up */
}

endservent()
{
	if (current) {
		free(current);
		current = NULL;
	}
	if (servf) {
		fclose(servf);
		servf = NULL;
	}
	_serv_stayopen = 0;
}

struct servent *
getservent()
{
	int reason;
	char *key, *val;
	int keylen, vallen;
	static char line1[BUFSIZ+1];
	struct servent *sp;

	yellowup(0);
	if (!usingyellow) {
		if (servf == NULL && (servf = fopen(SERVDB, "r")) == NULL)
			return (NULL);
	        if (fgets(line1, BUFSIZ, servf) == NULL)
			return (NULL);
		return interpret(line1, strlen(line1));
	}
	if (current == NULL) {
		if (reason =  yp_first(domain, "services.byname",
		    &key, &keylen, &val, &vallen)) {
#ifdef DEBUG
			fprintf(stderr, "reason yp_first failed is %d\n",
			    reason);
#endif
			return NULL;
		    }
	}
	else {
		if (reason = yp_next(domain, "services.byname",
		    current, currentlen, &key, &keylen, &val, &vallen)) {
#ifdef DEBUG
			fprintf(stderr, "reason yp_next failed is %d\n",
			    reason);
#endif
			return NULL;
		}
	}
	if (current)
		free(current);
	current = key;
	currentlen = keylen;
	sp = interpret(val, vallen);
	return (sp);
}

static struct servent *
interpret(val, len)
{
	static char *serv_aliases[MAXALIASES];
	static struct servent serv;
	static char line[BUFSIZ+1];
	char *p;
	register char *cp, **q;

	strncpy(line, val, len);
	p = line;
	line[len] = '\n';
	if (*p == '#')
		return (getservent());
	cp = any(p, "#\n");
	if (cp == NULL)
		return (getservent());
	*cp = '\0';
	serv.s_name = p;
	p = any(p, " \t");
	if (p == NULL)
		return (getservent());
	*p++ = '\0';
	while (*p == ' ' || *p == '\t')
		p++;
	cp = any(p, ",/");
	if (cp == NULL)
		return (getservent());
	*cp++ = '\0';
	serv.s_port = htons((u_short)atoi(p));
	serv.s_proto = cp;
	q = serv.s_aliases = serv_aliases;
	cp = any(cp, " \t");
	if (cp != NULL)
		*cp++ = '\0';
	while (cp && *cp) {
		if (*cp == ' ' || *cp == '\t') {
			cp++;
			continue;
		}
		if (q < &serv_aliases[MAXALIASES - 1])
			*q++ = cp;
		cp = any(cp, " \t");
		if (cp != NULL)
			*cp++ = '\0';
	}
	*q = NULL;
	return (&serv);
}

static char *
any(cp, match)
	register char *cp;
	char *match;
{
	register char *mp, c;

	while (c = *cp) {
		for (mp = match; *mp; mp++)
			if (*mp == c)
				return (cp);
		cp++;
	}
	return ((char *)0);
}

/* 
 * check to see if yellow pages are up, and store that fact in usingyellow.
 * The check is performed once at startup and thereafter if flag is set
 */
static
yellowup(flag)
{
	static int firsttime = 1;
	char *key, *val;
	int keylen, vallen;

	if (firsttime || flag) {
		firsttime = 0;
		if (domain[0] == 0) {
			if (getdomainname(domain, sizeof(domain)) < 0) {
				domain[0] = '\0';   /* missing system call implies that */
				usingyellow = 0;    /*   we're not usingyellow */
				return;
			}
		}
		usingyellow = !yp_bind(domain);
	}
}

#endif
