/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1986
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:fgets.s 12.0$ */
/* $ACIS:fgets.s 12.0$ */
/* $Source: /ibm/acis/usr/src/lib/libc/ca/stdio/RCS/fgets.s,v $ */

	.data
rcsid:	.asciz	"$Header:fgets.s 12.0$"
	.text
			/* fgets(s, n, iop) r2 s; r3 n; r4 iop */
#define C	r0
#define S	r2	/* Same variable names as in C version, but uc. */
#define N	r3
#define IOP	r4
#define IOP_PTR r5	/* Keep iop_ptr local until filbuf is called. */
#define CS	r14
#define IOP_CNT	r15	/* Keep iop_cnt local until filbuf is called. */

#define NEWLINE	012
#define EOF	-1
#define FIRSTSVREG	r14
#define STACKDROP	44 /* ARGSV(16)+LINKSV(20)+REGSV(64)-(FIRSTSVREG*4) */
#define CNT	0
#define PTR	4
.data
.align 2		/* Start data on word boundary. */
.globl	_fgets
	_fgets:	.long _.fgets
.text
.align 2		/* Start text on word boundary. */
.globl	_.fgets
	_.fgets:
		stm	FIRSTSVREG,-STACKDROP(sp)
		ai	sp,sp,-STACKDROP	/* Drop stack ptr. */
		get	IOP_CNT,CNT(IOP)	/* load local iop->_cnt */
		get	IOP_PTR,PTR(IOP)	/* load local iop->_ptr */
		cas	CS,S,r0			/* cs = s */
	Lwhile_loop:			/* while(--n>0 && (c = getc(iop)) */
		si	N,N,1			/* --n */
		jnh	Ldone_while		/* !(n>0) goto Ldone_while */
		si	IOP_CNT,IOP_CNT,1	/* --iop->_cnt */
		jl	Lfilbuf			/* fall thru if CNT > 0. */
		lcs	C,0(IOP_PTR)		/* c = iop->_ptr */
		inc	IOP_PTR,1		/* iop->_ptr++ */
	Lfilbuf_return:
		inc	CS,1			/* cs++ */
		ci	C,NEWLINE		/* c==\n ? */
		bnex	Lwhile_loop
		stc	C,-1(CS)		/* *cs = c */	
	Ldone_while:
		c	CS,S
		jne	Lreturn
		lis	r2,0			/* Return null. */
		j	Lreturn_null	/* iop fields unchanged,
					 * return w/o storing them. */
	Lfilbuf:		/* Filbuf called ~1/25-1/50 of the time. */
		put	S,  STACKDROP-16(sp)	/* Put arg word 1 on stack. */
		put	N,  STACKDROP-12(sp)	/* Put arg word 2 on stack. */
		cas	r2,IOP,r0		/* filbuf(iop) setup */
		get	r0,$__filbuf
		balix	r15,_._filbuf
		put	IOP,STACKDROP-8(sp)	/* Put arg word 3 on stack. */
		
		cas	C,r2,r0			/* c = filbuf() */
		ci	C,EOF			/* Was an EOF returned? */
		beqx	Leof
		get	S,  STACKDROP-16(sp)	/* Restore arg word 1. */

		get	N,  STACKDROP-12(sp)	/* Restore arg word 2. */
		get	IOP,STACKDROP-8(sp)	/* Restore arg word 3. */
		get	IOP_CNT,CNT(IOP)	/* Get new local iop->_cnt */
		bx	Lfilbuf_return		/* Keep going. */
		get	IOP_PTR,PTR(IOP)	/* Get new local iop->_ptr */
	Leof:
		c	CS,S			/* Any chars put in buffer? */
		jne	Lreturn_no_newline	/* Put chars, no newline. */
		bx	Lreturn_null
		lis	r2,0			/* No chars, Return null. */
	Lreturn:
		put	IOP_CNT,CNT(IOP)	/* Put local cnt back. */
		put	IOP_PTR,PTR(IOP)	/* Put local ptr back. */
	Lreturn_no_newline:
		lis	C,0			/* tmpreg <- zero */
		stcs	C,0(CS)		/* *cs = '\0' */
/*		cas	r2,S,r0		return(s), s still in r2. */
	Lreturn_null:
		lm	FIRSTSVREG,0(sp)		
		brx	r15
		ai	sp,sp,STACKDROP		/* Restore caller's sp. */

.short 0xdf07	/* Trace table marker. */
.short 0xdfb8	/* Trace table marker, (first gpr,flags) */
.short 0x3100+STACKDROP/4	/* trace table nparams, fp, local_offset */

.data
.globl	.oVncs
.set	.oVncs, 0
