#ifndef BITSPERBYTE
/* These values work with any binary representation of integers
 * where the high-order bit contains the sign. */

/* a number used normally for size of a shift */
#define BITSPERBYTE     8
#define BITS(type)      (BITSPERBYTE * (int)sizeof(type))

/* short, regular and long ints with only the high-order bit turned on */
#define HIBITS  ((short)(1 << BITS(short) - 1))
#define HIBITI  (1 << BITS(int) - 1)
#define HIBITL  (1L << BITS(long) - 1)

/* largest short, regular and long int */
#define MAXSHORT        ((short)~HIBITS)
#define MAXINT  (~HIBITI)
#define MAXLONG (~HIBITL)
#endif
