#! /bin/sh
#
# 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1986
# LICENSED MATERIALS - PROPERTY OF IBM
# REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
#
#$Header:proff.sh 12.0$
#$ACIS:proff.sh 12.0$
#$Source: /ibm/acis/usr/src/ibm/proff/RCS/proff.sh,v $
#
# proff [-g] [-t] [-Pxx] [-Lp] [nroff parameters]
#
# drive nroff commands and filters
#	for IBM 4201 Proprinter and IBM 5152 Graphics Printer
#  -g  use Graphics printer filters
#  -t  send output to standard out
#  -Lp pass parameter p to lpr
#  -Pxx use printer xx 
#
nrdrv="-Tpro"
printer="-P${PRINTER-lp}"
type="-n"
printcmd="lpr"
lpoptions=""
options="-rb3"

for i
do
	case $i in

	"-g")
		type="-t"
		nrdrv="-Tgra"
		;;

	"-t")
		printcmd=""
		printer=""
		type=""
		;;

	-P*)
		printer=$i
		;;

	-L*)
		lpoptions="$lpoptions `echo $i | \
			 sed -e 's;-L;;' `"
		;;

	*)
		options="$options $i"
		;;
	esac
done
if [ $printcmd ]; then
	nroff $nrdrv $options | lpr $lpoptions $printer $type
else
	nroff $nrdrv $options
fi
