/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1986
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:sqzpmp.c 12.0$ */
/* $ACIS:sqzpmp.c 12.0$ */
/* $Source: /ibm/acis/usr/src/ibm/bitprt_ca/RCS/sqzpmp.c,v $ */

#ifndef lint
static char *rcsid = "$Header:sqzpmp.c 12.0$";
#endif

/* sqzpmp.c -- print a bit map image on the 3812 
 * using a compressed image format. Assumes an image font has
 * been pre-loaded or appears earlier in the output stream 
 *
 * pmpprt codes are listed by hex value in Appendix D
 * of the IBM Pageprinter 3812 Programming Reference.
 */

#include <stdio.h>
#include <sys/file.h>
#include <sys/errno.h>

#define LPIXELS	1024	/* required input-image scanline size */
static int BLOCKSIZE =  10*LPIXELS/16*2;

#define TRUE -1
#define FALSE 0
#define CH_ALLWHITE 0x01
#define CH_ALLBLACK 0x02
#define CH_ALL0GREY 0x03
#define CH_ALL1GREY 0x04
#define CH_WHITE 0x80
#define CH_BLACK 0xa0
#define CH_GREY0 0xc0
#define CH_GREY1 0xe0
#define CH_1WH 0x10
#define CH_1BL 0x40
#define CH_IMAGE 0x70
#define ST_MAXSCAN 128
#define ST_MAXIBCHAR 32
#define ST_MAXISCHAR 6
#define ST_START 0
#define ST_WHITE  1
#define ST_BLACK  2
#define ST_1WHITE 3
#define ST_1BLACK 4
#define ST_GREY0  5
#define ST_GREY1  6
#define ST_IMAGE  7
#define NO_ST 8
#define BY_WHITE  0
#define BY_BLACK  1
#define BY_1WHITE 2
#define BY_1BLACK 3
#define BY_GREY0  4
#define BY_GREY1  5
#define BY_IMAGE  6
#define BY_FULL   7
#define NO_CTYPE 8
#define NO_X  2

long twc=0;
long ic=0;
/* Static variables that remember current states */
unsigned char chrbuf[64];
int chrcnt;
struct {
	unsigned char pmphdr[3];
	unsigned char pmplen[2];
	unsigned char pmpbuf[512];
} 
redbuf;
int pmpcnt;
int ST_state=ST_START;
int ST_ichars=0;
int ST_mark=0;
int ST_full;
int ST_exit;
int ST_ctype;
unsigned char ST_char;
long CT_out[NO_CTYPE];
long CT_rep[NO_CTYPE];
long CT_in[NO_CTYPE];
int ST_ctab[256] = {
	/*00*/ BY_BLACK,BY_1WHITE,BY_1WHITE,BY_IMAGE,BY_1WHITE,BY_IMAGE,BY_IMAGE,BY_IMAGE,
	/*08*/ BY_1WHITE,BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,
	/*10*/ BY_1WHITE,BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,
	/*18*/ BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,
	/*20*/ BY_1WHITE,BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,
	/*28*/ BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,
	/*30*/ BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,
	/*38*/ BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,
	/*40*/ BY_1WHITE,BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,
	/*48*/ BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,
	/*50*/ BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_GREY0,BY_IMAGE,BY_IMAGE,
	/*58*/ BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,
	/*60*/ BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,
	/*68*/ BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,
	/*70*/ BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,
	/*78*/ BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_1BLACK,
	/*80*/ BY_1WHITE,BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,
	/*88*/ BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,
	/*90*/ BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,
	/*98*/ BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,
	/*a0*/ BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,
	/*a8*/ BY_IMAGE,BY_IMAGE,BY_GREY1,BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,
	/*b0*/ BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,
	/*b8*/ BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_1BLACK,
	/*c0*/ BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,
	/*c8*/ BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,
	/*d0*/ BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,
	/*d8*/ BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_1BLACK,
	/*e0*/ BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,
	/*e8*/ BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_1BLACK,
	/*f0*/ BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_1BLACK,
	/*f8*/ BY_IMAGE,BY_IMAGE,BY_IMAGE,BY_1BLACK,BY_IMAGE,BY_1BLACK,BY_1BLACK,
	/*ff*/ BY_WHITE };
unsigned char ST_stab[NO_ST][NO_CTYPE] = {
	ST_WHITE ,ST_BLACK ,ST_1WHITE,ST_1BLACK,ST_GREY0 ,ST_GREY1 ,ST_IMAGE,ST_START,
	/* Entries for state WHITE*/
	ST_WHITE ,ST_BLACK ,ST_1WHITE,ST_1BLACK,ST_GREY0 ,ST_GREY1 ,ST_IMAGE,ST_START,
	/* Entries for state BLACK*/
	ST_WHITE ,ST_BLACK ,ST_1WHITE,ST_1BLACK,ST_GREY0 ,ST_GREY1 ,ST_IMAGE,ST_START,
	/* Entries for state 1WHITE*/
	ST_WHITE ,ST_1WHITE,ST_1WHITE,ST_1BLACK,ST_GREY0 ,ST_GREY1 ,ST_IMAGE,ST_START,
	/* Entries for state 1BLACK*/
	ST_1BLACK,ST_BLACK ,ST_1WHITE,ST_1BLACK,ST_GREY0 ,ST_GREY1 ,ST_IMAGE,ST_START,
	/* Entries for state GREY0*/
	ST_WHITE ,ST_BLACK ,ST_1WHITE,ST_1BLACK,ST_GREY0 ,ST_GREY1 ,ST_IMAGE,ST_START,
	/* Entries for state GREY1*/
	ST_WHITE ,ST_BLACK ,ST_1WHITE,ST_1BLACK,ST_GREY0 ,ST_GREY1 ,ST_IMAGE,ST_START,
	/* Entries for state IMAGE*/
	ST_WHITE ,ST_BLACK ,ST_1WHITE,ST_1BLACK,ST_GREY0 ,ST_GREY1 ,ST_IMAGE,ST_START
};


FILE *reddev,*infile;

unsigned char pl[256]={
	0,3,12,15,48,51,60,63,192,195,204,207,240,243,252,255,
	0,3,12,15,48,51,60,63,192,195,204,207,240,243,252,255,
	0,3,12,15,48,51,60,63,192,195,204,207,240,243,252,255,
	0,3,12,15,48,51,60,63,192,195,204,207,240,243,252,255,
	0,3,12,15,48,51,60,63,192,195,204,207,240,243,252,255,
	0,3,12,15,48,51,60,63,192,195,204,207,240,243,252,255,
	0,3,12,15,48,51,60,63,192,195,204,207,240,243,252,255,
	0,3,12,15,48,51,60,63,192,195,204,207,240,243,252,255,
	0,3,12,15,48,51,60,63,192,195,204,207,240,243,252,255,
	0,3,12,15,48,51,60,63,192,195,204,207,240,243,252,255,
	0,3,12,15,48,51,60,63,192,195,204,207,240,243,252,255,
	0,3,12,15,48,51,60,63,192,195,204,207,240,243,252,255,
	0,3,12,15,48,51,60,63,192,195,204,207,240,243,252,255,
	0,3,12,15,48,51,60,63,192,195,204,207,240,243,252,255,
	0,3,12,15,48,51,60,63,192,195,204,207,240,243,252,255,
	0,3,12,15,48,51,60,63,192,195,204,207,240,243,252,255
};
unsigned char ph[256]={
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,
	12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
	15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,
	48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,
	51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,
	60,60,60,60,60,60,60,60,60,60,60,60,60,60,60,60,
	63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,
	192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,
	195,195,195,195,195,195,195,195,195,195,195,195,195,195,195,195,
	204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,204,
	207,207,207,207,207,207,207,207,207,207,207,207,207,207,207,207,
	240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,
	243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,243,
	252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,252,
	255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255
};

firstz(by)
unsigned char by;
{
	int i,b;
	b = by;
	for (i=0;i<8;i++) {
		if ( !(b & 0x80) ) return i;
		b<<=1;
	}
	fprintf(stderr,"firstz:bad return.\n");
	return -1;
}
firsto(by)
unsigned char by;
{
	int i,b;
	b = by;
	for (i=0;i<8;i++) {
		if ( (b & 0x80) ) return i;
		b<<=1;
	}
	fprintf(stderr,"firsto:bad return.\n");
	return -1;
}
stnull()
{
}
stexit()
{
	fprintf(stderr,"Exit state reached.\n");
	ST_exit= TRUE;
}
initwh()
{
	ST_ichars=1;
}
initbl()
{
	ST_ichars=1;
}
init1wh()
{
	ST_ichars=1;
	ST_mark=firsto(ST_char);
}
init1bl()
{
	ST_ichars=1;
	ST_mark=firstz(ST_char);
}
initgr0()
{
	ST_ichars=1;
}
initgr1()
{
	ST_ichars=1;
}
initim()
{
	ST_ichars=1;
	CT_out[BY_IMAGE]++;
	pmpprt(0xa0|28);  /* get binary font*/
	writim();
}
updtb()
{
	++ST_ichars;
}
updts()
{
	if (++ST_ichars >= ST_MAXISCHAR) ST_full= TRUE;
}
writwh()
{
	unsigned char och;
	int ocnt;
	while (ST_ichars > 0) {
		if (ST_ichars == 128)  {
			ocnt=128;
			och=CH_ALLWHITE;
			ST_ichars=0;
		} 
		else if (ST_ichars > ST_MAXIBCHAR) {
			ocnt=ST_MAXIBCHAR;
			och=CH_WHITE+ST_MAXIBCHAR-1;
		} 
		else {
			ocnt=ST_ichars;
			och=CH_WHITE+ST_ichars-1;
		}
		ST_ichars -= ocnt;
		CT_rep[BY_WHITE] += ocnt;
		CT_out[BY_WHITE]++;
		chrprt(och);
	}
}
writbl()
{
	unsigned char och;
	int ocnt;
	while (ST_ichars > 0) {
		if (ST_ichars == 128)  {
			ocnt=128;
			och=CH_ALLBLACK;
			ST_ichars=0;
		} 
		else if (ST_ichars > ST_MAXIBCHAR) {
			ocnt=ST_MAXIBCHAR;
			och=CH_BLACK+ST_MAXIBCHAR-1;
		} 
		else {
			ocnt=ST_ichars;
			och=CH_BLACK+ST_ichars-1;
		}
		ST_ichars -= ocnt;
		CT_rep[BY_BLACK] += ocnt;
		CT_out[BY_BLACK]++;
		chrprt(och);
	}
}
writ1wh()
{
	CT_out[BY_1WHITE]++;
	CT_rep[BY_1WHITE] += ST_ichars;
	chrprt(CH_1WH+(8*(ST_ichars-1))+ST_mark);
}
writ1bl()
{
	CT_out[BY_1BLACK]++;
	CT_rep[BY_1BLACK] += ST_ichars;
	chrprt(CH_1BL+(8*(ST_ichars-1))+ST_mark);
}
writgr0()
{
	unsigned char och;
	int ocnt;
	while (ST_ichars > 0) {
		if (ST_ichars == 128)  {
			ocnt=128;
			och=CH_ALL1GREY;
			ST_ichars=0;
		} 
		else if (ST_ichars > ST_MAXIBCHAR) {
			ocnt=ST_MAXIBCHAR;
			och=CH_GREY0+ST_MAXIBCHAR-1;
		} 
		else {
			ocnt=ST_ichars;
			och=CH_GREY0+ST_ichars-1;
		}
		ST_ichars -= ocnt;
		CT_rep[BY_GREY0] += ocnt;
		CT_out[BY_GREY0]++;
		chrprt(och);
	}
}
writgr1()
{
	unsigned char och;
	int ocnt;
	while (ST_ichars > 0) {
		if (ST_ichars == 128)  {
			ocnt=128;
			och=CH_ALL1GREY;
			ST_ichars=0;
		} 
		else if (ST_ichars > ST_MAXIBCHAR) {
			ocnt=ST_MAXIBCHAR;
			och=CH_GREY1+ST_MAXIBCHAR-1;
		} 
		else {
			ocnt=ST_ichars;
			och=CH_GREY1+ST_ichars-1;
		}
		ST_ichars -= ocnt;
		CT_rep[BY_GREY1] += ocnt;
		CT_out[BY_GREY1]++;
		chrprt(och);
	}
}
initcf()
{
	pmpprt(0xa0|29);  /*back to compressed image font*/
	CT_out[BY_IMAGE]++;
}


writim()
{
	CT_rep[BY_IMAGE]++;
	CT_out[BY_IMAGE]++;
	chrprt(ST_char);

}
int (*ST_ftab[NO_ST][NO_X][NO_CTYPE])() = {
	/* Entries for state START*/
	initwh ,initbl ,init1wh,init1bl,initgr0,initgr1,initim ,stnull,
	stnull ,stnull ,stnull ,stnull ,stnull ,stnull ,stnull ,stnull,
	/* Entries for state WHITE*/
	updtb  ,writwh ,writwh ,writwh ,writwh ,writwh ,writwh ,writwh,
	stnull ,initbl ,init1wh,init1bl,initgr0,initgr1,initim ,stnull,
	/* Entries for state BLACK*/
	writbl ,updtb  ,writbl ,writbl ,writbl ,writbl ,writbl ,writbl,
	initwh ,stnull ,init1wh,init1bl,initgr0,initgr1,initim ,stnull,
	/* Entries for state 1WHITE*/
	writ1wh,updts  ,writ1wh,writ1wh,writ1wh,writ1wh,writ1wh,writ1wh,
	initwh ,stnull ,init1wh,init1bl,initgr0,initgr1,initim ,stnull,
	/* Entries for state 1BLACK*/
	updts  ,writ1bl,writ1bl,writ1bl,writ1bl,writ1bl,writ1bl,writ1bl,
	stnull ,initbl ,init1wh,init1bl,initgr0,initgr1,initim ,stnull ,
	/* Entries for state GREY0*/
	writgr0,writgr0,writgr0,writgr0,updtb  ,writgr0,writgr0,writgr0,
	initwh ,initbl ,init1wh,init1bl,stnull ,initgr1,initim ,stnull ,
	/* Entries for state GREY1*/
	writgr1,writgr1,writgr1,writgr1,writgr1,updtb  ,writgr1,writgr1,
	initwh ,initbl ,init1wh,init1bl,initgr0,stnull ,initim ,stnull ,
	/* Entries for state IMAGE*/
	initcf ,initcf ,initcf ,initcf ,initcf ,initcf ,writim ,initcf ,
	initwh ,initbl ,init1wh,init1bl,initgr0,initgr1,stnull ,stnull };

main(argc,argv)
int argc;
char *argv[];
{
	int i,j;
	int posn;
	extern int perror(), errno; 
	unsigned short sc[10][LPIXELS/16];
	struct {
		int screenwidth;
		int screenheight;
	} 
	screensize;


#ifdef DEBUG
	fprintf(stderr,"sqzpmp started.\n");
#endif DEBUG 
	for (i=0;i<NO_CTYPE;i++) CT_in[i]=CT_out[i]=CT_rep[i]=0;

	/* use standard input and output for image transfer */
	infile = stdin;
	reddev = stdout;
	pmpinit();
	chrinit();

	/* set the correct line spacing */
	pmpprt(0xd3);
	pmpprt(34);	/*activate image font*/
	pmpprt(0xd2);
	pmpprt(1); 	/* landscape right */
	pmpfrc();

	fread(&screensize,sizeof(screensize),1,infile);
#ifdef DEBUG
	fprintf(stderr,"sizeof=%d  screenwidth=%d screenheight=%d\n",
	sizeof(screensize),screensize.screenwidth, screensize.screenheight);
#endif DEBUG
	if (screensize.screenwidth != LPIXELS)
		{
		fprintf(stderr,"sqzpmp: image size %d != size required (%d)\n",
			screensize.screenwidth, LPIXELS);
		exit(2);
		}
	pmpprt(0xe0);
	pmpnum(238+2*(screensize.screenwidth));
	pmpprt(0xe1);
	pmpnum(220-2);

	/* following reads and processes data */
	for (i=0;i<screensize.screenheight;i+=10)
	{	/*read one scan line at a time*/
		fread(sc,BLOCKSIZE,1,infile);
#ifdef DEBUG
		fprintf(stderr,"read %d bytes from stdin\n",BLOCKSIZE);
#endif DEBUG

		/* process bytes from shared RAM */
		for (j=0;j<10;j++) 
		{
			/*position over to beginning of next scan line*/
			pmpprt(0xa0|30); 


			for (posn=0;posn<screensize.screenwidth/16;posn +=1) 
			{
				redxlt((sc[j][posn]>>8)&255);
				redxlt(sc[j][posn]&255);
				if (chrcnt > 50) chrfrc();
				if (chrcnt+pmpcnt > 220)
					pmpfrc();
			}
			ST_ctype=BY_FULL;
			stchange();
		}

	}
	pmpprt(0xc5); /* ring bell */  
	pmpprt(0xd1); /* print page */
	pmpprt(0);
	pmpfrc();
#ifdef DEBUG
	fprintf(stderr,"ic=%ld twc=%ld compress=%5.2f\n",ic,twc,(float)ic/twc);
	fprintf(stderr,"ctype  in    out   rep   comp\n");
	for (i=0;i<NO_CTYPE;i++) {
		tempf=(float)CT_rep[i]/CT_out[i];
		fprintf(stderr,"%2d %6ld %6ld %6ld %6.2f\n",i,CT_in[i],CT_out[i],CT_rep[i],
		tempf);
	}
#endif DEBUG
	exit(0);
}

redxlt(ch)
unsigned char ch;
{
	ic++;
	ST_char=ch;
	if (ST_char < 0) fprintf(stderr,"redxlt: char less than zero.\n");
	if (ST_char >255) fprintf(stderr,"redxlt: char too big.\n");
	ST_ctype=ST_ctab[ST_char];
	CT_in[ST_ctype]++;
	stchange();
	if (ST_full) {
		ST_full=FALSE;
		ST_ctype=BY_FULL;
		stchange();
	}
}

stchange()
{
	int i;
	for ( i=0;i<NO_X;i++) {
		(*ST_ftab[ST_state][i][ST_ctype])();
	}
	i=ST_stab[ST_state][ST_ctype];
	ST_state=i;
}

chrinit()
{
	chrcnt=0;
}
chrfrc()
{
	int i;
	int tcnt;
	tcnt=chrcnt;
	chrcnt = 0;	     /*make the pmpprt think all is OK */
	pmpprt(tcnt);
	for (i=0;i<tcnt;pmpprt(chrbuf[i++])) {
	};
}
chrprt(ch)
unsigned char ch;
{
	if (chrcnt>=64) chrfrc();
	chrbuf[chrcnt++]=ch;
}
pmpinit()
{
	pmpcnt=0;
}
pmpnum(n)
int n;
{
	pmpprt(n/256);
	pmpprt(n%256);
}
pmpprt(ch)
char ch;
{
	static int r=FALSE;
	if (!r && chrcnt > 0) {
		r = TRUE;
		chrfrc();
		r = FALSE;
	}
	if (pmpcnt > 511 ) {
		fprintf(stderr,"pmp buffer overflow.\n");
		exit(2);
	}
	redbuf.pmpbuf[pmpcnt++]=ch;
}
pmpfrc()
{
	int i;
	if (chrcnt > 0) chrfrc();
	i = pmpcnt;
	fwrite(redbuf.pmpbuf,i,1,reddev);
#ifdef DEBUG
	fprintf(stderr,"DEBUG: wrote %d bytes\n",i));
#endif DEBUG
	twc += pmpcnt;
	pmpcnt=0;
}

