#!/bin/sh
#
# 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1987,1988
# LICENSED MATERIALS - PROPERTY OF IBM
# REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
#
# $Header:tailor.host.sh 12.0$ 
# $ACIS:tailor.host.sh 12.0$ 
# $Source: /ibm/acis/usr/src/etc/tailor/RCS/tailor.host.sh,v $ 

#Usage: tailor.host old_hostname new_hostname site_type
HELP=/usr/lib/tailor
AUX=/usr/lib/tailor
if grep -s '^hostname=' /etc/rc.config 2>/dev/null  #Put name in rc.config.
then
      sed "s/^hostname=.*/hostname=${2}/g" /etc/rc.config > /etc/rc.config.new
      mv /etc/rc.config.new /etc/rc.config
else
      echo "hostname=${2}" > /etc/rc.config
fi
chmod 644 /etc/rc.config
hostname $2     #Put name in kernel


#
#	Look for new name in /etc/hosts.
#

awk 'BEGIN {host="'$2'";exit_stat=1}
     {
       for (i=2;i<=NF;i++)
       {
         if ($i==host)
         {
           exit_stat=0;
         }
       }
     }
     END {exit exit_stat}' /etc/hosts

if [ $? -ne 0 ]
then    #New host not found. Substitute new host name.
  sed -e "s/\([ 	]\)${1}\([ 	]\)/\1${2}\2/g" \
      -e "s/\([ 	]\)${1}\$/\1${2}/g" \
	/etc/hosts > /etc/hosts.new
else
  cp /etc/hosts /etc/hosts.new
fi
if [ $3 = "m" -o $3 = "b" ]    # Master or both
then
      if [ $2 != "master" ]
      then  # Add master as alias to host name
	#
	#	Look for new name in /etc/hosts.
	#

	awk 'BEGIN {exit_stat=1}
	     {
	       for (i=2;i<=NF;i++)
	       {
	         if ($i=="master")
	         {
	           exit_stat=0;
	         }
	       }
	     }
	     END {exit exit_stat}' /etc/hosts.new

            if [ $? = 0 ]
            then
                  ex - /etc/hosts.new << EOF
                  /\<master\>/s///
                  wq
EOF
            fi
            ex - /etc/hosts.new << EOF
            /\<$2\>/s/$/ master/
            wq
EOF
      fi
fi
# See if host file edit is OK
if diff -w /etc/hosts /etc/hosts.new >/dev/null
then
     rep="n"
else
     echo
     echo These are the changes made to /etc/hosts file. If they
     echo are not correct, edit the file after tailor completes.
     echo
     diff -w /etc/hosts /etc/hosts.new
     rep=`$AUX/tailor.query "Are changes to /etc/hosts correct? y/n" $HELP/help.no y y n`
fi
if [ "${rep}" = "n" ]
then
      rm /etc/hosts.new              
else
      mv /etc/hosts /etc/hosts.old
      mv /etc/hosts.new /etc/hosts
      chmod 644 /etc/hosts
      echo Original file has been saved as /etc/hosts.old
fi
exit 0
