/*
 * 5799-WZQ (C) COPYRIGHT = NONE
 * LICENSED MATERIALS - PROPERTY OF IBM
 */
/* $Header:quotaon.c 12.0$ */
/* $ACIS:quotaon.c 12.0$ */
/* $Source: /ibm/acis/usr/src/etc/RCS/quotaon.c,v $ */

#ifndef lint
static char *rcsid = "$Header:quotaon.c 12.0$";
#endif

#include <sys/nfs_defines.h>

#ifndef VFS
/*
 * Copyright (c) 1980 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 */

#ifndef lint
char copyright[] =
"@(#) Copyright (c) 1980 Regents of the University of California.\n\
 All rights reserved.\n";
#endif not lint

#ifndef lint
static char sccsid[] = "@(#)quotaon.c	5.2 (Berkeley) 8/8/85";
#endif not lint

/*
 * Turn quota on/off for a filesystem.
 */
#include <sys/param.h>
#include <sys/file.h>
#include <stdio.h>
#include <fstab.h>
#include <mtab.h>

struct	mtab mtab[NMOUNT];

int	vflag;		/* verbose */
int	aflag;		/* all file systems */
int	done;
int	mf;

char	*qfname = "quotas";
char	quotafile[MAXPATHLEN + 1];
char	*index(), *rindex();

main(argc, argv)
	int argc;
	char **argv;
{
	register struct fstab *fs;
	char *whoami, *rindex();
	int offmode = 0, errs = 0, i;

	whoami = rindex(*argv, '/') + 1;
	if (whoami == (char *)1)
		whoami = *argv;
	if (strcmp(whoami, "quotaoff") == 0)
		offmode++;
	else if (strcmp(whoami, "quotaon") != 0) {
		fprintf(stderr, "Name must be quotaon or quotaoff not %s\n",
			whoami);
		exit(1);
	}
again:
	argc--, argv++;
	if (argc > 0 && strcmp(*argv, "-v") == 0) {
		vflag++;
		goto again;
	}
	if (argc > 0 && strcmp(*argv, "-a") == 0) {
		aflag++;
		goto again;
	}
	if (argc <= 0 && !aflag) {
		fprintf(stderr, "Usage:\n\t%s [-v] -a\n\t%s [-v] filesys ...\n",
			whoami, whoami);
		exit(1);
	}
	mf = open("/etc/mtab", O_RDONLY);
	if (mf < 0) {
		perror("/etc/mtab");
		exit(1);
	}
	(void) read(mf, (char *)mtab, sizeof (mtab));
	close(mf);
	setfsent();
	while ((fs = getfsent()) != NULL) {
		if (aflag &&
		    (fs->fs_type == 0 || strcmp(fs->fs_type, "rq") != 0))
			continue;
		if (!aflag &&
		    !(oneof(fs->fs_file, argv, argc) ||
		      oneof(fs->fs_spec, argv, argc)))
			continue;
		errs += quotaonoff(fs, offmode);
	}
	endfsent();
	for (i = 0; i < argc; i++)
		if ((done & (1 << i)) == 0)
			fprintf(stderr, "%s not found in /etc/fstab\n",
				argv[i]);
	exit(errs);
}

quotaonoff(fs, offmode)
	register struct fstab *fs;
	int offmode;
{

	if (strcmp(fs->fs_file, "/") && readonly(fs))
		return (1);
	if (offmode) {
		if (setquota(fs->fs_spec, NULL) < 0)
			goto bad;
		if (vflag)
			printf("%s: quotas turned off\n", fs->fs_file);
		changemtab(fs, FSTAB_RW);
		return (0);
	}
	(void) sprintf(quotafile, "%s/%s", fs->fs_file, qfname);
	if (setquota(fs->fs_spec, quotafile) < 0)
		goto bad;
	if (vflag)
		printf("%s: quotas turned on\n", fs->fs_file);
	changemtab(fs, FSTAB_RQ);
	return (0);
bad:
	fprintf(stderr, "setquota: ");
	perror(fs->fs_spec);
	return (1);
}

oneof(target, list, n)
	char *target, *list[];
	register int n;
{
	register int i;

	for (i = 0; i < n; i++)
		if (strcmp(target, list[i]) == 0) {
			done |= 1 << i;
			return (1);
		}
	return (0);
}

changemtab(fs, type)
	register struct fstab *fs;
	char *type;
{
	register struct mtab *mp;
	register char *cp;

	cp = index(fs->fs_spec, '\0');
	while (*--cp == '/')
		*cp = '\0';
	cp = rindex(fs->fs_spec, '/');
	if (cp)
		cp++;
	else
		cp = fs->fs_spec;
	for (mp = mtab; mp < &mtab[NMOUNT]; mp++)
		if (strcmp(mp->m_dname, cp) == 0)
			goto replace;
	for (mp = mtab; mp < &mtab[NMOUNT]; mp++)
		if (mp->m_path[0] == '\0')
			goto replace;
	return;
replace:
	strcpy(mp->m_type, type);
	mp = mtab + NMOUNT - 1;
	while (mp > mtab && mp->m_path[0] == '\0')
		--mp;
	mf = creat("/etc/mtab", 0644);
	(void) write(mf, (char *)mtab, (mp - mtab + 1) * sizeof (struct mtab));
	close(mf);
}

/*
 * Verify file system is mounted and not readonly.
 */
readonly(fs)
	register struct fstab *fs;
{
	register struct mtab *mp;
	register char *cp;

	cp = index(fs->fs_spec, '\0');
	while (*--cp == '/')
		*cp = '\0';
	cp = rindex(fs->fs_spec, '/');
	if (cp)
		cp++;
	else
		cp = fs->fs_spec;
	for (mp = mtab; mp < mtab + NMOUNT; mp++) {
		if (mp->m_path[0] == '\0')
			continue;
		if (strcmp(cp, mp->m_dname) == 0) {
			if (strcmp(mp->m_type, FSTAB_RO) == 0) {
				printf("%s: mounted read-only\n", fs->fs_file);
				return (1);
			}
			return (0);
		}
	}
	printf("%s: not mounted\n", fs->fs_file);
	return (1);
}

#else !VFS

/* @(#)quotaon.c	1.2 87/07/24 3.2/4.3NFSSRC */
/*
 * Copyright (c) 1980 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 */

#ifndef lint
char copyright[] =
"@(#) Copyright (c) 1980 Regents of the University of California.\n\
 All rights reserved.\n";
#endif not lint

#ifndef lint
static char sccsid[] = "@(#)quotaon.c	5.2 (Berkeley) 8/8/85";
#endif not lint

/*
 * Turn quota on/off for a filesystem.
 */
#include <sys/param.h>
#include <sys/file.h>
#include <ufs/quota.h>
#include <stdio.h>
#include <mntent.h>

int	vflag;		/* verbose */
int	aflag;		/* all file systems */

#define QFNAME "quotas"
char	quotafile[MAXPATHLEN + 1];
char	*listbuf[50];
char	*index(), *rindex();
char	*malloc();

main(argc, argv)
	int argc;
	char **argv;
{
	register struct mntent *mntp;
	char **listp;
	int listcnt;
	FILE *mtab, *fstab, *tmp;
	char *whoami, *rindex();
	int offmode = 0;
	int errs = 0;
	char *tmpname = "/etc/quotaontmpXXXXXX";

	whoami = rindex(*argv, '/') + 1;
	if (whoami == (char *)1)
		whoami = *argv;
	if (strcmp(whoami, "quotaoff") == 0)
		offmode++;
	else if (strcmp(whoami, "quotaon") != 0) {
		fprintf(stderr, "Name must be quotaon or quotaoff not %s\n",
			whoami);
		exit(1);
	}
again:
	argc--, argv++;
	if (argc > 0 && strcmp(*argv, "-v") == 0) {
		vflag++;
		goto again;
	}
	if (argc > 0 && strcmp(*argv, "-a") == 0) {
		aflag++;
		goto again;
	}
	if (argc <= 0 && !aflag) {
		fprintf(stderr, "Usage:\n\t%s [-v] -a\n\t%s [-v] filesys ...\n",
			whoami, whoami);
		exit(1);
	}
	/*
	 * If aflag go through fstab and make a list of appropriate
	 * filesystems.
	 */
	if (aflag) {
		listp = listbuf;
		listcnt = 0;
		fstab = setmntent(MNTTAB, "r");
		while (mntp = getmntent(fstab)) {
			if ((   (strcmp(mntp->mnt_type, MNTTYPE_42) != 0) &&
				(strcmp(mntp->mnt_type, MNTTYPE_43) != 0) &&
				(strcmp(mntp->mnt_type, MNTTYPE_UFS) != 0)) ||
			    !hasmntopt(mntp, MNTOPT_QUOTA) ||
			    hasmntopt(mntp, MNTOPT_RO))
				continue;
			*listp = malloc(strlen(mntp->mnt_fsname) + 1);
			strcpy(*listp, mntp->mnt_fsname);
			listp++;
			listcnt++;
		}
		endmntent(fstab);
		*listp = (char *)0;
		listp = listbuf;
	} else {
		listp = argv;
		listcnt = argc;
	}
 
	/*
	 * Open temporary version of mtab
	 */
	mktemp(tmpname);
	tmp = setmntent(tmpname, "a");
	if (tmp == NULL) {
		perror(tmpname);
		exit(1);
	}

	/*
	 * Open real mtab
	 */
	mtab = setmntent(MOUNTED, "r");
	if (mtab == NULL) {
		perror(MOUNTED);
		exit(1);
	}
 
	/*
	 * Loop through mtab writing mount record to temp mtab.
	 * If a file system gets turn on or off modify the mount
	 * record before writing it.
	 */
	while ((mntp = getmntent(mtab)) != NULL) {
		if ((   (strcmp(mntp->mnt_type, MNTTYPE_42) != 0) &&
			(strcmp(mntp->mnt_type, MNTTYPE_43) != 0) &&
			(strcmp(mntp->mnt_type, MNTTYPE_UFS) != 0)) ||
		    !hasmntopt(mntp, MNTOPT_RO) &&
		    (oneof(mntp->mnt_fsname, listp, listcnt) ||
		     oneof(mntp->mnt_dir, listp, listcnt)) ) {
			errs += quotaonoff(mntp, offmode);
		}
		addmntent(tmp, mntp);
	}
	endmntent(mtab);
	endmntent(tmp);

	/*
	 * Move temp mtab to mtab
	 */     
	if (rename(tmpname, MOUNTED) < 0) {
		perror(MOUNTED);
		exit(1);
	}
	while (listcnt--) {
		if (*listp)
			fprintf(stderr, "Cannot do %s\n", *listp);
		listp++;
	}
	exit(errs);
}

quotaonoff(mntp, offmode)
	register struct mntent *mntp;
	int offmode;
{

	if (offmode) {
		if (quotactl(Q_QUOTAOFF, mntp->mnt_fsname, 0, NULL) < 0)
			goto bad;
		if (vflag)
			printf("%s: quotas turned off\n", mntp->mnt_dir);
	} else {
		(void) sprintf(quotafile, "%s/%s", mntp->mnt_dir, QFNAME);
		if (quotactl(Q_QUOTAON, mntp->mnt_fsname, 0, quotafile) < 0)
			goto bad;
		if (vflag)
			printf("%s: quotas turned on\n", mntp->mnt_dir);
	}
	fixmntent(mntp, offmode);
	return (0);
bad:
	fprintf(stderr, "quotactl: ");
	perror(mntp->mnt_fsname);
	return (1);
}

oneof(target, listp, n)
	char *target;
	register char **listp;
	register int n;
{

	while (n--) {
		if (*listp && strcmp(target, *listp) == 0) {
			*listp = (char *)0;
			return (1);
		}
		listp++;
	}
	return (0);
}

char opts[1024];

fixmntent(mntp, offmode)
	register struct mntent *mntp;
	int offmode;
{
	register char *qst, *qend;

	if (offmode) {
		if (hasmntopt(mntp, MNTOPT_NOQUOTA))
			return;
		qst = hasmntopt(mntp, MNTOPT_QUOTA);
	} else { 
		if (hasmntopt(mntp, MNTOPT_QUOTA))
			return;
		qst = hasmntopt(mntp, MNTOPT_NOQUOTA);
	}
	if (qst) {
		qend = index(qst, ',');
		if (qst != mntp->mnt_opts)
			qst--;                  /* back up to ',' */
		if (qend == NULL)
			*qst = '\0';
		else
			while (*qst++ = *qend++);
	}
	sprintf(opts, "%s,%s", mntp->mnt_opts,
	    offmode? MNTOPT_NOQUOTA : MNTOPT_QUOTA);
	mntp->mnt_opts = opts;
}

#endif !VFS
