/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1986
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:dkio.h 12.0$ */
/* $ACIS:dkio.h 12.0$ */
/* $Source: /ibm/acis/usr/sys/ca/RCS/dkio.h,v $ */

#if !defined(lint) && !defined(LOCORE) && defined(RCS_HDRS)
static char *rcsidt = "$Header:dkio.h 12.0$";
#endif

/*	dkio.h	6.1	83/07/29	*/
/*
 * Structures and definitions for disk io control commands
 *
 */

/* disk io partition (and geometry) information format */

/*
 * Notes:
 * 1.	dk_size may be less than dk_cyl * dk_track * dk_sector
 *	since dk_size is the usable size (e.g. what you would specify
 *	to newfs/mkfs)
 * 2. everything except dk_size and dk_blocksize are optional - if the
 *	information isn't known then zero is returned.
 * 3. name should be in domain of types in /etc/disktab.
 * 4. start is starting block of this partition (0=start of disk)
 *	this could be used by a program to display current disk
 *	partitioning in a portable fashion.
 */

#define DK_MAXNAME 16		/* size of name field */

struct dkpart {
	u_long	dk_size;	/* disk partition size in blocksize units */
				/*  see following word */
	u_long	dk_blocksize;	/* block/sector size (in bytes) */
	u_long	dk_start;	/* starting block (in blocksize units) */
	u_long	dk_ncyl;	/* number of cylinders (if known) */
	u_long	dk_ntrack;	/* number of tracks per cylinder (if known) */
	u_long	dk_nsector;	/* number of sectors per track (if known) */
	char	dk_name[DK_MAXNAME];/* name of device (if known) (e.g. "hd40r") */
};

/* disk io control commands */
#define DKIOCHDR	_IO('d', 1)	/* next I/O will read/write header */
#define DKIOCGPART	_IOR('d', 2, struct dkpart)	/* get partition information */
