/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1988
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:osi.h 12.0$ */
/* $ACIS:osi.h 12.0$ */
/* $Source: /ibm/acis/usr/sys/afs/RCS/osi.h,v $ */

#if !defined(lint) && !defined(LOCORE) && defined(RCS_HDRS)
static char *rcsidosi = "$Header:osi.h 12.0$";
#endif

#include "../h/types.h"
#include "../h/param.h"

/* this is just a dummy type decl, we're really using struct sockets here */
struct osi_socket {
    int junk;
};

struct osi_stat {
    long size;	    /* file size in bytes */
    long blksize;   /* optimal transfer size in bytes */
    long mtime;	    /* modification date */
    long atime;	    /* access time */
};

struct osi_file {
    struct vnode *vnode;
    long offset;
    int	(*proc)();	/* proc, which, if not null, is called on writes */
    char *rock;		/* rock passed to proc */
};

struct osi_dev {
    long dev;
};

struct osi_WaitHandle {
    caddr_t proc;	/* process waiting */
};

#define	osi_SetFileProc(x,p)	((x)->proc=(p))
#define	osi_SetFileRock(x,r)	((x)->rock=(r))
#define	osi_GetFileProc(x)	((x)->proc)
#define	osi_GetFileRock(x)	((x)->rock)
#define	osi_Seek(x,p)	((x)->offset = (p))
#define	osi_Sleep(x)	sleep((caddr_t) x,PZERO-2)
#define	osi_Wakeup(x)	wakeup((caddr_t) x)
#define	osi_NullHandle(x)	((x)->proc == (caddr_t) 0)
#define	osi_PACKETSIZE	1600		/* packet buffer size */
#define	osi_NPACKETS	20		/* number of cluster packets to allocate */
extern struct osi_socket *osi_NewSocket();
extern struct osi_file *osi_UFSOpen();
extern struct ucred osi_cred;
extern char *osi_Alloc();
extern char *osi_AllocSendSpace();

#ifdef __sun__
/* sun definitions here */
#define	AFS_VFS34	1
#define	AFS_UIOFMODE	1
#define	AFS_ACTFLAG	1		/* is m_act mbuf a chain or a flag */
#define	afsio_iov	uio_iov
#define	afsio_iovcnt	uio_iovcnt
#define	afsio_offset	uio_offset
#define	afsio_seg	uio_seg
#define	afsio_fmode	uio_fmode
#define	afsio_resid	uio_resid
#define	AFS_UIOSYS	UIOSEG_KERNEL
#define	AFS_UIOUSER	UIOSEG_USER
#define	AFS_CLBYTES	MCLBYTES
#define	osi_GetTime(x)	uniqtime(x)
#endif

#ifdef ibm032
/* rt definitions here */
#define	AFS_VFS32	1		/* or use AFS_VFS32 if using a newer kernel */
#define	AFS_SHORTGID	1		/* are group id's short? */
#define	AFS_GETDIRHACK	1		/* have read call readdir temporarily for compat reasons */
#define	afsio_iov	uio_iov
#define	afsio_iovcnt	uio_iovcnt
#define	afsio_offset	uio_offset
#define	afsio_seg	uio_segflg
#define	afsio_resid	uio_resid
#define	AFS_UIOSYS	UIO_SYSSPACE
#define	AFS_UIOUSER	UIO_USERSPACE
#define	AFS_CLBYTES	MB_CLBYTES
#define	osi_GetTime(x)	microtime(x)
#endif

#ifdef	__vax__
/* Mvax Ultrix-2.2 definitions here */

#define	AFS_GETDIRHACK	1		/* have read call readdir (a la RTs) */
#define	afsio_iov	uio_iov
#define	afsio_iovcnt	uio_iovcnt
#define	afsio_offset	uio_offset
#define	afsio_seg	uio_segflg
#define	afsio_resid	uio_resid
#define	AFS_UIOSYS	UIO_SYSSPACE
#define	AFS_UIOUSER	UIO_USERSPACE
#define	IO_UNIT		1
#define	AFS_CLBYTES	CLBYTES
#define	osi_GetTime(x)	uniqtime(x)

extern struct gnode_ops *afs_ops;
#define	vType(vc)	    IFTOVT((vc)->v.g_mode)
#define	vSetType(vc,type)   (vc)->v.g_mode = VTTOIF((type))
#define	vSetVfsp(vc,vfsp)   (vc)->v.g_mp = (struct mount *)(vfsp)->vfs_data
#define	iunlock(gp)	    gfs_unlock((gp))
#define	AFS_MAXNAMLEN	    255
#else
/* GFS-based defines/macros for sun & ibm032 */
extern struct vnodeops *afs_ops;
#define	vType(vc)	    (vc)->v.v_type
#define	vSetType(vc,type)   (vc)->v.v_type = (type)
#define	vSetVfsp(vc,vfsp)   (vc)->v.v_vfsp = (vfsp)
#define	gop_lookupname(fnamep,segflg,followlink,dirvpp,compvpp) \
lookupname((fnamep),(segflg),(followlink),(dirvpp),(compvpp))
#define	gop_rdwr(rw,gp,base,len,offset,segflg,unit,aresid) \
vn_rdwr((rw),(gp),(base),(len),(offset),(segflg),(unit),(aresid))
#endif
