/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION  1986,1987
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:pte.h 12.0$ */
/* $ACIS:pte.h 12.0$ */
/* $Source: /ibm/acis/usr/sys/ca/RCS/pte.h,v $ */

#if !defined(lint) && !defined(LOCORE) && defined(RCS_HDRS)
static char *rcsidpte = "$Header:pte.h 12.0$";
#endif

/*     pte.h   6.1     83/07/29        */

/*
 * VAX page table entry
 *
 * There are two major kinds of pte's: those which have ever existed (and are
 * thus either now in core or on the swap device), and those which have
 * never existed, but which will be filled on demand at first reference.
 * There is a structure describing each.  There is also an ancillary
 * structure used in page clustering.
 */

#ifndef LOCORE
struct pte
{
unsigned int
               pg_v:1,                 /* valid bit */
               pg_prot:4,              /* access control */
               pg_m:1,                 /* hardware maintained modified bit */
               pg_fod:1,               /* is fill on demand (=0) */
               pg_swapm:1,             /* have to write back to swap */
               pg_vreadm:1,            /* modified since vread (or with _m) */
               :2,
               pg_pfnum:21;            /* core page frame number or 0 */
};
struct hpte
{
unsigned int
               pg_high:9,              /* special for clustering */
               :2,
               pg_pfnum:21;
};
struct fpte
{
unsigned int
               pg_v:1,
               pg_prot:4,
               :1,
               pg_fod:1,               /* is fill on demand (=1) */
               pg_fileno:1,            /* file mapped from or TEXT or ZERO */
               pg_blkno:24;            /* file system block number */
};
#endif

#define        PG_V            0x80000000
#define        PG_PROT         0x78000000
#define        PG_M            0x04000000
#define        PG_FOD          0x02000000
#define        PG_VREADM       0x00800000
#define        PG_PFNUM        0x001fffff

#define        PG_FZERO        0
#define        PG_FTEXT        1
#define        PG_FMAX         (PG_FTEXT)

#define        PG_NOACC        0
#define        PG_KW           0x10000000
#define        PG_KR           0x18000000
#define        PG_UW           0x20000000
#define        PG_URKW         0x70000000
#define        PG_URKR         0x78000000

/*
 * Pte related macros
 */
#ifdef SIM_CHG_BIT
#define dirty(pte) ((pte)->pg_fod == 0 && (pte)->pg_pfnum && \
 ((pte)->pg_m || (pte)->pg_swapm ))
#else
#define dirty(pte) ((pte)->pg_fod == 0 && (pte)->pg_pfnum && \
 ((pte)->pg_m || (pte)->pg_swapm || get_mod_bit((pte)->pg_pfnum)))
#endif

#define referenced(pte) get_ref_bit((pte)->pg_pfnum)

#ifndef LOCORE
#ifdef KERNEL
struct pte *vtopte();

/* utilities defined in locore.s */
extern struct pte Sysmap[];
extern struct pte Usrptmap[];
extern struct pte usrpt[];
extern struct pte Swapmap[];
extern struct pte Forkmap[];
extern struct pte Xswapmap[];
extern struct pte Xswap2map[];
extern struct pte Pushmap[];
extern struct pte Vfmap[];
extern struct pte mmap[];
extern struct pte msgbufmap[];
extern struct pte camap[];
#ifdef __vax__
extern struct pte Nexmap[][16];
extern	struct pte Ioamap[][1];
#endif
#ifdef VAX630
extern	struct pte Clockmap[];
extern	struct pte Ka630map[];
#endif
#endif
#endif
