/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1986,1987,1988
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:sautil.c 12.0$ */
/* $ACIS:sautil.c 12.0$ */
/* $Source: /ibm/acis/usr/sys/standca/RCS/sautil.c,v $ */

#ifndef lint
static char *rcsid = "$Header:sautil.c 12.0$";
#endif

int getchar_timeout;	       /* to get an auto cr */
char getchar_char;	       /* return a CR */

#define SAUTIL 1		/* for cases where it makes a difference */

#include "debug.h"

#define BOOT		1
#define FORMAT		2
#define DUMP		3
#define CAT		4
#define LS		5
#define COPY		6
#define DEBUGGER	7
#ifdef ATR
#define FDISK		8
#define INSTALL		9
#define BOOTINSTALL	12
#endif ATR
#ifdef IBMRTPC
#define IPLSOURCE	8
#define CONVERT		12
#endif IBMRTPC
#define MINIDISK	10
#define DOSBOOT		11

struct names
{
	int number;
	char *name;
} names[] = 
{
BOOT,		"boot - boot standalone program or kernel",
FORMAT,		"format - format hard disk",
DUMP,		"dump - display disk or floppy (hex)",
CAT,		"cat - display a file contents (ASCII)",
LS,		"ls - print directory of UNIX filesystem",
COPY,		"copy - copy all/part of disk or floppy",
DEBUGGER,	"debugger - display memory etc.",
#ifdef FDISK
FDISK,		"fdisk - Modify The BIOS Partition Record",
#endif FDISK
#ifdef IPLSOURCE
IPLSOURCE,	"iplsource - set boot order in nvram",
#endif IPLSOURCE
#ifdef INSTALL
INSTALL,	"install - install system from MINIROOT",
#endif INSTALL
MINIDISK,	"minidisk - display/change minidisk directory",
DOSBOOT,	"dosboot - boot standalone program or kernel from DOS diskette",
#ifdef CONVERT
CONVERT,	"convert - R70 (\"hd70r\") disk to an E70",
#endif CONVERT
#ifdef BOOTINSTALL
BOOTINSTALL,	"installboot - install boot files for a non-dos system",
#endif BOOTINSTALL
0, 0
};

#define CMD_COUNT (sizeof names/sizeof names[0])

#define DISKBOOT() ((* ((int *) 0xc04) >> 4) == 0xd)

#undef main
char *prompt();

char _stopmsg[] = "- Press Enter to return to main menu";

main()
{
	register int n, l;
	register char *p;
	static int cnt = 0;
	int argc;
	char *argv[20];			/* argument vector */
	extern char defline[];
	extern char line[];

	_init_vectors(0xffff);	       /* init all vectors */
	mtsr(SCR_ICS, 0x83);       /* allow non-I/O interrupts */

/*
 * the first time thru, if we're booted from disk or if
 * we're just set up to boot from diskette we just present
 * the boot menu.
 */
	if (cnt == 0)
		{
		extern int retry;
		extern char *morebootmsg;

		morebootmsg = "\n\t\t\tor press <CTRL>-C for menu";

#ifndef FDBOOT
		if (DISKBOOT())
#endif
			{
			++cnt;
#ifdef FDBOOT
			line[0] = defline[0] = 'f';
			retry = 3;	/* kill automatic retries */
#endif
			boot_prog(0,0);			/* try boot first */
			}
		getchar_timeout  = 9000000;	/* give about 90 seconds */
		}
	for (;;)
		{
		print_menu();
		p = prompt("Choice ? ");
		argc = _parse(p, p, argv);
		p = argv[0];
		if (argc == 1)
			argc = 0;
		n = atoi(p);
		if (cnt++ == 0 && *p == 0)
			{
			n = BOOT;			/* do a boot */
			getchar_timeout  = 3000000;	/* about 30 seconds */
			getchar_char = '\r';
			}
		if (n == 0 && (l = strlen(p)))
			{
			for (n=1; n<=CMD_COUNT; ++n)
				if (strncmp(p,names[n-1].name,l) == 0)
					{
					n = names[n-1].number;
					break;
					}
			}
		switch(n)
			{
		case BOOT:
			boot_prog(argc,argv);
			break;
		case FORMAT:
			format_prog(argc,argv);	/* */
			break;
		case DUMP:
			dump_prog(argc,argv);	/* */
			break;
		case CAT:
			cat_prog(argc,argv);	/* */
			break;
		case LS:
			ls_prog(argc,argv);	/* */
			break;
		case COPY:
			copy_prog(argc,argv);	/* */
			break;
		case DEBUGGER:
			debugger();
			break;
#ifdef FDISK
		case FDISK:
			fdisk_prog(argc,argv);
			break;
#endif FDISK
#ifdef IPLSOURCE
		case IPLSOURCE:
			nvram_prog(argc,argv);
			break;
#endif IPLSOURCE
#ifdef INSTALL
		case INSTALL:
			install_prog(argc,argv);
			line[0] = defline[0] = 'h';	/* insurance */
							/* 0123456789abc */
			line[5] = defline[5] = '1';	/* hd(0,1)vmunix */
			getchar_timeout  = 30000;	/* about .3 seconds */
			boot_prog(0,0);			/* try boot first */
			break;
#endif INSTALL
		case MINIDISK:
			minidisk_prog(argc,argv);
			break;
		case DOSBOOT:
			dosboot_prog(argc,argv);
			break;
#ifdef CONVERT
		case CONVERT:
			argv[0] = "convert";
			format_prog(argc,argv);
			break;
#endif CONVERT
#ifdef BOOTINSTALL
		case BOOTINSTALL:
			install_boot(argc,argv);
#endif BOOTINSTALL
		default:
			printf("Invalid choice - hit return to try again\n");
			(void) getchar();
			continue;
			}
		exit(0);		/* reinitialize the world */
		}
}

print_menu()
{
	register char *p;
	register int i;

	printf("\33K");		/* clear screen */
	printf("\n4.3 BSD UNIX Standalone Maintenance Program $Revision: 12.0 $\n\n");
	printf("Choice		Description\n\n");
	for (i=1; p=names[i-1].name; ++i)
		printf("%d	%s\n",names[i-1].number,p);
	printf("\nEnter the menu choice desired then press Enter\n");
	printf("\n");
}

#undef main
#undef rcsid
#undef aton
#define main boot_prog
#define rcsid rcsid_boot
#include "boot.c"


#undef main
#undef rcsid
#undef aton
#define rcsid rcsid_format
#define main format_prog
#define aton format_aton
#include "format.c"



#undef main
#undef aton
#undef rcsid
#define rcsid rcsid_dump
#define main dump_prog
#include "dump.c"



#undef main
#undef aton
#undef rcsid
#define rcsid rcsid_cat
#define main cat_prog
#include "cat.c"




#undef main
#undef aton
#undef rcsid
#define rcsid rcsid_ls
#define main ls_prog
#include "ls.c"





#undef main
#undef aton
#undef rcsid
#define rcsid rcsid_copy
#define main copy_prog
#include "copy.c"







#ifdef IPLSOURCE
#undef main
#undef rcsid
#define rcsid rcsid_nvram
#define main nvram_prog
#include "nvram.c"
#endif IPLSOURCE






#undef main
#undef rcsid
#define rcsid rcsid_minidisk
#define rcsidctype rcsid_minidiskctype
#define main minidisk_prog
#include "minidisk.c"






#ifdef INSTALL
#undef main
#undef rcsid
#define rcsid rcsid_install
#undef rcsidctype 
#define rcsidctype rcsid_installctype
#define main install_prog
#include "install.c"
#endif INSTALL

#ifdef BOOTINSTALL
#undef main
#undef rcsid
#define rcsid rcsid_install_boot
#define main  install_boot
#include "installboot.c"
#endif BOOTINSTALL

#undef main
#undef rcsid
#define rcsid rcsid_dosboot
#define main dosboot_prog
#include "dosboot.c"

#ifdef FDISK
#undef main
#undef rcsid
#define rcsid rcsid_fdisk
#define main fdisk_prog
#include "fdisk.c"
#endif FDISK

