#$Header:codes.awk 12.0$
#$ACIS:codes.awk 12.0$
#$Source: /ibm/acis/usr/sys/standca/RCS/codes.awk,v $
BEGIN { 

NAME="codes.h"

hex["0"] = 0
hex["1"] = 1
hex["2"] = 2
hex["3"] = 3
hex["4"] = 4
hex["5"] = 5
hex["6"] = 6
hex["7"] = 7
hex["8"] = 8
hex["9"] = 9
hex["a"] = 10
hex["b"] = 11
hex["c"] = 12
hex["d"] = 13
hex["e"] = 14
hex["f"] = 15
}
/^#/ { print > NAME ; next }
/^\*/ { next } 		# ignore completely 
/^\/\*/ { print > NAME ; next }
NF < 3 { print "less than 3 fields",NR,$0 ; next }
length($1) != 2 { print $1,"not 2 hex characters"; next }
{
	d1 = hex[substr($1,1,1)]
	d2 = hex[substr($1,2,1)]
	if (d1 == "" || d2 == "")
		{ print "bad hex digit in ",$1,NR,$0 ; next }
	dec =  d1 * 16 + d2
	if (normal[dec] != "")
		printf("scan code %d (%x) duplicate %s : %s \n",dec,dec,normal[dec],$2)
	if ($2 ~ /\\E/)
		{ char = "E '" substr($2,3) "'" }
	else
		{ char =  "  '" $2 "'" }
	normal[dec] = char
	if ($3 ~ /\\E/)
		{ char = "E '" substr($3,3) "'" }
	else
		{ char =  "  '" $3 "'" }
	shift[dec] = char
	for (i=4; i<=NF; ++i)
		comment[dec] = comment[dec] " " $i
#	print dec,$0
	if (dec > max)
		max = dec
}

END { 

print "#define MAX_CODES ",max+1 > NAME
print "char codes[(MAX_CODES+1) * 2 ]  = {" > NAME

for (i=0; i<=max; ++i)
	if (normal[i] == "")
		printf("%8s, %8s,\t\t/* %3d 0x%02x\t%s */\n","NONE","NONE",i,i,comment[i]) > NAME
	else
		printf("%8s, %8s,\t\t/* %3d 0x%02x\t%s */\n",normal[i],shift[i],i,i,comment[i]) > NAME
print "NONE, NONE };" >NAME
}
