/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1987,1988
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */

#ifndef lint
char           *clockrcsid = "$Header:clock.c 12.0$";
#endif

#include <dos.h>
#include <stdio.h>
#include <sys\types.h>
#include "pcparam.h"
#include "rb.h"

#define XCLOCK_SEC	0x0
#define XCLOCK_SAL	0x1
#define XCLOCK_MIN	0x2
#define XCLOCK_MAL	0x3
#define XCLOCK_HRS	0x4
#define XCLOCK_HAL	0x5
#define XCLOCK_DOW	0x6
#define XCLOCK_DOM	0x7
#define XCLOCK_MON	0x8
#define XCLOCK_YR	0x9
#define XCLOCK_A	0xA
#define XCLOCK_B	0xB
#define XCLOCK_C	0xC
#define XCLOCK_D	0xD

struct XCLOCK   xclock;
struct XCLOCK   yclock;

void getclock()
{
	register int    i;
	char           *cptr = (char *) &xclock;
	int             j;

	/*
	 * Make sure the Update In Progress bit is not on. 
	 */

	j = 0;
	do
	{
		IOOUT(0x70, XCLOCK_A);
		i = IOIN(0x71);
	} while ((i & 0x80) && (j++ < 100));

	if (i & 0x80)
		return;

	for (i = 0; i < sizeof(struct XCLOCK); i++)
	{
		IOOUT(0x70, i);
		j = IOIN(0x71);
		j = (((j & 0xf0) >> 4) * 10) + (j & 0x0f);
		*cptr++ = LOBYTE(j);
	}

}

void setclock(pcplqe)
	pcplqaddr_t     pcplqe;
{
	register struct XCLOCK *dplptr = &yclock;
	u_long          unixaddr;
	int             i;
	char far       *pcaddr;
	union REGS      inregs, outregs;

	/*
	 * First read the clock struct down from Unix 
	 */

	i = sizeof(struct XCLOCK);

	pcaddr = (char far *) dplptr;
	unixaddr = (u_long) pcplqe->unix_cb;

	movein(unixaddr, pcaddr, i);


	inregs.h.ah = 0x2b;	/* set the date via a DOS function call */
	inregs.x.cx = 1900 + yclock.year;
	inregs.h.dh = yclock.mon;
	inregs.h.dl = yclock.dom;
	intdos(&inregs, &outregs);

	inregs.h.ah = 0x2d;	/* set the time via a DOS function call */
	inregs.h.ch = yclock.hrs;
	inregs.h.cl = yclock.min;
	inregs.h.dh = yclock.sec;
	inregs.h.dl = 0;
	intdos(&inregs, &outregs);

	getclock();		/* force update of software structure */
}
