/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1987,1988
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
#ifndef lint
static char    *rcsid = "$Header:biosreq.c 12.0$";
#endif


#include <stdlib.h>
#include <string.h>
#include <fcntl.h>
#include <stdio.h>
#include <fcntl.h>
#include <io.h>
#include <sys\types.h>
#include "pcparam.h"
#include "rb.h"

extern char far *buff_dio;
extern struct cbcb far *cbcbptr;

#ifdef DEBUG
extern u_short *dbugptr;
#endif /* DEBUG */

static struct bios_int bdpl;
static struct mask_int mdpl;
struct mask_int old_mask = {0};

biosreq(pcplqe)
	pcplqaddr_t     pcplqe;
{
	register struct bios_int *dplptr = &bdpl;
	union regs     *rptr = (union regs *) & dplptr->gen_reg;
	struct sregs   *segptr = (struct sregs *) & dplptr->seg_reg;
	register int    i;
	u_short        *sptr, *eptr;
	int             rc;
	u_long          unixaddr;
	char far       *pcaddr;


#ifdef DEBUG
	int             ldebug = *dbugptr & BIOSDEBUG;
#endif /* DEBUG */


#define VIDEO_INT 0x10

	/*
	 * First read the DPL down from Unix 
	 */

	i = sizeof(struct bios_int);

	pcaddr = (char far *) dplptr;
	unixaddr = (u_long) pcplqe->unix_cb;

	DEBUGF(ldebug, printf("biosreq: pcplqe = %#lx\n", (u_long) pcplqe));
	DEBUGF(ldebug, printf("biosreq: Copy the dpl from Unix %#lx\n", unixaddr));

	rc = movein(unixaddr, pcaddr, i);

	if (rc < 0)
	{
		DEBUGF(ldebug, printf("biosreq: Can't read DPL\n"));
		return (rc);
	}
	/*
	 * Change byte order 
	 */
	dplptr->intr = exchw(dplptr->intr);
	dplptr->valid_reg = exchw(dplptr->valid_reg);
	rptr->x.ax = exchw(rptr->x.ax);
	rptr->x.bx = exchw(rptr->x.bx);
	rptr->x.cx = exchw(rptr->x.cx);
	rptr->x.dx = exchw(rptr->x.dx);
	rptr->x.si = exchw(rptr->x.si);
	rptr->x.di = exchw(rptr->x.di);
	rptr->x.bp = exchw(rptr->x.bp);

	segptr->es = exchw(segptr->es);
	segptr->ds = exchw(segptr->ds);

#ifdef DEBUG
	if (ldebug)
	{
		printf("biosreq: Paramaters copied down from Unix:\n");
		printf("interrupt # = %#x\n", dplptr->intr);
		printf("valid_reg = %#x\n", dplptr->valid_reg);
		printf(" AX = %#x, BX = %#x, CX = %#x, DX = %#x\n",
		       rptr->x.ax, rptr->x.bx, rptr->x.cx, rptr->x.dx);
		printf(" SI = %#x, DI = %#x, BP = %#x, FLAGS = %#x\n",
		       rptr->x.si, rptr->x.di, rptr->x.bp, rptr->x.cflag);
		printf(" ES = %#x, CS = %#x, SS = %#x, DS = %#x\n",
		       segptr->es, segptr->cs, segptr->ss, segptr->ds);
	}
#endif /* DEBUG */


	switch (dplptr->intr)
	{
	case VIDEO_INT:
		rptr->x.cflag = 0;	/* Clear this before call */
		int10(dplptr);
		break;
	default:
		rptr->x.cflag = -1;
		break;
	}

	dplptr->finished = 1;

	i = sizeof(struct bios_int);

	sptr = (u_short *) dplptr;
	eptr = (sptr + (i >> 1));
	while (sptr < eptr)
		*sptr = exchw(*sptr++);

	rc = moveout(unixaddr, pcaddr, i);

/*  rompint4(4,FAKEPOLL(BIOSIRQ), 0, 0, (struct cbcb *) 0); */

	return (rc);

}

afireq()
{


}


/*
 * mask interrupts via the 8259 mask register.
 * we are passed an argument that is the address of the 
 * new contents of the master and slave mask register 
 * if the new contents are zero then we restore the previous
 * contents.
 */
maskint(pcplqe)
	pcplqaddr_t     pcplqe;
{

	register struct mask_int *dplptr = &mdpl;
	struct mask_int *omptr = &old_mask;
	register u_short s;
	u_long          unixaddr;
	int             rc;
	char            sacredints = (IRQ0 | IRQ2 | IRQ1 | IRQ7);
	char far       *pcaddr;
	char		master, slave;

#ifdef DEBUG
	int             ldebug = *dbugptr & MASKDEBUG;
#endif /* DEBUG */

	/*
	 * First read the DPL down from Unix 
	 */

	pcaddr = (char far *) dplptr;
	unixaddr = (u_long) pcplqe->unix_cb;

	DEBUGF(ldebug, printf("maskintreq: pcplqe=%#lx from Unix %#lx\n", (u_long) pcplqe,unixaddr));

	rc = movein(unixaddr, pcaddr, sizeof(struct mask_int));

	if (rc < 0)
	{
		DEBUGF(ldebug, printf("maskintreq: Can't read DPL\n"));
		return (rc);
	}

	if (dplptr->master == 0 && dplptr->slave == 0)
	{
		/* restore saved master and slave */
		master = omptr->master;
		slave = omptr->slave;
	}
	else
	{
		/* Get the original mask and save it */

		omptr->master = IOIN(INTMAST + 1);
		omptr->slave = IOIN(INTSLAVE + 1);
		master = (~sacredints & dplptr->master);
		slave = ~IRQ6 & dplptr->slave;	/* allow disk interrupts */
	}


	DEBUGF(ldebug, printf("maskintreq: masks - old master=%x slave=%x; new master=%x slave=%x\n", IOIN(INTMAST + 1), IOIN(INTSLAVE + 1), master, slave));

	s = spl();		/* turn off ints */


	IOOUT(INTMAST + 1, master);	/* send out the mask */
	IOOUT(INTSLAVE + 1, slave);	/* send out the mask */

	splx(s);		/* turn ints back on */

	return (rc);

}
