/*
 * USC-ACSC UNIX Monitor: $Header:clock.c 12.0$
 * Copyright University of Southern California, 1988
 */

#include <subcalls.h>
#include <doscalls.h>
#include <dos.h>
#include <stdio.h>
#include "pctype.h"
#include "pcparam.h"
#include "rb.h"
#include "os2data.h"

#define XCLOCK_SEC	0x0
#define XCLOCK_SAL	0x1
#define XCLOCK_MIN	0x2
#define XCLOCK_MAL	0x3
#define XCLOCK_HRS	0x4
#define XCLOCK_HAL	0x5
#define XCLOCK_DOW	0x6
#define XCLOCK_DOM	0x7
#define XCLOCK_MON	0x8
#define XCLOCK_YR	0x9
#define XCLOCK_A	0xA
#define XCLOCK_B	0xB
#define XCLOCK_C	0xC
#define XCLOCK_D	0xD

#ifdef old_clock
struct	os2clock	{
	u_char	hrs;
	u_char	min;
	u_char	sec;
	u_char	hsec;	/* hundredths of a second */
	u_char	dom;	/* day of month */
	u_char	mon;
	u_short	year;
	u_short	tzone;
	u_char	dow;	/* day of week */
};

void
getclock()
{
	struct	os2clock	os2time;

	char	*cp = (char *)&xclock;
	int	i;


	DOSGETDATETIME((char far *)&os2time);
	xclock.sec = os2time.sec;
	xclock.min = os2time.min;
	xclock.hrs = os2time.hrs;
	xclock.dom = os2time.dom;
	xclock.mon = os2time.mon;
	xclock.year = (u_char) (os2time.year - 1900);
}
#else
void
getclock()
{
	struct	DateTime	os2time;


	DOSGETDATETIME(&os2time);
	xclock.sec = os2time.seconds;
	xclock.min = os2time.minutes;
	xclock.hrs = os2time.hour;
	xclock.dom = os2time.day;
	xclock.mon = os2time.month;
	xclock.year = (u_char) (os2time.year - 1900);
}
#endif

#ifdef PROFILING

#include <sys\types.h>
#include <sys\timeb.h>

static u_long start_time=0;

u_long pt_main_time=0;	/* cummulative times */
u_long pt_hd_time=0;
u_long pt_hdr_time=0;
u_long pt_hdw_time=0;
u_long pt_dmi_time=0;
u_long pt_dmo_time=0;
u_long pt_fd_time=0;
u_long pt_fdr_time=0;
u_long pt_fdw_time=0;
u_long pt_vst_time=0;
u_long pt_vstsv_time=0;
u_long pt_vstrdrw_time=0;
u_long pt_viocmd_time=0;
u_long pt_kbdrd_time=0;

u_long	pt_main_cnt=0;	/* counters */
u_long	pt_hd_cnt=0;
u_long	pt_hdr_cnt=0;
u_long	pt_hdrs_cnt=0;
u_long	pt_hdw_cnt=0;
u_long	pt_hdws_cnt=0;
u_long	pt_dmi_cnt=0;
u_long	pt_dmo_cnt=0;
u_long	pt_fd_cnt=0;
u_long	pt_fdr_cnt=0;
u_long	pt_fdrs_cnt=0;
u_long	pt_fdw_cnt=0;
u_long	pt_fdws_cnt=0;
u_long	pt_vst_cnt=0;
u_long	pt_viocmd_cnt=0;
u_long  pt_vstsv_cnt=0;
u_long  pt_vstrdrw_cnt=0;
u_long	pt_kbdcmd_cnt=0;
u_long	pt_kbdrd_cnt=0;

#define SMsToMs(s,ms) (s*1000+(long)ms)

/* return elapsed time in milliseconds since we started */

u_long
elapsed_time()

{	struct timeb tb;

	ftime(&tb);
	return (u_long)(SMsToMs(tb.time,tb.millitm) - start_time);
}

int
init_profile_timer()

{
	start_time = elapsed_time();
}

int
print_p_info()

{
	u_long	session_time;
	float	percent;
	
	session_time = elapsed_time();
	printf("Profiling Information gathered: (All times in ms)\n");
	printf("Total time of session: %lu\n", session_time);
	if ( pt_main_cnt)
		printf("Main loop: Count: %lu Total Time: %lu Avg Time: %.2f\n",
		pt_main_cnt,pt_main_time,(float)pt_main_time/pt_main_cnt);
 	
	if ( pt_viocmd_cnt)
	   printf("\tVio Command: Count: %lu Total Time: %lu Avg Time: %.2f\n",
	   pt_viocmd_cnt,pt_viocmd_time,(float)pt_viocmd_time/pt_viocmd_cnt);

	if ( pt_kbdrd_cnt)
	 printf("\tKeyboard Read: Count: %lu Total Time: %lu Avg Time: %.2f\n",
		pt_kbdrd_cnt,pt_kbdrd_time,(float)pt_kbdrd_time/pt_kbdrd_cnt);

	if ( pt_kbdcmd_cnt)
		printf("\tKeyboard Command: Count: %lu\n", pt_kbdcmd_cnt);

	if ( pt_hd_cnt)
		printf("Hard disk: Count: %lu Total Time: %lu Avg Time: %.2f\n",
			pt_hd_cnt,pt_hd_time,(float)pt_hd_time/pt_hd_cnt);
	if ( pt_hdr_cnt)
printf("\tReads: cnt: %ld Total Time: %lu \#Sectors: %lu Avg/Kb: %.2f\n",
		pt_hdr_cnt,pt_hdr_time,pt_hdrs_cnt,
		(float)pt_hdr_time/pt_hdrs_cnt*2.0);
	if ( pt_hdw_cnt)
printf("\tWrites: cnt: %ld Total Time: %lu \#Sectors: %lu Avg/Kb: %.2f\n",
		pt_hdw_cnt,pt_hdw_time,pt_hdws_cnt,
		(float)pt_hdw_time/pt_hdws_cnt*2.0);

	if ( pt_fd_cnt)
           printf("Floppy disk: Count: %lu Total Time: %lu Avg Time: %.2f\n",
			pt_fd_cnt,pt_fd_time,(float)pt_fd_time/pt_fd_cnt);
	if ( pt_fdr_cnt)
printf("\tReads: cnt: %ld Total Time: %lu \#Sectors: %lu Avg/Kb: %.2f\n",
		pt_fdr_cnt,pt_fdr_time,pt_fdrs_cnt,
		(float)pt_fdr_time/pt_fdrs_cnt*2.0);
	if ( pt_fdw_cnt)
printf("\tWrites: cnt: %ld Total Time: %lu \#Sectors: %lu Avg/Kb: %.2f\n",
		pt_fdw_cnt,pt_fdw_time,pt_fdws_cnt,
		(float)pt_fdw_time/pt_fdws_cnt*2.0);
 	
	if ( pt_dmi_cnt)
	   printf("Disk Movein: Bytes: %lu Total Time: %lu Avg/kb: %.2f\n",
	    pt_dmi_cnt,pt_dmi_time,(float)pt_dmi_time/pt_dmi_cnt * 1024.0);
	if ( pt_dmo_cnt)
	   printf("Disk Moveout: Bytes: %lu Total Time: %lu Avg/kb: %.2f\n",
	    pt_dmo_cnt,pt_dmo_time,(float)pt_dmo_time/pt_dmo_cnt * 1024.0);

	if ( pt_vst_cnt)
	   printf("Vio Thread: Count: %lu Total Time: %lu Avg Time: %.2f\n",
			pt_vst_cnt,pt_vst_time,(float)pt_vst_time/pt_vst_cnt);

	if ( pt_vstsv_cnt)
	 printf("\tVio Save: Count: %lu Total Time: %lu Avg Time: %.2f\n",
		pt_vstsv_cnt,pt_vstsv_time,(float)pt_vstsv_time/pt_vstsv_cnt);

	if ( pt_vstrdrw_cnt)
	 printf("\tVio Redraw: Count: %lu Total Time: %lu Avg Time: %.2f\n",
	 pt_vstrdrw_cnt,pt_vstrdrw_time,(float)pt_vstrdrw_time/pt_vstrdrw_cnt);

	printf("Percent Times:\n");
	percent = ((float)pt_main_time / (float) session_time) * 100;
	printf("Main Thread: %.2f%%\n", percent);
	percent = ((float)pt_kbdrd_time / (float) session_time) * 100;
	printf("\tKeyboard Read: %.2f%%\n", percent);
	percent = ((float)pt_viocmd_time / (float) session_time) * 100;
	printf("\tVio Command: %.2f%%\n", percent);

	percent = ((float)pt_hd_time / (float) session_time) * 100;
	printf("Hard Disk Thread: %.2f%%\n", percent);

	percent = ((float)pt_fd_time / (float) session_time) * 100;
	printf("Floppy Disk Thread: %.2f%%\n", percent);

	percent = ((float)pt_vst_time / (float) session_time) * 100;
	printf("Vio Thread: %.2f%%\n", percent);
	percent = ((float)pt_vstsv_time / (float) session_time) * 100;
	printf("\tVio Save: %.2f%%\n", percent);
	percent = ((float)pt_vstrdrw_time / (float) session_time) * 100;
	printf("\tVio Redraw: %.2f%%\n", percent);

}
#endif
