#! /bin/sh
#
# 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1986,1987,1988
# LICENSED MATERIALS - PROPERTY OF IBM
# REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
#
#
#$Header:make.ws 12.0$
#$ACIS:make.ws 12.0$
#$Source: /ibm/acis/usr/sys/conf/RCS/make.ws,v $
#
# shell script to generate a workstation binary with the debugger and
# symbol table merged in.
#
#
# this version deals with two cases (determined from the current directory
#	name - host name could be used instead)
# 1. cross compiled  (/acis/ in directory pathway)
# 2. native compile. (/sys/ in directory pathway)
# 3. other cases 	(treated as native compile)
#
PATH=/usr/ibm:/bin:/usr/bin:/usr/ucb:/usr/local:/usr/ibmtools
export PATH
input=${1-vmunix}
output=${3-$input.ws}
cross=

rm -f $output

case `pwd` in
*/acis/*)	# cross compiled 
	cross=cross
	VMRDB=${2-../standca/rdb.ws}

# produce a 'vmunix.nm'
	rm -f $input.out
	if file $input | grep "demand paged" ; then
		cvtsym -S -s -p2048 -N $input $input.out || exit 1
		nm -n $input.out > $input.nm || exit 1
		rm $input.out
	else
		nm -n $input > $input.nm || exit 1
	fi
	;;
*/sys/*)		# native compile
	VMRDB=${2-../standca/rdb.out}
	cross=native
	nm -n $input > $input.nm || exit 1
	;;

*)			# where are we?
	echo "what directory is this (../sys/ not in path)?"
	VMRDB=${2-../standca/rdb.out}
	cross=native	# treat as native compile
	nm -n $input > $input.nm || exit 1
	;;
esac

	echo "symbol table produced in $input.nm"
case $cross in
cross)
	cvtsym -S -s -p2048 -N $input $input.out || exit 1
	;;
*)
	rm -f $input.out
	cp $input $input.out || exit 1
	;;
esac

OMERGE=omerge
#
# get the offsets and positions of the debugger 
# we use the current makefile to define the appropriate symbols
#
defined=`grep "IDENT=" makefile | sed 's;IDENT=;;`
eval `unifdef $defined ../machine/rdb.h | awk ' $1 == "#define" { print $2 "=" substr($3,3) } ' `
echo "Merging debugger (from ${VMRDB}) into $input.out..."
${OMERGE} -p2048 -o0x${RDB_RELOC?} -e0x${RDB_END?} ${VMRDB} $input.out || exit 1
# convert NCS symbols if necessary
../conf/fixsyms $input.nm $input.snm || exit 1
# following sed makes the 'int' routines visable and also changes the
# virtual kernel addresses back into real addresses
( sed -e 's;^e;0;' -e 's; int; _int;' -e 's;mcount;_mcount;' $input.snm ) |
	makesym -h > $input.sym || exit 1
echo "Merging symbol table (from $input.sym) into $input.out..."
${OMERGE} -p2048 -o0x${RDB_SYMTAB?} -l0x${RDB_SYMLEN?} $input.sym $input.out || exit 1

case $cross in
cross)
# when cross generating generate a version for the workstation byte order
	cvtsym -p2048 -N $input.out $output || exit 1
	rm -f $input.out
	;;
*)
	ln $input.out $output || exit 1
	;;
esac
	echo "$cross generated kernel with debugger now in $output"
