/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1987,1988
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:fpa1rtnes.c 12.0$ */
/* $ACIS:fpa1rtnes.c 12.0$ */
/* $Source: /ibm/acis/usr/sys/ca/RCS/fpa1rtnes.c,v $ */

#if !defined(lint) && !defined(NO_RCS_HDRS)
static char *rcsid = "$Header:fpa1rtnes.c 12.0$";
#endif

#include "param.h"
#include "rtflops.h"

/*
 * the purpose of this file is to provide dummy routines for fpgen
 * when we don't support a particular floating point (e.g. FPA or MC881)
 * for either the miniroot or for 6152.
 */

typedef int	(*operations[NUM_OPCODES])();

#ifndef MC881
operations f881rtnes = { 0 };
#endif NOMC881

#ifndef FPA

operations _fpa1rtnes = { 0 };

operations _fpa2rtnes = { 0 };

/***********************
 * FP Hardware types
 ***********************
 */
#define	FPA_EMUL	0
#define	FPA_FPA1	1
#define	FPA_68881	2
#define	FPA_FPA2	3
#define NUM_FPAS	4

#define	FAST_PREC	0
#define	SINGLE_PREC	1
#define	DOUBLE_PREC	2
#define	PRECISE_PREC	3
#define	DEFAULT_PREC	FAST_PREC

/*
 * fpas_prec
 *
 * Pick the appropriate precision.
 * For now, this is pretty simple.  The comments hold what
 * the code should really do.
 *
 */
_fpas_prec(prec1, prec2, mode)
int	prec1, prec2;		/* two argument precisions	*/
int	mode;
{
	/*
	 *  Default or single mode, go as fast as possible...
	 *	(but if mixed precision, choose widest!)
	 */
	if ((mode == FAST_PREC) || (mode == SINGLE_PREC))
		if ((prec1 == DBLETYPE) || (prec2 == DBLETYPE))
			return(DBLETYPE);
		else
			return(SGLETYPE);
	/*
	 *  Precise or double mode, do in double ...
	 */
	else
		return(DBLETYPE);
}

#endif FPA
