/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1988
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:callback.ss.c 12.0$ */
/* $ACIS:callback.ss.c 12.0$ */
/* $Source: /ibm/acis/usr/sys/afsint/RCS/callback.ss.c,v $ */

#ifndef lint
static char *rcsid = "$Header:callback.ss.c 12.0$";
#endif

#include "../h/types.h"
#include "../h/socket.h"
#include "../h/file.h"
#include "../h/stat.h"
#include "../netinet/in.h"
#include "../h/time.h"
#include "../rpc/types.h"
#include "../rpc/xdr.h"

#define R_INTERNALS	1
#include "../afs/osi.h"
#include "../afs/r.h"
#undef R_INTERNALS

#define SERVERSTUB	1
#include		"../afsint/rvice.h"

#define		CALLBACK					200
#define		CALLBACKCONNECTBACK		201
#define		CALLBACKRECEIVEDSTORE	202
#define		CALLBACKBULK				203
#define NULL	0
struct r_packet *_RCallBack(z_conn, z_pb)
    register struct r_connection *z_conn;
    register struct r_packet *z_pb;
{
    int z_result;
    struct ViceFid Fid;

    if (!xdr_ViceFid(&z_pb->xdrs, &Fid)) goto fail;
    r_FreePacket(z_pb);
    z_result = RCallBack(z_conn, &Fid);
    z_pb = r_AllocSendPacket(r_packetSize);
    if (!xdr_int(&z_pb->xdrs, &z_result)) goto fail;
    return z_pb;
fail:
    if (z_pb != 0) r_FreePacket(z_pb);
    return (struct r_packet *) 0;
}

struct r_packet *_RCallBackConnectBack(z_conn, z_pb)
    register struct r_connection *z_conn;
    register struct r_packet *z_pb;
{
    int z_result;

    r_FreePacket(z_pb);
    z_result = RCallBackConnectBack(z_conn);
    z_pb = r_AllocSendPacket(r_packetSize);
    if (!xdr_int(&z_pb->xdrs, &z_result)) goto fail;
    return z_pb;
fail:
    if (z_pb != 0) r_FreePacket(z_pb);
    return (struct r_packet *) 0;
}

struct r_packet *_RCallBackReceivedStore(z_conn, z_pb)
    register struct r_connection *z_conn;
    register struct r_packet *z_pb;
{
    int z_result;
    struct ViceFid Fid;

    if (!xdr_ViceFid(&z_pb->xdrs, &Fid)) goto fail;
    r_FreePacket(z_pb);
    z_result = RCallBackReceivedStore(z_conn, &Fid);
    z_pb = r_AllocSendPacket(r_packetSize);
    if (!xdr_int(&z_pb->xdrs, &z_result)) goto fail;
    return z_pb;
fail:
    if (z_pb != 0) r_FreePacket(z_pb);
    return (struct r_packet *) 0;
}

struct r_packet *_RCallBackBulk(z_conn, z_pb)
    register struct r_connection *z_conn;
    register struct r_packet *z_pb;
{
    int z_result;
    struct ViceFid * fids = ( struct ViceFid *) 0;
    int nfids;

	if (!xdr_array(&z_pb->xdrs, (caddr_t *) &fids, (u_int *) &nfids, FIDS_MAXSIZE, sizeof (*fids), xdr_ViceFid)) goto fail;
    r_FreePacket(z_pb);
    z_result = RCallBackBulk(z_conn, fids, nfids);
    z_pb = r_AllocSendPacket(r_packetSize);
    if (!xdr_int(&z_pb->xdrs, &z_result)) goto fail;
#ifdef SERVERSTUB
    kmem_free(fids, nfids * sizeof(struct ViceFid));
#endif
    return z_pb;
fail:
    if (z_pb != 0) r_FreePacket(z_pb);
    return (struct r_packet *) 0;
}

