/*
 * 5799-WZQ (C) COPYRIGHT = NONE
 * LICENSED MATERIALS - PROPERTY OF IBM
 */
/* $Header:srvrsmtp.c 12.0$ */
/* $ACIS:srvrsmtp.c 12.0$ */
/* $Source: /ibm/acis/usr/src/usr.lib/sendmail/src/RCS/srvrsmtp.c,v $ */

#ifndef lint
static char *rcsid = "$Header:srvrsmtp.c 12.0$";
#endif

#include <sys/nfs_defines.h>

/*
**  Sendmail
**  Copyright (c) 1983  Eric P. Allman
**  Berkeley, California
**
**  Copyright (c) 1983 Regents of the University of California.
**  All rights reserved.  The Berkeley software License Agreement
**  specifies the terms and conditions for redistribution.
*/

#ifdef YP
/* @(#)srvrsmtp.c	1.1 87/09/21 3.2/4.3NFSSRC */
#endif YP

# include <errno.h>
# include "sendmail.h"
# include <signal.h>

# ifndef SMTP
# ifndef lint
static char	SccsId[] = "@(#)srvrsmtp.c	5.18 (Berkeley) 1/5/86	(no SMTP)";
# endif not lint
# else SMTP

# ifndef lint
static char	SccsId[] = "@(#)srvrsmtp.c	5.18 (Berkeley) 1/5/86";
# endif not lint

/*
**  SMTP -- run the SMTP protocol.
**
**	Parameters:
**		none.
**
**	Returns:
**		never.
**
**	Side Effects:
**		Reads commands from the input channel and processes
**			them.
*/

struct cmd
{
	char	*cmdname;	/* command name */
	int	cmdcode;	/* internal code, see below */
};

/* values for cmdcode */
# define CMDERROR	0	/* bad command */
# define CMDMAIL	1	/* mail -- designate sender */
# define CMDRCPT	2	/* rcpt -- designate recipient */
# define CMDDATA	3	/* data -- send message text */
# define CMDRSET	4	/* rset -- reset state */
# define CMDVRFY	5	/* vrfy -- verify address */
# define CMDHELP	6	/* help -- give usage info */
# define CMDNOOP	7	/* noop -- do nothing */
# define CMDQUIT	8	/* quit -- close connection and die */
# define CMDHELO	9	/* helo -- be polite */
# define CMDDBGQSHOW	10	/* showq -- show send queue (DEBUG) */
# define CMDDBGDEBUG	11	/* debug -- set debug mode */
# define CMDVERB	12	/* verb -- go into verbose mode */
# define CMDDBGKILL	13	/* kill -- kill sendmail */
# define CMDDBGWIZ	14	/* wiz -- become a wizard */
# define CMDONEX	15	/* onex -- sending one transaction only */

static struct cmd	CmdTab[] =
{
	"mail",		CMDMAIL,
	"rcpt",		CMDRCPT,
	"data",		CMDDATA,
	"rset",		CMDRSET,
	"vrfy",		CMDVRFY,
	"expn",		CMDVRFY,
	"help",		CMDHELP,
	"noop",		CMDNOOP,
	"quit",		CMDQUIT,
	"helo",		CMDHELO,
	"verb",		CMDVERB,
	"onex",		CMDONEX,
# ifdef DEBUG
	"showq",	CMDDBGQSHOW,
# endif DEBUG
# ifdef notdef
	"debug",	CMDDBGDEBUG,
# endif notdef
# ifdef WIZ
	"kill",		CMDDBGKILL,
# endif WIZ
	"wiz",		CMDDBGWIZ,
	NULL,		CMDERROR,
};

# ifdef WIZ
bool	IsWiz = FALSE;			/* set if we are a wizard */
# endif WIZ
char	*WizWord;			/* the wizard word to compare against */
bool	InChild = FALSE;		/* true if running in a subprocess */
#ifndef YP
bool	OneXact = FALSE;		/* one xaction only this run */
#endif !YP

#define EX_QUIT		22		/* special code for QUIT command */

#ifdef YP
/**
 ** GRABCOMMAND - parse one smtp command line
 **/
char *grabcommand( inp, stringp, cmdp)
    char *inp;				/* input line */
    char **stringp;			/* returns the command string */
    struct cmd **cmdp;			/* returns the command structure */
  {
	register struct cmd *c;
	register char *p;
	extern bool sameword();
	
	p = inp;
	/* clean up end of line */
	fixcrlf(p, TRUE);

	/* echo command to transcript */
	if (CurEnv->e_xfp != NULL)
		fprintf(CurEnv->e_xfp, "<<< %s\n", inp);
	/* break off command */
	for (p = inp; isspace(*p); p++)
		continue;
	*stringp = p;
	while (*++p != '\0' && !isspace(*p))
		continue;
	if (*p != '\0')
		*p++ = '\0';
	/* decode command */
	for (c = CmdTab; c->cmdname != NULL; c++)
	{
		if (sameword(c->cmdname, *stringp))
			break;
	}
	*cmdp = c;
	return p;
  }
#endif YP

smtp()
{
	register char *p;
#ifdef YP
	struct cmd *c;
#else YP
	register struct cmd *c;
#endif YP
	char *cmd;
	extern char *skipword();
#ifndef YP
	extern bool sameword();
#endif !YP
	bool hasmail;			/* mail command received */
#ifdef YP
	bool wasquit;			/* one transaction (quit after .) */
#endif YP
	auto ADDRESS *vrfyqueue;
	ADDRESS *a;
	char inp[MAXLINE];
#ifndef YP
	char cmdbuf[100];
#endif !YP
	extern char Version[];
	extern tick();
	extern bool iswiz();
	extern char *arpadate();
	extern char *macvalue();
	extern ADDRESS *recipient();
	extern ENVELOPE BlankEnvelope;
	extern ENVELOPE *newenvelope();

	hasmail = FALSE;
	if (OutChannel != stdout)
	{
		/* arrange for debugging output to go to remote host */
		(void) close(1);
		(void) dup(fileno(OutChannel));
	}
#ifdef YP
	/* open alias database */
	initaliases(AliasFile, FALSE);
#endif YP
	settime();
	if (RealHostName != NULL)
	{
		CurHostName = RealHostName;
#ifdef YP
		setproctitle("From %s", CurHostName);
#else YP
		setproctitle("srvrsmtp %s", CurHostName);
#endif YP
	}
	else
	{
		/* this must be us!! */
		CurHostName = MyHostName;
	}
	expand("\001e", inp, &inp[sizeof inp], CurEnv);
	message("220", inp);
	SmtpPhase = "startup";
	for (;;)
	{
		/* arrange for backout */
		if (setjmp(TopFrame) > 0 && InChild)
			finis();
		QuickAbort = FALSE;
		HoldErrs = FALSE;

		/* setup for the read */
		CurEnv->e_to = NULL;
		Errors = 0;
		(void) fflush(stdout);

		/* read the input line */
		p = sfgets(inp, sizeof inp, InChannel);

		/* handle errors */
		if (p == NULL)
		{
			/* end of file, just die */
			message("421", "%s Lost input channel to %s",
				MyHostName, CurHostName);
			finis();
		}

#ifdef YP
		p = grabcommand( inp, &cmd, &c);

	commandloop:
#else YP
		/* clean up end of line */
		fixcrlf(inp, TRUE);

		/* echo command to transcript */
		if (CurEnv->e_xfp != NULL)
			fprintf(CurEnv->e_xfp, "<<< %s\n", inp);

		/* break off command */
		for (p = inp; isspace(*p); p++)
			continue;
		cmd = p;
		for (cmd = cmdbuf; *p != '\0' && !isspace(*p); )
			*cmd++ = *p++;
		*cmd = '\0';

		/* throw away leading whitespace */
		while (isspace(*p))
			p++;

		/* decode command */
		for (c = CmdTab; c->cmdname != NULL; c++)
		{
			if (sameword(c->cmdname, cmdbuf))
				break;
		}
#endif YP

		/* process command */
		switch (c->cmdcode)
		{
		  case CMDHELO:		/* hello -- introduce yourself */
			SmtpPhase = "HELO";
#ifdef YP
			setproctitle("From %s: %s", CurHostName, inp);
#else YP
			setproctitle("%s: %s", CurHostName, inp);
#endif YP
			if (sameword(p, MyHostName))
			{
				/* connected to an echo server */
#ifdef YP
				message("553", "%s host name configuration error",
#else YP
				message("553", "%s I refuse to talk to myself",
#endif YP
					MyHostName);
				break;
			}
#ifdef YP
			if (RealHostName != NULL)
#else YP
			if (RealHostName != NULL && !sameword(p, RealHostName))
#endif YP
			{
#ifdef YP
				char buf[MAXNAME];
				register char *a = CurHostName;
				register char *b = p;
#else YP
				char hostbuf[MAXNAME];

				(void) sprintf(hostbuf, "%s (%s)", p, RealHostName);
				define('s', newstr(hostbuf), CurEnv);
#endif YP
#ifdef YP
				/* 
				 * Verify that hostname matches, but accept
				 * a leading prefix on a domain boundary,
				 * since the network code doesn't know which
				 * domain the other guy is in.  E.g. if we are
				 * talking to "15" then it can announce itself
				 * as "15.sun.uucp" and we won't complain.
				 */
				while (lower(*a) == lower(*b)) {
					if (*a == '\0')
						break;
					a++, b++;
				}
				if (*a == '\0' &&
					(*b == '\0' || *b == '.'))
						goto nameok;

				/*
				 * Didn't pass validation.  Use both names.
				 */
				(void) sprintf(buf, "%s (%s)", p, CurHostName);
				define('s', p = newstr(buf), CurEnv);
#endif YP
			}
			else
#ifdef YP
			{
		nameok:
#endif YP
				define('s', newstr(p), CurEnv);
#ifdef YP
			}
#endif YP
			message("250", "%s Hello %s, pleased to meet you",
				MyHostName, p);
			break;

		  case CMDMAIL:		/* mail -- designate sender */
			SmtpPhase = "MAIL";

			/* force a sending host even if no HELO given */
			if (RealHostName != NULL && macvalue('s', CurEnv) == NULL)
				define('s', RealHostName, CurEnv);

			/* check for validity of this command */
			if (hasmail)
			{
				message("503", "Sender already specified");
				break;
			}
#ifndef YP
			if (InChild)
			{
				syserr("Nested MAIL command");
				exit(0);
			}

			/* fork a subprocess to process this command */
			if (runinchild("SMTP-MAIL") > 0)
				break;
#endif YP
			initsys();
#ifdef YP
			setproctitle("%s From %s: %s", CurEnv->e_id,
#else YP
			setproctitle("%s %s: %s", CurEnv->e_id,
#endif YP
				CurHostName, inp);

			/* child -- go do the processing */
			p = skipword(p, "from");
			if (p == NULL)
				break;
			setsender(p);
			if (Errors == 0)
			{
				message("250", "Sender ok");
				hasmail = TRUE;
			}
#ifndef YP
			else if (InChild)
				finis();
#endif YP
			break;

		  case CMDRCPT:		/* rcpt -- designate recipient */
			SmtpPhase = "RCPT";
#ifdef YP
			setproctitle("%s From %s: %s", CurEnv->e_id,
#else YP
			setproctitle("%s %s: %s", CurEnv->e_id,
#endif YP
				CurHostName, inp);
			if (setjmp(TopFrame) > 0)
			{
				CurEnv->e_flags &= ~EF_FATALERRS;
				break;
			}
			QuickAbort = TRUE;
			p = skipword(p, "to");
			if (p == NULL)
				break;
			a = parseaddr(p, (ADDRESS *) NULL, 1, '\0');
			if (a == NULL)
				break;
			a->q_flags |= QPRIMARY;
			a = recipient(a, &CurEnv->e_sendqueue);
			if (Errors != 0)
				break;

			/* no errors during parsing, but might be a duplicate */
			CurEnv->e_to = p;
			if (!bitset(QBADADDR, a->q_flags))
				message("250", "Recipient ok");
			else
			{
				/* punt -- should keep message in ADDRESS.... */
				message("550", "Addressee unknown");
			}
			CurEnv->e_to = NULL;
			break;

		  case CMDDATA:		/* data -- text of mail */
			SmtpPhase = "DATA";
			if (!hasmail)
			{
				message("503", "Need MAIL command");
				break;
			}
			else if (CurEnv->e_nrcpts <= 0)
			{
				message("503", "Need RCPT (recipient)");
				break;
			}

			/* collect the text of the message */
			SmtpPhase = "collect";
#ifdef YP
			setproctitle("%s From %s: %s", CurEnv->e_id,
#else YP
			setproctitle("%s %s: %s", CurEnv->e_id,
#endif YP
				CurHostName, inp);
			collect(TRUE);
#ifdef YP
			SmtpPhase = "wait for quit";
#endif YP
			if (Errors != 0)
				break;

			/*
			**  Arrange to send to everyone.
			**	If sending to multiple people, mail back
			**		errors rather than reporting directly.
			**	In any case, don't mail back errors for
			**		anything that has happened up to
			**		now (the other end will do this).
			**	Truncate our transcript -- the mail has gotten
			**		to us successfully, and if we have
			**		to mail this back, it will be easier
			**		on the reader.
			**	Then send to everyone.
			**	Finally give a reply code.  If an error has
			**		already been given, don't mail a
			**		message back.
			**	We goose error returns by clearing error bit.
			*/

#ifdef YP
			HoldErrs = TRUE;
			ErrorMode = EM_MAIL;
#endif YP
#ifndef YP
			SmtpPhase = "delivery";
			if (CurEnv->e_nrcpts != 1)
			{
				HoldErrs = TRUE;
				ErrorMode = EM_MAIL;
			}
#endif !YP
			CurEnv->e_flags &= ~EF_FATALERRS;
#ifdef YP
			
			/*
			 * read the next input line to determine what
			 * mode to send the mail in.  QUIT means close first
			 * and then deliver; otherwise background.
			 */
			message("250", "Mail accepted");
			p = sfgets(inp, sizeof inp, InChannel);
			if (p!=NULL)
				p = grabcommand( inp, &cmd, &c);
			wasquit = (p == NULL || c->cmdcode == CMDQUIT );
			if (wasquit)
			  {
			    message("221", "%s delivering mail", MyHostName);
			    fclose(InChannel);
			    fclose(OutChannel);
			  }
#endif YP
			CurEnv->e_xfp = freopen(queuename(CurEnv, 'x'), "w", CurEnv->e_xfp);
			/* send to all recipients */
#ifdef YP
			sendall(CurEnv, wasquit ? SM_FORK : SM_DELIVER);
#else YP
			sendall(CurEnv, SM_DEFAULT);
#endif YP
			CurEnv->e_to = NULL;

#ifdef YP
			hasmail = 0;
#endif YP

			/* save statistics */
			markstats(CurEnv, (ADDRESS *) NULL);

#ifdef YP
			if (wasquit)
#else YP
			/* issue success if appropriate and reset */
			if (Errors == 0 || HoldErrs)
				message("250", "Ok");
			else
				CurEnv->e_flags &= ~EF_FATALERRS;

			/* if in a child, pop back to our parent */
			if (InChild)
#endif YP
				finis();

#ifndef YP
			/* clean up a bit */
			hasmail = 0;
#endif !YP
			dropenvelope(CurEnv);
			CurEnv = newenvelope(CurEnv);
			CurEnv->e_flags = BlankEnvelope.e_flags;
#ifdef YP
			goto commandloop;
#else YP
			break;
#endif YP

		  case CMDRSET:		/* rset -- reset state */
#ifdef YP
			hasmail = 0;
			Errors = 0;
			CurEnv->e_nrcpts = 0;
			CurEnv->e_sendqueue = NULL;
#endif YP
			message("250", "Reset state");
#ifndef YP
			if (InChild)
				finis();
#endif !YP
			break;

		  case CMDVRFY:		/* vrfy -- verify address */
#ifdef YP
			setproctitle("From %s: %s", CurHostName, inp);
#else YP
			if (runinchild("SMTP-VRFY") > 0)
				break;
			setproctitle("%s: %s", CurHostName, inp);
#endif YP
			vrfyqueue = NULL;
			QuickAbort = TRUE;
			sendtolist(p, (ADDRESS *) NULL, &vrfyqueue);
#ifndef YP
			if (Errors != 0)
			{
				if (InChild)
					finis();
				break;
			}
#endif !YP
			while (vrfyqueue != NULL)
			{
				register ADDRESS *a = vrfyqueue->q_next;
				char *code;

				while (a != NULL && bitset(QDONTSEND|QBADADDR, a->q_flags))
					a = a->q_next;

				if (!bitset(QDONTSEND|QBADADDR, vrfyqueue->q_flags))
				{
					if (a != NULL)
						code = "250-";
					else
						code = "250";
					if (vrfyqueue->q_fullname == NULL)
						message(code, "<%s>", vrfyqueue->q_paddr);
					else
						message(code, "%s <%s>",
						    vrfyqueue->q_fullname, vrfyqueue->q_paddr);
				}
				else if (a == NULL)
					message("554", "Self destructive alias loop");
				vrfyqueue = a;
			}
#ifndef YP
			if (InChild)
				finis();
#endif !YP
			break;

		  case CMDHELP:		/* help -- give user info */
			if (*p == '\0')
				p = "SMTP";
			help(p);
			break;

		  case CMDNOOP:		/* noop -- do nothing */
			message("200", "OK");
			break;

		  case CMDQUIT:		/* quit -- leave mail */
			message("221", "%s closing connection", MyHostName);
#ifndef YP
			if (InChild)
				ExitStat = EX_QUIT;
#endif !YP
			finis();

		  case CMDVERB:		/* set verbose mode */
			Verbose = TRUE;
#ifndef YP
			SendMode = SM_DELIVER;
#endif !YP
			message("200", "Verbose mode");
			break;

		  case CMDONEX:		/* doing one transaction only */
#ifndef YP
			OneXact = TRUE;
#endif !YP
			message("200", "Only one transaction");
			break;

# ifdef DEBUG
		  case CMDDBGQSHOW:	/* show queues */
			printf("Send Queue=");
			printaddr(CurEnv->e_sendqueue, TRUE);
			break;

		  case CMDDBGDEBUG:	/* set debug mode */
			tTsetup(tTdvect, sizeof tTdvect, "0-99.1");
			tTflag(p);
			message("200", "Debug set");
			break;
# endif DEBUG

# ifdef WIZ
		  case CMDDBGKILL:	/* kill the parent */
			if (!iswiz())
				break;
			if (kill(MotherPid, SIGTERM) >= 0)
				message("200", "Mother is dead");
			else
				message("500", "Can't kill Mom");
			break;

		  case CMDDBGWIZ:	/* become a wizard */
			if (WizWord != NULL)
			{
				char seed[3];
				extern char *crypt();

				(void) strncpy(seed, WizWord, 2);
				if (strcmp(WizWord, crypt(p, seed)) == 0)
				{
					IsWiz = TRUE;
					message("200", "Please pass, oh mighty wizard");
					break;
				}
			}
			message("500", "You are no wizard!");
			break;

# else WIZ
#ifndef YP
		  case CMDDBGWIZ:	/* try to become a wizard */
			message("500", "You wascal wabbit!  Wandering wizards won't win!");
			break;
#endif !YP
# endif WIZ

		  case CMDERROR:	/* unknown command */
			message("500", "Command unrecognized");
			break;

		  default:
			syserr("smtp: unknown code %d", c->cmdcode);
			break;
		}
	}
}
/*
**  SKIPWORD -- skip a fixed word.
**
**	Parameters:
**		p -- place to start looking.
**		w -- word to skip.
**
**	Returns:
**		p following w.
**		NULL on error.
**
**	Side Effects:
**		clobbers the p data area.
*/

static char *
skipword(p, w)
	register char *p;
	char *w;
{
	register char *q;
	extern bool sameword();

	/* find beginning of word */
	while (isspace(*p))
		p++;
	q = p;

	/* find end of word */
	while (*p != '\0' && *p != ':' && !isspace(*p))
		p++;
	while (isspace(*p))
		*p++ = '\0';
	if (*p != ':')
	{
	  syntax:
		message("501", "Syntax error");
		Errors++;
		return (NULL);
	}
	*p++ = '\0';
	while (isspace(*p))
		p++;

	/* see if the input word matches desired word */
	if (!sameword(q, w))
		goto syntax;

	return (p);
}
/*
**  HELP -- implement the HELP command.
**
**	Parameters:
**		topic -- the topic we want help for.
**
**	Returns:
**		none.
**
**	Side Effects:
**		outputs the help file to message output.
*/

help(topic)
	char *topic;
{
	register FILE *hf;
	int len;
	char buf[MAXLINE];
	bool noinfo;

	if (HelpFile == NULL || (hf = fopen(HelpFile, "r")) == NULL)
	{
		/* no help */
		errno = 0;
		message("502", "HELP not implemented");
		return;
	}

	len = strlen(topic);
	makelower(topic);
	noinfo = TRUE;

	while (fgets(buf, sizeof buf, hf) != NULL)
	{
		if (strncmp(buf, topic, len) == 0)
		{
			register char *p;

			p = index(buf, '\t');
			if (p == NULL)
				p = buf;
			else
				p++;
			fixcrlf(p, TRUE);
			message("214-", p);
			noinfo = FALSE;
		}
	}

	if (noinfo)
		message("504", "HELP topic unknown");
	else
		message("214", "End of HELP info");
	(void) fclose(hf);
}
/*
**  ISWIZ -- tell us if we are a wizard
**
**	If not, print a nasty message.
**
**	Parameters:
**		none.
**
**	Returns:
**		TRUE if we are a wizard.
**		FALSE if we are not a wizard.
**
**	Side Effects:
**		Prints a 500 exit stat if we are not a wizard.
*/

#ifdef WIZ

bool
iswiz()
{
	if (!IsWiz)
		message("500", "Mere mortals musn't mutter that mantra");
	return (IsWiz);
}

#endif WIZ
#ifndef YP
/*
**  RUNINCHILD -- return twice -- once in the child, then in the parent again
**
**	Parameters:
**		label -- a string used in error messages
**
**	Returns:
**		zero in the child
**		one in the parent
**
**	Side Effects:
**		none.
*/

runinchild(label)
	char *label;
{
	int childpid;

	if (!OneXact)
	{
		childpid = dofork();
		if (childpid < 0)
		{
			syserr("%s: cannot fork", label);
			return (1);
		}
		if (childpid > 0)
		{
			auto int st;

			/* parent -- wait for child to complete */
			st = waitfor(childpid);
			if (st == -1)
				syserr("%s: lost child", label);

			/* if we exited on a QUIT command, complete the process */
			if (st == (EX_QUIT << 8))
				finis();

			return (1);
		}
		else
		{
			/* child */
			InChild = TRUE;
			QuickAbort = FALSE;
			clearenvelope(CurEnv, FALSE);
		}
	}

	/* open alias database */
	initaliases(AliasFile, FALSE);

	return (0);
}
#endif !YP
# endif SMTP
