/* $Header:_tile.c 12.0$ */
/* $ACIS:_tile.c 12.0$ */
/* $Source: /ibm/acis/usr/src/usr.lib/libaed/RCS/_tile.c,v $ */

#ifndef lint
static char *rcsid = "$Header:_tile.c 12.0$";
#endif

#include "whim.h"
VI_Tile(wd,ht,twd,tht,tile)
  INT16 wd,ht;			     /* rectangle dimensions */
  INT16 twd,tht;			     /* tile dimensions */
  unsigned INT16 *tile; 	     /* tile pattern */

  begin
#include "whimdcl.h"
    INT16 nwords;		     /* number of words in scanline */
    INT16 nbytes;		/* twice nwords */

    /* figure number of words in tile pattern */
    nwords = (twd+15)/16;
    nwords = tht*nwords;
    nbytes = nwords+nwords;

    if (saving) { JOURNL(V_TILE);
		  JOURNL(wd);
		  JOURNL(ht);
		  JOURNL(twd);
		  JOURNL(tht);
		  JOURNL(nbytes);
		  write(savefile,tile,nbytes);
		}

    clear(4+nwords);	 /* clear space for order */

    /* set up tile order */
    vikint[vikoff++] = 10;	  /* tile order */
    vikint[vikoff++] = wd;	  /* rectangle width */
    vikint[vikoff++] = ht;	  /* rectangle height */
    vikint[vikoff++] = twd;	  /* tile width */
    vikint[vikoff++] = tht;	  /* tile height */

    /* copy tile pattern to buffer */
    copy(tile,nwords);
  end
