/*
 * 5799-WZQ (C) COPYRIGHT = NONE
 * LICENSED MATERIALS - PROPERTY OF IBM
 */
/* $Header:3270.h 12.0$ */
/* $ACIS:3270.h 12.0$ */
/* $Source: /ibm/acis/usr/src/ucb/tn3270/RCS/3270.h,v $ */

#if !defined(lint) && !defined(LOCORE) && defined(RCS_HDRS)
static char *rcsid3270 = "$Header:3270.h 12.0$";
#endif

/*
 *	@(#)3270.h	3.2  11/24/86
 */

#define	INCLUDED_3270

/* define orders given to 3270's */
#define	ORDER_SF	0x1d		/* Start Field */
#define	ORDER_SBA	0x11		/* Set Buffer Address (for output) */
#define	ORDER_IC	0x13		/* Insert Cursor (at buffer address) */
#define	ORDER_PT	0x05		/* Program Tab (absurdly complicated) */
#define	ORDER_RA	0x3c		/* Repeat next character to some addr */
#define	ORDER_EUA	0x12		/* Null out every unprotected field
					 * to some address.
					 */
#define	ORDER_YALE	0x2b		/* This is a special YALE order, which
					 * introduces YALE extended orders
					 * (like setting tabs, etc.).
					 */


#define ATTR_MASK		0xc0		/* control bits */
#define ATTR_PROT		0x20		/* protected bit */
#define ATTR_NUMERIC		0x10		/* numeric field */
#define	ATTR_AUTO_SKIP_MASK	0x30		/* mask to check auto skip */
#define	ATTR_AUTO_SKIP_VALUE	0x30		/* value to have auto skip */
#define ATTR_DSPD_MASK		0x0c		/* highlighting, etc. */
#define ATTR_DSPD_DNSPD		0x00		/* display, no select */
#define ATTR_DSPD_DSPD		0x04		/* display, select */
#define ATTR_DSPD_HIGH		0x08		/* highlighted, select */
#define ATTR_DSPD_NONDISPLAY	0x0c		/* non-display, no select */
#define ATTR_MDT		0x01		/* modified data tag */

/* Non-SNA control unit commands */

#define CMD_ERASE_ALL_UNPROTECTED	0x0f
#define CMD_ERASE_WRITE			0x05
#define	CMD_ERASE_WRITE_ALTERNATE	0x0d
#define	CMD_READ_BUFFER			0x02
#define	CMD_READ_MODIFIED		0x06
#define CMD_WRITE			0x01

/* SNA control unit commands */

#define	CMD_SNA_COPY			0xf7
#define CMD_SNA_ERASE_ALL_UNPROTECTED	0x6f
#define CMD_SNA_ERASE_WRITE		0xf5
#define	CMD_SNA_ERASE_WRITE_ALTERNATE	0x7e
#define	CMD_SNA_READ_BUFFER		0xf2
#define	CMD_SNA_READ_MODIFIED		0xf6
#define	CMD_SNA_READ_MODIFIED_ALL	0x6e
#define CMD_SNA_WRITE			0xf1


#define WCC_ALARM	0x04
#define WCC_RESTORE	0x02
#define WCC_RESET_MDT	0x01


/* Special EBCDIC characters unique to a 3270 */

#define	EBCDIC_SOH	0x01			/* Start of Heading */
#define	EBCDIC_STX	0x02			/* Start of Text */
#define	EBCDIC_DUP	0x1c			/* DUP character */
#define EBCDIC_FM	0x1e			/* Field mark character */
#define	EBCDIC_CENTSIGN	0x4a			/* Cent sign */
