/*
 * 5799-WZQ (C) COPYRIGHT = NONE
 * LICENSED MATERIALS - PROPERTY OF IBM
 */
/* $Header:getprotoent.c 12.0$ */
/* $ACIS:getprotoent.c 12.0$ */
/* $Source: /ibm/acis/usr/src/lib/libc/net/yp/RCS/getprotoent.c,v $ */

#ifndef lint
static char *rcsid = "$Header:getprotoent.c 12.0$";
#endif

#include <sys/nfs_defines.h>

#ifdef VFS

/* @(#)getprotoent.c	1.4 87/09/11 3.2/4.3NFSSRC */
/*
 * Copyright (c) 1983 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 */

#if defined(LIBC_SCCS) && !defined(lint)
static char sccsid[] = "@(#)getprotoent.c	5.3 (Berkeley) 5/19/86";
#endif LIBC_SCCS and not lint

#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>
#include "../../yp/ypclnt.h"

/*
 * Internet version.
 */
#define	MAXALIASES	35
#define	MAXADDRSIZE	14

static char domain[256];
static char *current = NULL;	/* current entry, analogous to protof */
static int currentlen;
static int usingyellow;		/* are yellow pages up? */
static struct protoent *interpret();
struct protoent *getprotoent();
char *inet_ntoa();
static char PROTODB[] = "/etc/protocols";
static FILE *protof = NULL;
static char *any();
static int _proto_stayopen;

struct protoent *
getprotobynumber(proto)
{
	register struct protoent *p;
	int reason;
	char adrstr[12], *val;
	int vallen;

	setprotoent(_proto_stayopen);
	if (!usingyellow) {
 		while (p = getprotoent()) {
			if (p->p_proto == proto)
				break;
		}
	}
	else {
		sprintf(adrstr, "%d", proto);
		if (reason = yp_match(domain, "protocols.bynumber",
		    adrstr, strlen(adrstr), &val, &vallen)) {
#ifdef DEBUG
			fprintf(stderr, "reason yp_first failed is %d\n",
			    reason);
#endif
			p = NULL;
		    }
		else {
			p = interpret(val, vallen);
			free(val);
		}
	}
	if (!_proto_stayopen)
		endprotoent();
	return (p);
}

struct protoent *
getprotobyname(name)
	register char *name;
{
	register struct protoent *p;
	register char **cp;
	int reason;
	char *val;
	int vallen;

	setprotoent(_proto_stayopen);
	if (!usingyellow) {
		while (p = getprotoent()) {
			if (strcmp(p->p_name, name) == 0)
				break;
			for (cp = p->p_aliases; *cp != 0; cp++)
				if (strcmp(*cp, name) == 0)
					goto found;
		}
	}
	else {
		if (reason = yp_match(domain, "protocols.byname",
		    name, strlen(name), &val, &vallen)) {
#ifdef DEBUG
			fprintf(stderr, "reason yp_first failed is %d\n",
			    reason);
#endif
			p = NULL;
		    }
		else {
			p = interpret(val, vallen);
			free(val);
		}
	}
found:
	if (!_proto_stayopen)
		endprotoent();
	return (p);
}

setprotoent(f)
	int f;
{
	if (protof == NULL)
		protof = fopen(PROTODB, "r" );
	else
		rewind(protof);
	if (current)
		free(current);
	current = NULL;
	_proto_stayopen |= f;
	yellowup(1);	/* recompute whether yellow pages are up */
}

endprotoent()
{
	if (current) {
		free(current);
		current = NULL;
	}
	if (protof) {
		fclose(protof);
		protof = NULL;
	}
	_proto_stayopen = 0;
}

struct protoent *
getprotoent()
{
	int reason;
	char *key, *val;
	int keylen, vallen;
	static char line1[BUFSIZ+1];
	struct protoent *pp;

	yellowup(0);
	if (!usingyellow) {
		if (protof == NULL && (protof = fopen(PROTODB, "r")) == NULL)
			return (NULL);
	        if (fgets(line1, BUFSIZ, protof) == NULL)
			return (NULL);
		return interpret(line1, strlen(line1));
	}
	if (current == NULL) {
		if (reason =  yp_first(domain, "protocols.bynumber",
		    &key, &keylen, &val, &vallen)) {
#ifdef DEBUG
			fprintf(stderr, "reason yp_first failed is %d\n",
			    reason);
#endif
			return NULL;
		    }
	}
	else {
		if (reason = yp_next(domain, "protocols.bynumber",
		    current, currentlen, &key, &keylen, &val, &vallen)) {
#ifdef DEBUG
			fprintf(stderr, "reason yp_next failed is %d\n",
			    reason);
#endif
			return NULL;
		}
	}
	if (current)
		free(current);
	current = key;
	currentlen = keylen;
	pp = interpret(val, vallen);
	free(val);
	return (pp);
}

static struct protoent *
interpret(val, len)
{
	static char *proto_aliases[MAXALIASES];
	static struct protoent proto;
	static char line[BUFSIZ+1];
	char *p;
	register char *cp, **q;

	strncpy(line, val, len);
	p = line;
	line[len] = '\n';
	if (*p == '#')
		return (getprotoent());
	cp = any(p, "#\n");
	if (cp == NULL)
		return (getprotoent());
	*cp = '\0';
	proto.p_name = p;
	cp = any(p, " \t");
	if (cp == NULL)
		return (getprotoent());
	*cp++ = '\0';
	while (*cp == ' ' || *cp == '\t')
		cp++;
	p = any(cp, " \t");
	if (p != NULL)
		*p++ = '\0';
	proto.p_proto = atoi(cp);
	q = proto.p_aliases = proto_aliases;
	if (p != NULL) {
		cp = p;
		while (cp && *cp) {
			if (*cp == ' ' || *cp == '\t') {
				cp++;
				continue;
			}
			if (q < &proto_aliases[MAXALIASES - 1])
				*q++ = cp;
			cp = any(cp, " \t");
			if (cp != NULL)
				*cp++ = '\0';
		}
	}
	*q = NULL;
	return (&proto);
}

static char *
any(cp, match)
	register char *cp;
	char *match;
{
	register char *mp, c;

	while (c = *cp) {
		for (mp = match; *mp; mp++)
			if (*mp == c)
				return (cp);
		cp++;
	}
	return ((char *)0);
}

/* 
 * check to see if yellow pages are up, and store that fact in usingyellow.
 * The check is performed once at startup and thereafter if flag is set
 */
static
yellowup(flag)
{
	static int firsttime = 1;
	char *key, *val;
	int keylen, vallen;

	if (firsttime || flag) {
		firsttime = 0;
		if (domain[0] == 0) {
			if (getdomainname(domain, sizeof(domain)) < 0) {
				domain[0] = '\0';   /* missing system call implies that */
				usingyellow = 0;    /*   we're not usingyellow */
				return;
			}
		}
		usingyellow = !yp_bind(domain);
	}	
}


#endif
