/*
 * 5799-WZQ (C) COPYRIGHT = NONE
 * LICENSED MATERIALS - PROPERTY OF IBM
 */
/* $Header:rvddown.c 12.0$ */
/* $ACIS:rvddown.c 12.0$ */
/* $Source: /ibm/acis/usr/src/ibm/rvd/cntrl/RCS/rvddown.c,v $ */

#ifndef lint
static char *rcsid = "$Header:rvddown.c 12.0$";
#endif


#ifndef lint
static char *rcsid_rvddown_c = "$Header:rvddown.c 12.0$";
#endif lint

/* Copyright 1984 by the Massachusetts Institute of Technology */
/* See permission and disclaimer notice in the file "notice.h" */
#include "notice.h"

/* Force spindown of a given pack */
#include	<stdio.h>
#include	<sys/types.h>
#include	<machineio/vdconst.h>

#define	BUFLEN	4096		/* Long enough to include an authenticator. */

rvddown(argc, argv)
	int	argc;
	char	**argv;
{
	char	*server;
	char	sbuf[BUFLEN];
	int	debug = 0;
	extern	char	*myname;

	if(argc > 1 && ! strcmp(argv[1], "-d")) {
		++debug;
		--argc;
		++argv;
	}

	if (argc != 3) {
		fprintf(stderr, "usage: %s server pack\n", myname);
		exit(1);
	}
	server = argv[1];

	/* Try an authenticated spindown_virtual first.
	 */
#ifdef	KERBEROS
	csprintf(sbuf, "operation=spindown_virtual\npassword=\nname=%s\n",
	    argv[2]);
	if ( get_auth(sbuf, server, myname, debug) &&
	    (ctl_init_send_close(sbuf, server, debug) == NULL))
		exit(NULL);

#endif	KERBEROS

	/* The authenticated spindown_virtual failed so prompt for a password.
	 */
	csprintf(sbuf, "operation=spindown_virtual\npassword=%s\nname=%s\n",
	    getpass("Capability: ", VD_CAPAB_LEN), argv[2]);

	exit(ctl_init_send_close(sbuf, server, debug));
}
