/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1988
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:ldps.c 12.2$ */
/* $ACIS:ldps.c 12.2$ */
/* $Source: /ibm/acis/usr/src/ibm/lpfilter/pp4216/RCS/ldps.c,v $ */

#ifndef lint
static char *rcsid = "$Header:ldps.c 12.2$";
#endif


/*
 *
 *  ldps -- Load the PostScript interpreter into the 4216 Personal
 *          Pageprinter adapter
 *
 *   
 *     usage:  ldps [-Ppsdevname] filename
 *
 */ 

#include <stdio.h>
#include <fcntl.h>
#include <sys/psioctl.h>

#define MAXPACKETSIZE 1028

int ucode, ps;

char filebuff[MAXPACKETSIZE+2];  /* the extra two bytes is just for slop */
short packetbuff[MAXPACKETSIZE/2];


char *usage = "usage: ldps [-fpsdevname] ucodefile\n";
char msgbuff[128];

main(argc, argv)
     int argc;
     char **argv;

{
    short xferlen, stat;
    int totalxfered;
    char *psdevname;
    char *ucodename;
    char *argp;


    if (argc == 2) {
        ucodename = argv[1];
        psdevname = "/dev/ps0";
    }
    else if (argc == 3) {
        argp = argv[1];
        ucodename = argv[2];
        if (!(*argp == '-' && argp[1] == 'f')) {
            fprintf(stderr, usage);
            exit(2);
        }
        else psdevname = argp+2;
    }
    else {
        fprintf(stderr, usage);
        exit(2);
    }
        
    ps = open(psdevname, O_RDWR);
    if (ps < 0) {
	sprintf(msgbuff, "ldps: %s open failed", psdevname);
        perror(msgbuff);
	exit(2);
    }
    ucode = open(ucodename, O_RDONLY);
    if (ucode < 0) {
        fprintf(stderr, "ucode file %s not found", ucodename);
        exit(2);
    }


    stat = ioctl(ps, PSRESET, 0);
    if (stat < 0 ) {
        sprintf(msgbuff, "%s reset failed\n", psdevname); 
        perror(msgbuff);
        exit(2);
    }
    stat = ioctl(ps, PSREADPACKET, 0);
    if (stat < 0 ) {
        sprintf(msgbuff, "%s READPACKET ioctl failed\n", psdevname); 
        exit(2);
    }
    stat = ioctl(ps, PSWRITEPACKET, 0);
    if (stat < 0 ) {
        sprintf(msgbuff, "%s WRITEPACKET ioctl failed\n", psdevname); 
        perror(msgbuff);
        exit(2);
    }
    sleep(20); 
   
    totalxfered = 0;
    do {
        xferlen = readiplpacket(ucode, packetbuff);
        if (xferlen > 0) {
            stat = write(ps, packetbuff, xferlen);
            if (stat < 0 ) {
                fprintf(stderr, "ldfnt: write failed in ucode xfer. status = %x\n", stat);
                exit(2);
            }
            totalxfered += xferlen;
        }
    } while(xferlen > 0 && stat >= 0);
    if (stat >= 0) printf("%s ucode loaded. total xferred is %d\n", psdevname, totalxfered);
    sleep(5);
    close(ucode);
    stat = read(ps, packetbuff, 1028);  /* Clear the adapter output buffer */
    close(ps);
    exit(0);
}





int readiplpacket(f, pktbuff)
          int   f;
          short *pktbuff;

{ short len, type;
  int stat;
 
    stat = read(f, &len, 2);
    if ( stat <= 0 ) return stat;
    stat = read(f, &type, 2);
    if ( stat <= 0 ) return stat;
    stat = read(f, pktbuff+2, len);
    if ( stat <= 0 ) return stat;
    *pktbuff = len;
    pktbuff[1] = type; 

    return len+4;
}


