/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1986,1987
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:pmp.c 12.0$ */
/* $ACIS:pmp.c 12.0$ */
/* $Source: /ibm/acis/usr/src/ibm/lib/pmp/RCS/pmp.c,v $ */

#ifndef lint
static char *rcsid = "$Header:pmp.c 12.0$";
#endif

#include <stdio.h>
#include <utils.h>
#include <pmp_commands.h>
#include <char.h>
#include <font.h>
#include <text.h>
#include <vector.h>
#include <move.h>
#include <creg.h>
#include <printer.h>
#include <rp.h>
#include <vp.h>
#include <pmp.h>

	/*\
	|*	int		  p_set_debug(str)
	|*	int		  p_open(outfil)
	|*	int		  p_close()
	|*	int		  p_marked()
	|* 	char		**p_get_path()
	|* 	char		**p_set_path(dirs)
	|* 	int	  	  p_add_dir(dir)
	|*	int		  p_get_copies()
	|*	int		  p_set_copies(copies)
	|*	int		  p_next_copies(copies)
	|*	int		  p_get_tray()
	|*	int		  p_set_tray(tray)
	|*	int		  p_next_tray(tray)
	|*	int		  p_eject(clear)
	|*	int		  p_clear()
	|*	int		  p_set_display(value)
	|*	int		  p_ring_bell()
	|*	int		  p_jog()
	|*	int		  p_rotate(orient)
	|*	int		  p_get_pgwidth()
	|*	int		  p_set_pgwidth(width)
	|*	int		  p_get_pgheight()
	|*	int		  p_set_pgheight(height)
	|*	int		  p_image(ht,wid,len,encoding,image)
	|*	int		  p_fnt_activate(font)
	|*	int		  p_fnt_deactivate()
	|* 	pmp_font	 *p_fnt_open(name,type)
	|* 	int	  	  p_fnt_close(font)
	|* 	int	  	  p_fnt_addch(font,ch,chr)
	|* 	pmp_char	 *p_fnt_char(font,ch)
	|*	int		  p_ch_width(ch)
	|*	int		  p_ch_height(ch)
	|*	int		  p_ch_LTspace(ch)
	|*	int		  p_ch_RBspace(ch)
	|*	int		  p_ch_totalwidth(ch)
	|*	int		  p_ch_offset(ch)
	|*	int		  p_ch_encoding(ch)
	|*	int		  p_ch_sizepattern(ch)
	|*	char 		 *p_ch_pattern(ch)
	|*	cursor_reg	 *p_cr_mark()
	|*	int	 	  p_cr_remark(creg)
	|*	cursor_reg	 *p_cr_xymark(x,y)
	|*	int	 	  p_cr_xyremark(creg,x,y)
	|*	int	 	  p_cr_return(creg,done)
	|*	int	 	  p_cr_xreturn(creg,done)
	|*	int	 	  p_cr_yreturn(creg,done)
	|*	int	 	  p_cr_free(creg)
	|*	int		  p_mv_absolute(x,y)
	|*	int		  p_mv_relative(x,y)
	|*	int		  p_mv_h_absolute(x)
	|*	int		  p_mv_v_absolute(y)
	|*	int		  p_mv_h_relative(x)
	|*	int		  p_mv_v_relative(y)
	|*	int		  p_putchar(ch)
	|*	int		  p_putc(font,ch)
	|*	int		  p_putstring(str)
	|*	int		  p_puts(font,str)
	|*	int		  p_putnstr(font,str,n)
	|*	int		  p_putnstring(str,n)
	|*	int		  p_vec_nofill()
	|*	int		  p_vec_fill(font,pattern,x,y)
	|*	int		  p_vec_set_width(wid)
	|*	int		  p_vec_set_ends(ends)
	|*	int		  p_vec_absolute(x,y)
	|*	int		  p_vec_relative(x,y)
	|*	int		  p_vec_h_absolute(x)
	|*	int		  p_vec_v_absolute(y)
	|*	int		  p_vec_h_relative(x)
	|*	int		  p_vec_v_relative(y)
	\*/

/***============================================================***/

#ifdef DEBUG_UTILS
int
p_set_debug(debugstr)
register1 char	*debugstr;
{
   RETURN(pr_set_debug(debugstr));
}
#endif

/***============================================================***/

int 
p_open(outfil)
register1 FILE	*outfil;
{
    RETURN(pr_open(outfil));
}

/***============================================================***/

int 
p_close()
{
    RETURN(pr_close());
}

/***============================================================***/

int
p_marked()
{
    RETURN(pr_marked());
}

/***============================================================***/

char  **
p_get_path()
{
    RETURN(fnt_get_path());
}

/***============================================================***/

char **
p_set_path(dirs)
register1 char	**dirs;
{
    RETURN(fnt_set_path(dirs));
}

/***============================================================***/

int 
p_add_dir(dir)
register1 char	*dir;
{
    RETURN(fnt_add_dir(dir));
}

/***============================================================***/

int 
p_get_copies()
{
    RETURN(pr_get_copies());
}

/***============================================================***/

int 
p_set_copies(copies)
register1 int	copies;
{
    RETURN(pr_set_copies(copies));
}

/***============================================================***/

int 
p_next_copies(copies)
register1 int	copies;
{
    RETURN(pr_next_copies(copies));
}

/***============================================================***/

int 
p_get_tray()
{
    RETURN(pr_get_tray());
}

/***============================================================***/

int 
p_set_tray(tray)
register1 int	tray;
{
    RETURN(pr_set_tray(tray));
}

/***============================================================***/

int 
p_next_tray(tray)
register1 int	tray;
{
    RETURN(pr_next_tray(tray));
}

/***============================================================***/

int 
p_eject(clear)
register1 int	clear;
{
    RETURN(pr_eject(clear));
}

/***============================================================***/

int 
p_clear()
{
    RETURN(pr_clear());
}

/***============================================================***/

int 
p_set_display(value)
register1 int	value;
{
    RETURN(pr_set_display(value));
}

/***============================================================***/

int 
p_ring_bell()
{
    RETURN(pr_ring_bell());
}

/***============================================================***/

int 
p_jog()
{
    RETURN(pr_jog());
}

/***============================================================***/

int 
p_rotate(orient)
register1 int	orient;
{
    RETURN(pr_rotate(orient));
}

/***============================================================***/

int 
p_get_pgwidth()
{
    RETURN(pr_get_pgwidth());
}

/***============================================================***/

int 
p_set_pgwidth(width)
register1 int	width;
{
    RETURN(pr_set_pgwidth(width));
}

/***============================================================***/

int 
p_get_pgheight()
{
    RETURN(pr_get_pgheight());
}

/***============================================================***/

int 
p_set_pgheight(height)
register1 int	height;
{
    RETURN(pr_set_pgheight(height));
}

/***============================================================***/

int 
p_image(ht,wid,len,encoding,image)
register1 int	 ht,wid,len,encoding;
register5 char	*image;
{
    RETURN(pr_image(ht,wid,len,encoding,image));
}

/***============================================================***/

int 
p_fnt_activate(font)
register1 FONT	*font;
{
    if (!font)	
	RETURN(FALSE);
    else {
	pr_activate(font);
	RETURN(TRUE);
    }
}

/***============================================================***/

p_fnt_deactivate()
{
    pr_activate(NULL);
    RETURN(TRUE);
}

/***============================================================***/

pmp_font  *
p_fnt_open(name,type)
register1 char	*name;
register2 int	 type;
{
    RETURN((pmp_font *)fnt_open(name,type));
}

/***============================================================***/

int 
p_fnt_close(font)
register1 FONT	*font;
{
    RETURN(fnt_close(font));
}

/***============================================================***/

int 
p_fnt_addch(font,ch,chr)
register1 FONT	*font;
register2 int	 ch;
register3 CHAR	*chr;
{
    RETURN(fnt_addch(font,ch,chr));
}

/***============================================================***/

pmp_char *
p_fnt_char(font,ch)
register1 FONT	*font;
register2 int	 ch;
{
    RETURN((pmp_char *)fnt_char(font,ch));
}

/***============================================================***/

int 
p_ch_width(ch)
register1 CHAR	*ch;
{
    RETURN(ch_width(ch));
}

/***============================================================***/

int 
p_ch_height(ch)
register1 CHAR	*ch;
{
    RETURN(ch_height(ch));
}

/***============================================================***/

int 
p_ch_LTspace(ch)
register1 CHAR	*ch;
{
    RETURN(ch_LTspace(ch));
}

/***============================================================***/

int 
p_ch_RBspace(ch)
register1 CHAR	*ch;
{
    RETURN(ch_RBspace(ch));
}

/***============================================================***/

int 
p_ch_totalwidth(ch)
register1 CHAR	*ch;
{
    RETURN(ch_totalwidth(ch));
}

/***============================================================***/

int 
p_ch_offset(ch)
register1 CHAR	*ch;
{
    RETURN(ch_offset(ch));
}

/***============================================================***/

int 
p_ch_encoding(ch)
register1 CHAR	*ch;
{
    RETURN(ch_encoding(ch));
}

/***============================================================***/

int 
p_ch_sizepattern(ch)
register1 CHAR	*ch;
{
    RETURN(ch_sizepattern(ch));
}

/***============================================================***/

char *
p_ch_pattern(ch)
register1 CHAR	*ch;
{
    RETURN(ch_pattern(ch));
}

/***============================================================***/

cursor_reg *
p_cr_mark()
{
    RETURN((cursor_reg *)cr_mark());
}

/***============================================================***/

int 
p_cr_remark(creg)
register1 CREG	*creg;
{
    RETURN(cr_remark(creg));
}

/***============================================================***/

cursor_reg *
p_cr_xymark(x,y)
register1 int	x,y;
{
    RETURN((cursor_reg *)cr_xymark(x,y));
}

/***============================================================***/

int 
p_cr_xyremark(creg,x,y)
register1 CREG	*creg;
register2 int	 x,y;
{
    RETURN(cr_xyremark(creg,x,y));
}

/***============================================================***/

int 
p_cr_return(creg,done)
register1 CREG	*creg;
register2 int	 done;
{
    RETURN(cr_return(creg,done));
}

/***============================================================***/

int 
p_cr_xreturn(creg,done)
register1 CREG	*creg;
register2 int	 done;
{
    RETURN(cr_xreturn(creg,done));
}

/***============================================================***/

int 
p_cr_yreturn(creg,done)
register1 CREG	*creg;
register2 int	 done;
{
    RETURN(cr_yreturn(creg,done));
}

/***============================================================***/

int 
p_cr_free(creg)
register1 CREG	*creg;
{
    RETURN(cr_free(creg));
}

/***============================================================***/

int 
p_mv_absolute(x,y)
register1 int	x,y;
{
    RETURN(mv_absolute(x,y));
}

/***============================================================***/

int 
p_mv_relative(x,y)
register1 int	x,y;
{
    RETURN(mv_relative(x,y));
}

/***============================================================***/

int 
p_mv_h_absolute(x)
register1 int	x;
{
    RETURN(mv_h_absolute(x));
}

/***============================================================***/

int 
p_mv_v_absolute(y)
register1 int	y;
{
    RETURN(mv_v_absolute(y));
}

/***============================================================***/

int 
p_mv_h_relative(x)
register1 int	x;
{
    RETURN(mv_h_relative(x));
}

/***============================================================***/

int 
p_mv_v_relative(y)
register1 int	y;
{
    RETURN(mv_v_relative(y));
}

/***============================================================***/

int 
p_putchar(ch)
register1 int	ch;
{
    RETURN(pr_putchar(ch));
}

/***============================================================***/

int 
p_putc(font,ch)
register1 FONT	*font;
register2 int	 ch;
{
    RETURN(txt_putc(font,ch));
}

/***============================================================***/

int 
p_putstring(str)
register1 char	*str;
{
    RETURN(pr_putstring(str));
}

/***============================================================***/

int 
p_puts(font,str)
register1 FONT	*font;
register2 char	*str;
{
    RETURN(txt_puts(font,str));
}

/***============================================================***/

int 
p_putnstring(str,n)
register1 char	*str;
register2 int	 n;
{
    RETURN(pr_putnstring(str,n));
}

/***============================================================***/

int 
p_putnstr(font,str,n)
register1 FONT	*font;
register2 char	*str;
register3 int	 n;
{
    RETURN(txt_putnstr(font,str,n));
}

/***============================================================***/

int 
p_vec_nofill()
{
    RETURN(vp_vec_nofill());
}

/***============================================================***/

int 
p_vec_fill(font,pattern,x,y)
register1 FONT	*font;
register2 int	 pattern;
register3 int	 x,y;
{
    RETURN(vp_vec_fill(font,pattern,x,y));
}

/***============================================================***/

int 
p_vec_set_width(wid)
register1 int	wid;
{
    RETURN(vp_vec_set_width(wid));
}

/***============================================================***/

int 
p_vec_set_ends(ends)
register1 int	ends;
{
    RETURN(vp_vec_set_ends(ends));
}

/***============================================================***/

int 
p_vec_absolute(x,y)
register1 int	x,y;
{
    RETURN(vp_vec_absolute(x,y));
}

/***============================================================***/

int 
p_vec_relative(x,y)
register1 int	x,y;
{
    RETURN(vp_vec_relative(x,y));
}

/***============================================================***/

int 
p_vec_h_absolute(x)
register1 int	x;
{
    RETURN(vp_vec_h_absolute(x));
}

/***============================================================***/

int 
p_vec_v_absolute(y)
register1 int	y;
{
    RETURN(vp_vec_v_absolute(y));
}

/***============================================================***/

int 
p_vec_h_relative(x)
register1 int	x;
{
    RETURN(vp_vec_h_relative(x));
}

/***============================================================***/

int 
p_vec_v_relative(y)
register1 int	y;
{
    RETURN(vp_vec_v_relative(y));
}

/***============================================================***/

 
