#! /bin/sh
#
# 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1988
# LICENSED MATERIALS - PROPERTY OF IBM
# REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
#
# $Header:load.sh 1.1$ 
# $ACIS:load.sh 1.1$ 
# $Source: /ibm/acis/usr/src/etc/RCS/load.sh,v $ 
#
# syscall script to load boot into other processor's memory
# and execute it
#
# we require that it is in old a.out format (e.g. 407 format)
#
case "$1" in
-v)	option=$1
	shift
	;;
esac
#
# load the specified file (/boot usually) into the memory of the
# specified cpu (/dev/mem?). 
# we do this by getting the text + data size from the header, allocating
# sufficient memory to hold all of it, then reading it into that buffer
# and then writing it back out to the other cpu's memory.
# We then write out the start address to location zero in preparation
# for an ipl.
#
syscall $option read 0 \&0 0x20 \; \
	= \&0 ! 4 \; \
	if \$1 != 0x107 printf "$0: $1 not 407 style a.out (magic=%o)%c" \$1 10 \; \
	if \$1 != 0x107 exit 1 \; \
	sbrk 0 \; \
	= \$ + 0 99 \; \
	= \&4 ! 4 98 \; \
	= \&8 ! 4 97 \; \
	= \$98 + \$97 96 \; \
	printf "size=%d bytes%c" \$ 10 \; \
	sbrk \$96 \; \
	= \$ + 0 95 \; \
	read 0 \$99 \$96 \; \
	open ${2-/dev/mem1} 1 \; \
	= \$ + 0 94 \; \
	write \$94 \&20 4 \; \
	= \&20 ! 4 \; \
	= \$ '\&' 0xff80000 \; \
	lseek \$94 \$ 0 \; \
	write \$94 \$99 \$96 \; \
	< ${1-/boot}
