'***********************************************************
'*                                                         *
'* TERM.BAS -- A demonstration program for the IBM BASIC   *
'*             Compiler/2                                  *
'*                                                         *
'*   This program allows the computer to be used as a      *
'*   conventional "dumb" terminal in a full-duplex mode.   *
'*   It makes the following assumptions about the protocol *
'*   being used:                                           *
'*                                                         *
'*      Speed.........:  300 bps                           *
'*      Parity........:  EVEN                              *
'*      Data bits used:  7                                 *
'*      Stop bits used:  1                                 *
'*                                                         *
'*   To quit the program, press F1.                        *
'*                                                         *
'* Compiling the program:                                  *
'*                                                         *
'*   Because of the ON ERROR and RESUME statements used,   *
'*   you should compile this program with the /X option.   *
'*   Because of the ON KEY(n) GOSUB and KEY(n) ON          *
'*   statements (and the fact that no line numbers are     *
'*   being used), you should also use the /V option.       *
'*                                                         *
'* Linking the program:                                    *
'*                                                         *
'*   If you compile this program with the /O option, you   *
'*   must link the file IBMCOMC.OBJ (for DOS 3.30) or      *
'*   IBMCOMP.OBJ (for OS/2 mode) to the program (for       *
'*   example, "LINK TERM+IBMCOMC").  Otherwise, no special *
'*   Linker conventions must be used.                      *
'*                                                         *
'***********************************************************

  DEFINT A-Z    'Make all variables default to integer types

' Pre-define some variable's values (for program readability)
  FALSE = 0
  TRUE  = NOT FALSE
  LF$   = CHR$(10)  'Line feed character
  XOFF$ = CHR$(19)  'Common "suspend transmission" character
  XON$  = CHR$(17)  'Common "resume transmission" character

' Define our error-handling and quit routines
  ON ERROR GOTO ERROR.HANDLER

  ON KEY(1) GOSUB QUIT
  KEY(1) ON

' Set up the screen
  SCREEN 0,0    'Set screen to monochrome text mode
  WIDTH 40      'Set screen width to 40 characters
  KEY OFF       'Turn key display (line 25) off
  CLS           'Clear the screen
  LOCATE ,,1    'Turn the cursor on

' Open the communications line and perform the communications
  OPEN "COM1:300,E,7,1,RB256" AS #1 LEN=256
                        '"RB256" sets the size of the input
                        '  buffer to 256 bytes

  PAUSING = FALSE   'Initialize "pause flag" because we start
                    '  out not pausing

  DO     '** This is the program's main loop--it repeats forever
         '** (or until F1 is pressed)

'   If there is input from the keyboard, send it
    B$ = INKEY$
    IF (B$ <> "") THEN _
      PRINT #1,B$;        'By using the semi-colon at the end of
                          '  the PRINT# statement, we prevent
                          '  unwanted line feed characters from
                          '  being sent

'   If there is input from the communications line, display it
    DO WHILE (NOT EOF(1))    'Repeat while there is something in
                             '  the input buffer

'     If the input buffer is more than half full, ask the other
'       computer to suspend transmission
      IF (LOC(1) > 128) THEN
        PRINT #1,XOFF$       'Tell the other computer to wait
        PAUSING = TRUE       'Set flag so we know the other
                             '  computer is waiting
      END IF

'     Get what is in the buffer
      A$ = INPUT$(LOC(1),#1)

'     Remove line feed characters from the input (to avoid double
'       spacing when printing it to the screen)
      LF.POS = INSTR(1,A$,LF$)           'Look for a line feed
      DO WHILE (LF.POS > 0)              'If there is one, then:
        MID$(A$,LF.POS,1) = " "          '  Replace it with a blank
        LF.POS = INSTR(LF.POS+1,A$,LF$)  '  Look for another
      LOOP                               'Repeat

'     Print it to the screen
      PRINT A$;           'Again, the semi-colon is used when
                          '  printing to avoid unwanted line feeds

'     If we asked the other computer to suspend transmission, ask
'       it to resume transmission again
      IF (PAUSING) THEN
        PRINT #1,XON$     'Let the other computer know we are ready
                          '  to continue
        PAUSING = FALSE   'Reset our flag
      END IF

    LOOP    'Make sure nothing else appeared in the input buffer
            '  while we were processing the last batch

  LOOP    '** End of the main loop


'***********************************************************
'*                                                         *
'* ERROR.HANDLER -- Prints a message if an error occurs.   *
'*                                                         *
'***********************************************************
ERROR.HANDLER:
  BEEP             'Tell the user an error occurred
  PRINT
  PRINT "Error: #";ERR
  RESUME           'Try it again


'***********************************************************
'*                                                         *
'* QUIT -- Exits the program if the user presses F1.       *
'*                                                         *
'***********************************************************
QUIT:
  PRINT        'Print a message
  PRINT "Leaving the program . . ."
  CLOSE #1     'Close the communications line
  END          'End the program

