echo off
rem  special entry points only for use by SETUP.BAT for re-entering itself.
if %1.==entry1. goto ENTRY1
if %1.==entry2. goto ENTRY2
cls

echo IBM BASIC Compiler/2 Setup (SETUP.BAT)
echo Copyright (C) International Business Machines Corp. 1986, 1987
echo Copyright (C) Microsoft Corp. 1986, 1987
echo 

if not %1.==. goto CHECKARGS
rem  no arguments; explain usage and exit.

:HELP
echo This setup program installs the BASIC Compiler and associated files onto
echo a hard disk.  You also have the option of installing sample source files.
echo To use this program, drive A: must be your current drive, and you must
echo invoke SETUP.BAT from A:. The first BASIC Compiler disk must be in drive A:
echo (the disk is labeled BASIC if you are using 5.25" disks or BASIC & ISAM if
echo  you are using 3.5" disks).
echo 

pause
cls

echo If files with the same names as those to be installed already exist, you
echo should rename them or move them to a different directory before running
echo SETUP.BAT. If these files exist when SETUP.BAT is executed, a warning will
echo be issued and an opportunity to exit will be given.
echo 
echo It is also recommended that you protect your software investment by using the
echo standard DOS utility DISKCOPY to make a backup copy of each BASIC Compiler
echo disk.
echo 
echo The next screen will explain the arguments to SETUP.BAT so that you can tailor
echo the installation to your specific application.
echo 

pause
cls

echo To run the setup program type
echo         SETUP master osmode exedir libdir srcdir
echo where
echo     master = one of the following:
echo        F (or f) if you are installing from 360k 5.25" floppy disks
echo        M (or m) if you are installing from 720k 3.5" microfloppy disks
echo     osmode = one of the following:
echo        C (or c) if you will be using the compiler in DOS mode only
echo        P (or p) if you will be using the compiler in OS/2 mode only
echo        B (or b) if you will be using the compiler in both modes (DOS and OS/2)
echo     exedir = the full pathname (including drive letter) of the directory in
echo        which to install the executable files. The directory must exist. If it
echo        does not, you must create it before running the setup program.
echo     libdir = the full pathname (including drive letter) of the directory in
echo        which to install the library files. The directory must exist. If it
echo        does not, you must create it before running the setup program.
echo     srcdir = the full pathname (including drive letter) of the directory in
echo        which to install the sample files. This argument may be omitted if you
echo        don't want to install the sample files. The directory must exist if it
echo        is going to be used. If it does not, you must create it before running
echo        the setup program.
echo 

pause
cls

echo Examples:
echo 
echo         setup F C c:\bascom\bin c:\bascom\lib c:\bascom\src
echo 
echo This installs BASCOM from 5.25" floppy disks. The installation is for DOS.
echo The executable files are installed in directory c:\bascom\bin, the library
echo files are installed in directory c:\bascom\lib, and the samples are installed
echo in directory c:\bascom\src.
echo 
echo         setup M P c:\bin c:\lib d:\src
echo 
echo This installs BASCOM from 3.5" microfloppy disks. The installation is for OS/2.
echo The executable files are installed in directory c:\bin, the library files are
echo installed in directory c:\lib, and the samples are installed in directory
echo d:\src on a second hard disk.
echo 
echo         setup F B c:\apps\bascom c:\apps\bascom
echo 
echo This installs BASCOM from 5.25" floppy disks. The installation will support
echo both DOS and OS/2. The executable files and library files are installed in
echo directory c:\apps\bascom, but the sample files are not installed.
goto EXIT

rem  check that the arguments are correct. if so, do installation.
:CHECKARGS
rem  %1 must be F or M.
if %1.==F. goto ARG1OK
if %1.==f. goto ARG1OK
if %1.==M. goto ARG1OK
if %1.==m. goto ARG1OK
echo "%1" is not a correct master disk type. Must be F (floppy) or M (microfloppy).
:GOHELP
rem  do help again, to show user what legal arguments are.
echo 
pause
cls
goto HELP

:ARG1OK
rem  %2 must be C, P, or B.
if %2.==C. goto ARG2OK
if %2.==c. goto ARG2OK
if %2.==P. goto ARG2OK
if %2.==p. goto ARG2OK
if %2.==B. goto ARG2OK
if %2.==b. goto ARG2OK
echo "%2" is not a correct DOS type. Must be C, P, or B (both).
goto GOHELP

:ARG2OK
rem  first 2 args are ok.
rem  %3 must be present, %4 must be present, and %5 may be present.
rem  all must exist if present. it would be nice to use 'if exist' to check
rem  this, but that doesn't detect directories, so we can't.
if not %3.==. goto EXEOK
echo You must give a directory for the executable files.
goto GOHELP

:EXEOK
if not %4.==. goto LIBOK
echo You must give a directory for the library files.
goto GOHELP

:LIBOK
rem  the first 5 arguments are fine. check that no more were given.
if %6.==. goto ALLARGSOK
echo Too many arguments were given; no more than five are allowed.
goto GOHELP

:ALLARGSOK
rem  arguments are ok. start installing
rem  First, copy self to hard drive and restart execution from there

copy setup.bat %3\setup.bat >nul
%3\setup entry1 %1 %2 %3 %4 %5
:ENTRY1
rem  now we are executing from hard drive.
rem  shift out temp argument and get other arguments back to their
rem  correct locations:
shift

for %%i in (BASCOM.EXE BRUN30C.EXE BRUN30P.DLL BASCOM.PIF LINK.EXE LIB.EXE) do if exist %3\%%i goto GOT1a
for %%i in (CV.EXE LINK.PIF LIB.PIF CVP.EXE CV.HLP) do if exist %3\%%i goto GOT1a
for %%i in (ISAM.EXE ISAM.RDR ISAM.SRV REBUILD.EXE ISAMSRV.EXE ISAMCALL.DLL NISAM.EXE) do if exist %3\%%i goto GOT1a
for %%i in (BASCOM30.LIB BCOM30C.LIB BCOM30P.LIB EM.LIB BRUN30C.LIB) do if exist %4\%%i goto GOT1b
for %%i in (BRUN30P.LIB BLIBFA.LIB BLIBFP.LIB 87.LIB) do if exist %4\%%i goto GOT1b
for %%i in (IBMCOMC.OBJ IBMCOMP.OBJ SMALLERR.OBJ) do if exist %4\%%i goto GOT1b
if %5.==. goto DOCOPY1
for %%i in (REMLINE.BAS TERM.BAS SAMPLE.BAT COUNT.R COUNT.BAS COUNT.EXE) do if exist %5\%%i goto GOT1c
for %%i in (COUNT.TXT RESPOND.COM DEMO.BAS SAMPLE1.BAT SAMPLE2.BAT) do if exist %5\%%i goto GOT1c
for %%i in (SAMPLE3.CMD ASMTEST.BAS ADD.ASM ISAM.INC ISMSHELL.BAS) do if exist %5\%%i goto GOT1c
for %%i in (MAIL.BAS MAIL.INC MAIL.DAT MAIL.KEY) do if exist %5\%%i goto GOT1c
goto DOCOPY1

rem Overwriting is threatened. Warn user.
:GOT1a
echo At least one BASCOM file already exists in %3.
goto GOT1e
:GOT1b
echo At least one BASCOM file already exists in %4.
goto GOT1e
:GOT1c
echo At least one BASCOM file already exists in %5.
:GOT1e
echo You may abort the SETUP program now by pressing ^C and move or rename
echo them. If you choose to proceed, they will be overwritten.
echo 
pause

:DOCOPY1
rem  now copy all necessary files from BASIC disk to destination
echo Installing compiler files...

if exist BASCOM.EXE goto OKBASIC
if %1.==F. echo Please check the disk. Make sure the disk labeled BASIC is in the drive.
if %1.==f. echo Please check the disk. Make sure the disk labeled BASIC is in the drive.
if %1.==M. echo Please check the disk. Make sure the disk labeled BASIC & ISAM is in the drive.
if %1.==m. echo Please check the disk. Make sure the disk labeled BASIC & ISAM is in the drive.
pause
goto DOCOPY1

:OKBASIC
for %%f in (BASCOM.EXE) do echo %%f
for %%f in (BASCOM.EXE) do copy a:%%f %3 >nul
rem  copy DOS runtime if osmode C or B, not P
if %2.==P. goto NOCRT
if %2.==p. goto NOCRT
for %%f in (BRUN30C.EXE BASCOM.PIF) do echo %%f
for %%f in (BRUN30C.EXE BASCOM.PIF) do copy a:%%f %3 >nul
:NOCRT
rem  copy OS/2 runtime if osmode P or B, not C
if %2.==C. goto NOPRT
if %2.==c. goto NOPRT
echo BRUN30P.DLL
copy a:BRUN30P.DLL %3 >nul
:NOPRT
rem  install sample file if sample directory specified
if %5.==. goto NOSAMP1
echo REMLINE.BAS
copy a:remline.bas %5 >nul
:NOSAMP1

rem  change to ISAM disk if installing from 5.25" floppies
if %1.==M. goto NOSWAP1
if %1.==m. goto NOSWAP1
echo 
echo Insert diskette labelled "ISAM" in drive A:
pause
:CHKISAM
if exist REBUILD.EXE goto NOSWAP1
echo Please check the disk. Make sure the disk labeled ISAM is in the drive.
pause
goto CHKISAM

:NOSWAP1
echo 

echo Installing ISAM files...
echo REBUILD.EXE
copy a:rebuild.exe %3 >nul
rem  copy DOS isam if osmode C or B, not P
if %2.==P. goto NOCISAM
if %2.==p. goto NOCISAM
for %%f in (ISAM.EXE REBUILD.PIF) do echo %%f
for %%f in (ISAM.EXE REBUILD.PIF) do copy a:%%f %3 >nul
rem  copy DOS other isam files if osmode C
if %2.==B. goto NOCISAM
if %2.==b. goto NOCISAM
for %%f in (ISAM.RDR ISAM.SRV NISAM.EXE) do echo %%f
for %%f in (ISAM.RDR ISAM.SRV NISAM.EXE) do copy a:%%f %3 >nul
:NOCISAM
rem  copy OS/2 isam if osmode P or B, not C
if %2.==C. goto NOPISAM
if %2.==c. goto NOPISAM
for %%f in (ISAMSRV.EXE ISAMCALL.DLL) do echo %%f
for %%f in (ISAMSRV.EXE ISAMCALL.DLL) do copy a:%%f %3 >nul
:NOPISAM
rem  install sample files if sample directory specified
if %5.==. goto NOSAMP2
for %%f in (ISAM.INC ISMSHELL.BAS MAIL.BAS MAIL.INC MAIL.DAT MAIL.KEY) do echo %%f
for %%f in (ISAM.INC ISMSHELL.BAS MAIL.BAS MAIL.INC MAIL.DAT MAIL.KEY) do copy a:%%f %5 >nul
goto NOSAMP3
:NOSAMP2
for %%f in (ISAM.INC) do echo %%f
for %%f in (ISAM.INC) do copy a:%%f %3 >nul
:NOSAMP3

rem  now install libraries
echo 
if %1.==F. echo Insert diskette labelled "LIBRARIES 1" in drive A:
if %1.==f. echo Insert diskette labelled "LIBRARIES 1" in drive A:
if %1.==M. echo Insert diskette labelled "LIBRARIES" in drive A:
if %1.==m. echo Insert diskette labelled "LIBRARIES" in drive A:
pause
:CHKLIB1
if exist BASCOM30.LIB goto OKLIB1
if %1.==F. echo Please check the disk. Make sure the disk labeled LIBRARIES 1 is in the drive.
if %1.==f. echo Please check the disk. Make sure the disk labeled LIBRARIES 1 is in the drive.
if %1.==M. echo Please check the disk. Make sure the disk labeled LIBRARIES is in the drive.
if %1.==m. echo Please check the disk. Make sure the disk labeled LIBRARIES is in the drive.
pause
goto CHKLIB1
:OKLIB1
echo 
echo Installing library files...
for %%f in (BASCOM30 EM BCOM30C BCOM30P) do echo %%f.LIB
for %%f in (BASCOM30 EM BCOM30C BCOM30P) do copy a:%%f.lib %4 >nul

rem  change to LIB2 disk if installing from 5.25" floppies
if %1.==M. goto NOSWAP2
if %1.==m. goto NOSWAP2
echo 
echo Insert diskette labelled "LIBRARIES 2" in drive A:
pause
echo 
:CHKLIB2
if exist BRUN30C.LIB goto NOSWAP2
echo Please check the disk. Make sure the disk labeled LIBRARIES 2 is in the drive.
pause
goto CHKLIB2
:NOSWAP2
for %%f in (BRUN30C.LIB BRUN30P.LIB BLIBFA.LIB) do echo %%f
for %%f in (BRUN30C.LIB BRUN30P.LIB BLIBFA.LIB) do copy a:%%f %4 >nul
for %%f in (BLIBFP.LIB 87.LIB IBMCOMC.OBJ IBMCOMP.OBJ SMALLERR.OBJ) do echo %%f
for %%f in (BLIBFP.LIB 87.LIB IBMCOMC.OBJ IBMCOMP.OBJ SMALLERR.OBJ) do copy a:%%f %4 >nul
rem  now install utilities and codeview
echo 
if %1.==F. echo Insert diskette labelled "UTILITIES 1" in drive A:
if %1.==f. echo Insert diskette labelled "UTILITIES 1" in drive A:
if %1.==M. echo Insert diskette labelled "UTILITIES" in drive A:
if %1.==m. echo Insert diskette labelled "UTILITIES" in drive A:
pause
:CHKUTIL1
if exist LIB.EXE goto OKUTIL1
if %1.==F. echo Please check the disk. Make sure the disk labeled UTILITIES 1 is in the drive.
if %1.==f. echo Please check the disk. Make sure the disk labeled UTILITIES 1 is in the drive.
if %1.==M. echo Please check the disk. Make sure the disk labeled UTILITIES is in the drive.
if %1.==m. echo Please check the disk. Make sure the disk labeled UTILITIES is in the drive.
pause
goto CHKUTIL1
:OKUTIL1
echo Installing utility and debugger files...
for %%f in (LIB.EXE) do echo %%f
for %%f in (LIB.EXE) do copy a:%%f %3 >nul
rem  copy CV if osmode C or B, not P
if %2.==P. goto NOCV
if %2.==p. goto NOCV
for %%f in (CV.EXE LIB.PIF) do echo %%f
for %%f in (CV.EXE LIB.PIF) do copy a:%%f %3 >nul
rem  copy LINK if osmode C
if %2.==B. goto NOCV
if %2.==b. goto NOCV
for %%f in (LINK.EXE LINK.PIF) do echo %%f
for %%f in (LINK.EXE LINK.PIF) do copy a:%%f %3 >nul
:NOCV
rem  change to UTL2 disk if installing from 5.25" floppies
if %1.==M. goto NOSWAPC
if %1.==m. goto NOSWAPC
echo 
echo Insert diskette labelled "UTILITIES 2" in drive A:
pause
echo 
:CHKUTIL2
if exist CV.HLP goto NOSWAPC
echo Please check the disk. Make sure the disk labeled UTILITIES 2 is in the drive.
pause
goto CHKUTIL2
:NOSWAPC

for %%f in (CV.HLP) do echo %%f
for %%f in (CV.HLP) do copy a:%%f %3 >nul
rem  copy CVP if osmode P or B, not C
if %2.==C. goto NOCVP
if %2.==c. goto NOCVP
echo CVP.EXE
copy a:CVP.exe %3 >nul
:NOCVP
rem  install sample files if sample directory specified
if %5.==. goto NOSAMPC
for %%f in (TERM.BAS DEMO.BAS) do echo %%f
for %%f in (TERM.BAS DEMO.BAS) do copy a:%%f %5 >nul
rem copy DOS samples if osmode C or B, not P
if %2.==P. goto NOCSAMP
if %2.==p. goto NOCSAMP
for %%f in (SAMPLE.BAT COUNT.R COUNT.BAS COUNT.EXE COUNT.TXT RESPOND.COM) do echo %%f
for %%f in (SAMPLE.BAT COUNT.R COUNT.BAS COUNT.EXE COUNT.TXT RESPOND.COM) do copy a:%%f %5 >nul
for %%f in (SAMPLE1.BAT SAMPLE2.BAT ASMTEST.BAS ADD.ASM) do echo %%f
for %%f in (SAMPLE1.BAT SAMPLE2.BAT ASMTEST.BAS ADD.ASM) do copy a:%%f %5 >nul
:NOCSAMP
rem copy OS/2 samples if osmode P or B, not C
if %2.==C. goto NOSAMPC
if %2.==c. goto NOSAMPC
for %%f in (SAMPLE3.CMD) do echo %%f
for %%f in (SAMPLE3.CMD) do copy a:%%f %5 >nul
:NOSAMPC

rem  now get original floppy back in drive A and continue
rem  execution from there.
echo 
if %1.==F. echo Insert diskette labelled "BASIC" in drive A:
if %1.==f. echo Insert diskette labelled "BASIC" in drive A:
if %1.==M. echo Insert diskette labelled "BASIC & ISAM" in drive A:
if %1.==m. echo Insert diskette labelled "BASIC & ISAM" in drive A:
pause
:ENDCHK
if exist BASCOM.EXE goto ENDBASIC
if %1.==F. goto BAD2
if %1.==f. goto BAD2
echo Please check the disk. Make sure the disk labeled BASIC & ISAM is in the drive.
pause
goto ENDCHK
:BAD2
echo Please check the disk. Make sure the disk labeled BASIC is in the drive.
pause
goto ENDCHK
:ENDBASIC
a:setup entry2 %1 %2 %3 %4 %5
:ENTRY2
rem  now we are executing from drive A again
rem  shift out temp argument and get other arguments back to their
rem  correct locations:
shift

rem  remove temporary copy of setup.bat from exedir
del %3\setup.bat
echo 
echo Installation of the BASIC Compiler/2 is complete

:EXIT
