/* PL - add Page/Line numbers to a tape */

#include <stdio.h>
#include <string.h>
#include <dir.h>

int parity(int c)
{
    int t, d, i;
    
    t = c;
    for (i = d = 0; i < 8; i++)
    {
	d += t & 1;
	t = t >> 1;
    }
    if ((d & 1) == 0)		/* Even (bad) parity */
	c ^= 0x10;
    return c;
}

int main(int argc, char *argv[])
{
    FILE *f, *g;
    int c;
    int i;
    char path[80], drive[5], dir[80], name[20], ext[5];
    char pl[] = {0x20, 0x20, 0x20, 0x20, 0x20};

    if (argc != 3)
    {
	printf("usage: pl source dest");
	return 0;
    }
    
    fnsplit(argv[1], drive, dir, name, ext);
    if (strlen(ext) == 0)
	strcpy(ext, ".PT");
    fnmerge(path, drive, dir, name, ext);
    f = fopen(path, "rb");
    
    fnsplit(argv[2], drive, dir, name, ext);
    if (strlen(ext) == 0)
	strcpy(ext, ".PT");
    fnmerge(path, drive, dir, name, ext);
    g = fopen(path, "wb");

    c = fgetc(f);
    while (c != EOF)
    {
	while(c == 0x7F)
	    c = fgetc(f);	/* Skip tapefeed */
	if (c == EOF)		/* Skip out if end */
	    continue;
	
	for (i=0; i<5; i++)
	    fputc(parity(pl[i]), g);	/* Print out current PLN */
	for (i=0; i<5; i++)
	    pl[i] &= ~0x20;	/* Temp kill 0 fakery */
	pl[3]++;		/* Inc by 10's */
	for (i=4; i>=1; i--)
	{
	    if (pl[i] > 9)	/* Carry */
	    {
		pl[i] = 0;
		pl[i-1]++;
	    }
	}
	for (i=0; i<5; i++)
	    if (pl[i] == 0)
		pl[i] = 0x20;	/* 1620 alpha coding: 0 => 0x20 */
	do
	{
	    fputc(c, g);	/* Put rest of statement */
	    if (c == 0x80)
	    {
		c = fgetc(f);
		break;		/* Statement ends with EOL */
	    }
	    c = fgetc(f);
	}
	while (c != EOF);
    }
    return 0;
}