/******************************************************************;
;*                                                                *;
;*          INTEL CORPORATION PROPRIETARY INFORMATION.            *;
;*   THIS LISTING IS SUPPLIED UNDER THE TERMS OF A LICENSE        *;
;*   AGREEMENT OR NON-DISCLOSURE AGREEMENT WITH INTEL CORPORATION *;
;*   AND MAY NOT BE COPIED NOR DISCLOSED EXCEPT IN ACCORDANCE     *;
;*   WITH THE TERMS OF THAT AGREEMENT.                            *;
;*                                                                *;
;******************************************************************/

#define	BUFSIZ	256
#define	_NFILE	20

#ifndef	FILE
extern	struct _iobuf 
  {
  char  *_ptr;         /* next get/put in buffer */
  int  _cnt;           /* how many bytes left in buffer */
  char  *_base;        /* lowest buffer address */
  char  _flag;         /* error flags etc */
  char  _file;         /* file descriptor for low level routines */
  } _iob[_NFILE];
#endif

#define _IOREAD  0x01
#define	_IOWRT	0x02
#define	_IONBF	0x04
#define	_IOMYBUF 0x08
#define	_IOEOF	0x10
#define	_IOERR	0x20
#define	_IOSTRG	0x40
#define	_IORW	0x80

#define	NULL	0
#define	FILE	struct _iobuf
#define	EOF	(-1)

#define	stdin	(&_iob[0])
#define	stdout	(&_iob[1])
#define	stderr	(&_iob[2])

/***	getc -- get character from a stream.
 *
 *	return character on success.  return EOF on end of file or
 *	error.
 *
 *	int getc(stream)
 *	FILE  *stream;
 */
#ifndef M_LINT

#define	getc(p)		(			\
	--(p)->_cnt >= 0 ?			\
	(0xff & (int) (*(p)->_ptr++)) :		\
	_filbuf(p)				\
)
#define	getchar()	getc(stdin)

/***	putc -- put character on a stream.
 *
 *	return character on success.  return EOF on error.
 *
 *	int putc(ch, stream)
 *	char  ch;
 *	FILE  *stream;
 */
#define	putc(c, p)	(			\
    --(p)->_cnt >= 0 ? \
	(0xff & (int) (*(p)->_ptr++ = (c))) :	\
	_flsbuf(c, p)				\
)
#define	putchar(c)	putc(c, stdout)

#define	feof(p)		((p)->_flag&_IOEOF)
#define	ferror(p)	((p)->_flag&_IOERR)
#define clearerr(p) ((p)->_flag &= ~(_IOERR | _IOEOF))
#define	fileno(p)	(p)->_file

#endif

extern	FILE	*fopen();
extern	FILE	*fdopen();
extern	FILE	*freopen();
extern	long	ftell();
extern	char	*fgets();
extern	char	*gets();

#define	L_ctermid	9
#define	L_cuserid	9
#define	L_tmpnam	19
#define	LFNMAX		15		/* max len for filename */
#define	LPNMAX		128		/* (practical) max len for pathname */

#define SEEK_SET    0    /* beginning of file */
#define SEEK_CUR    1    /* current positioning */
#define SEEK_END    2    /* end of file */
