/*
INTERFACE MODULE FOR 'C' PROGRAMS TO ACCESS THE FLAGSTAFF ENGINEERING
8 INCH DISKETTE DRIVE.

The following routines are defined.  All of these routines pass back
an integer return code of zero if successful and a -1 if unsuccessful
with the exception of the FIND8 routine which passes back the diskette
format if it is found or a -1 if it is not found.

The following parameters are specified in the routine calls:

    drive = the 8 inch drive number (2 or 3).
    cylinder = the diskette cylinder (0 to 76).
    head = the diskette head (0 or 1).
    sector = the starting sector for the operation (1 to 26).
    #recs = the number of sectors to read/write.
    buffer = the address of the buffer to read/write to/from.
    fmt = diskette format.
          0 = 128 byte single density.
          1 = 256 byte single density.
          2 = 512 byte single density.
          3 = 1024 byte single density.
          4 = 256 byte double density.
          5 = 512 byte double density.
          6 = 1024 byte double density.
          7 = 2048 byte double density.

    Drive, cylinder, head, sector, #recs, and fmt are processed as 
    byte values but may be defined as integer. Buffer is the address
    of the buffer for the read, write or set format operation.

The following routine calls are defined.

A.  rc = READ8 (drive,cylinder,head,sector,#recs,buffer);

    Read one or more sectors from the 8 inch diskette.

B.  rc = WRITE8 (drive,cylinder,head,sector,#recs,buffer);

    Write one or more sectors to the 8 inch diskette.

C.  rc = VERIFY8 (drive,cylinder,head,sector,#recs,buffer);

    Read-verify one or more sectors. This is the same as read
    except the data is not actually transferred.

D.  rc = RDDEL8 (drive,cylinder,head,sector,#recs,buffer);

    Read deleted sectors.  This is the same as READ8 except that
    deleted sectors are also read if encountered.

E.  rc = WRTDEL8 (drive,cylinder,head,sector,#recs,buffer);

    Write deleted sectors.  This will write sectors out as deleted.

F.  FORMAT8 (drive,cylinder,head,sector,#recs,buffer);

    Format sectors.  This command is normally issued for a complete
    track at a time.  The 'buffer' parameter must point to a buffer
    formatted with 4 bytes for each sector on the track.  The 4 byte
    entry for each sector is defined as follows:
      0 - Cylinder number.
      1 - Head number.
      2 - Sector number (normally starts with sector 1 on a track).
      3 - Sector size (0 = 128, 1 = 256, 2 = 512, 3 = 1024, 4 = 2048).


G.  rc = RESET8 (drive);

    This recalibrates the drive (seeks cylinder 0).

H.  rc = SET8 (drive,fmt);  {or rc = SET8 (drive,8,buffer);}

    This sets up the 8 inch drive logic to process the specified diskette
    format.  This routine (or FIND8) MUST be used prior to using any of
    of the functions to access the diskette. The 'fmt' parameter must
    be 0 to 7 as defined above or if specified as (8) then the user must
    supply a 12 byte buffer containing the diskette setup parameters.

I.  fmt = FIND8 (drive,cylinder,head);

    This routine will determine the format of the diskette on the requested
    track (cylinder & head).  If the format is found a value of 0 to 7 will
    be returned.  If the diskette is unreadable a value of -1 will be
    returned.
*/

#include <fcntl.h>;

char buff[2048];   /* buffer is maximum size of a diskette sector */
char dosname[20];  /* name of dos file */
int dosfile;       /* dos file handle */
int mode;          /* mode word for opening the dos file */
int rc;            /* save return code from routine calls */
int sides;
int drive,cyl,head,sector,fmt;  /* parameters for calling 8 inch routines */
    /* number of sector/track for each diskette format (0 - 7) */
int nbrsec[8] = {26,15,8,4,26,15,8,4};
    /* number of bytes/sector for each diskette format (0 - 7) */
int secsize[8] = {128,256,512,1024,256,512,1024,2048};

main() {
  printf("This sample program reads the first two cylinders of an 8 inch\n");
  printf("single sided diskette and writes the data to a dos file.\n\n");
  do {
    printf("Enter output dos file name: "); gets(dosname);
    if (dosname[0] == 0) exit(0); /* Exit if no name was entered */
    mode = O_RAW | O_WRONLY | O_CREAT;
    dosfile = creat(dosname,mode);
    if (dosfile == -1) printf("Error creating the dos file\n");
    } while (dosfile == -1);
  drive = 2; /* The first 8 inch drive is '2' and the second one is '3' */
  sides = 1; /* Just assume single sided for this demo program */
  for (cyl=0;cyl<2;cyl++) {
    for (head=0;head<sides;head++) {
      fmt = find8(drive,cyl,head);  /* Find the format for the track */

/* NOTE!! - Normally you would not issue a 'find8' for each track that is
   accessed.  IBM 3740 (and others) commonly have a different format
   on track zero than is found on the data tracks (cyl 1 - 76).  If the format
   of the diskette is known, then just use 'set8' to set the format.  In either
   case there is no need to re-issue these commands as long as you continue
   to access tracks that are in the same format.
*/
      if (fmt == -1) {    /* the format was not found */
        printf("Error finding diskette format cyl %d  head %d\n",cyl,head);
        exit(0); }
      for (sector=1;sector<=nbrsec[fmt];sector++) {
        rc = read8(drive,cyl,head,sector,1,buff);
        if (rc != 0) { /* Maybe its a deleted sector */
          rc = rddel8(drive,cyl,head,sector,1,buff);
          if (rc != 0) { /* Nope - can't even read it as deleted */
            printf("Error reading diskette cyl %d head %d\n",cyl,head);
            exit(0); }
          }
        rc = write(dosfile,buff,secsize[fmt]);
        if (rc != secsize[fmt]) {
          printf("Error writing to dos file\n");
          exit(0); }
        } /* End of for loop to proceess each sector on the track */
      } /* End of for loop to process each head on the cylinder */
    } /* End of for loop to process each cylinder */
  close(dosfile); /* Close the dos file */
  printf("\nData transfer complete\n");
  } /* End of program
