/* Cmain requires stdio, fileio, printf, and strutils */

#include "bdos.h"
#include "stdio.h"
#include "printf.h"

#define MAXARGC 50	/* max argc after wild-card expansion */
#define MAXCHARS 1024	/* Max chars in all arguments */

static int argc;
static char **argv;
static char *argp;
static int hadwild, hadmatch;

static int
argcopy(from)
char *from;
{
	/* Copy string at "from" up to "argp" */
	/* "argp" points to end of available space */
	/* Enter arg into arg vector */
	static char *fp;

	fp = from;
	do ; while(*fp++);
	if (fp > argp || argc >= MAXARGC) {
		fprintf(stderr, "Arg list too long\n");
		exit(-1);
	}
	do {
		*--argp = *--fp;
	} while (fp > from);
	argv[argc++] = argp;
}

static int
dowild(file)
char *file;
{
	/* Do wild card expansion, copy each into arg list, lower case */
	/* Set hadwild.  Set hadmatch if some matches found. */
	auto char nambuf[NAMSIZ+TYPSIZ+4];
	auto char sbuf[IOSIZ];
	auto struct fcb nfcb;
	static char *np;
	static int i, x, c;

	hadwild = 1;
	makefcb(file, &nfcb);
	if (file[1] == ':') {
		/* Copy drive name if present */
		nambuf[0] = file[0];
		nambuf[1] = ':';
	} else {
		/* Indicate no drive present */
		nambuf[1] = 0;
	}
	/* Assume directory names if no extension specified */
	if (!strany('.', file)) strcpy(nfcb.f_type, "SD?");
	stdma(sbuf);
	/****** Will it find "SYS" files? *****/
	x = bdos(SRHFIRST, &nfcb);
	while (fileok(x)) {
		/* Found one */
		hadmatch = 1;
		/* Construct lower case copy of name */
		np = nambuf+2;
		formnam(np, &sbuf[x*32]);
		if (nambuf[1]) {
			/* Include drive name */
			argcopy(nambuf);
		} else {
			/* Use default directory */
			argcopy(np);
		}
		x = bdos(SRHNEXT, &nfcb);
	}
	stdma(IOBUF);
}

c_main()	/* Used to be called simply "_main" but m80 objected */
{
	/* This routine builds the argument list and calls main */
	/* This version does expansion of wild cards ("*" and "?") */
	auto struct {
		char	buf[MAXCHARS];	/* Cut back after done */
		char	*avbuf[MAXARGC+1];
	} a;
	static char *bp;
	static int i, n, c;
	static int qutc, parenct;
	static char *bufp;
	static int x;
	static int haswild, notfile;

	argv = a.avbuf;
	argc = 1;
	argv[0] = "-";		/* Command name unknown */
	bufp = IOBUF;
	n = bufp[0];	       /* Param string length */
	argp = a.buf + sizeof(a.buf);  /* Copy args here after built */
	parenct = 0;	/* Non-zero when inside parens */
	qutc = 0;	/* Non-zero when inside quotes */
	hadwild = hadmatch = 0; 	/* Set by dowild() */
	for (i = 0; ++i <= n; ) {
		c = bufp[i];
		if (c == ' ' || c == '\t') continue;
		/* Start new argument */
		bp = a.buf;
		notfile = haswild = 0;
		do {
			c = bufp[i];
			switch(c) {
			case '(':
				if (!qutc) {
					/* Parens not legal in file name */
					++parenct;
					++notfile;
				}
				break;
			case ')':
				if (!qutc && parenct) --parenct;
				break;
			case ' ':
			case '\t':
				/* Separator, end arg unless quoted/parened */
				if (qutc == 0 && parenct == 0) goto endarg;
				break;
			case '\'':
			case '\"':
				if (qutc == c || qutc == 0) {
					/* Start or end quote */
					qutc = c - qutc;
					/* Discard unless inside parens */
					if (!parenct) continue;
				}
				break;
			case '\\':
				/* Escaped char, will remain in upper case */
				c = bufp[++i];
				if (c == '\n') {
					/* Quoted newline equiv to space */
					c = ' ';
					if (qutc == 0 && parenct == 0)
						goto endarg;
				} else if (parenct) {
					/* Preserve if inside parens */
					*bp++ = '\\';
				}
				break;
			case '*':
			case '?':
				/* Wild card, ignore if quoted */
				if (!qutc && !parenct) ++haswild;
				break;
			default:
				/* Change to lower case */
				if (c >= 'A' && c <= 'Z') c += 'a'-'A';
				break;
			}
			*bp++ = c;
		} while (++i <= n);
	   endarg:
		*bp++ = 0;	/* Terminate argument */
		bp = a.buf;
		if (!haswild || notfile) {
			/* Normal non-wild-card argument */
			argcopy(bp);
			continue;
		}
		/* Wild-carded file name, expand */
		/* Will update argc, argv, argp as side-effect */
		dowild(bp);
	}
	argv[argc] = 0; 	/* Terminate argv */
	if (hadwild && !hadmatch) {
		fprintf(stderr, "No match\n");
		exit(-1);
	}
	bp = a.buf;	/* Get current stack pointer */
	argp;		/* Get lowest addr used */
#asm
	SPHL		;cut back the stack
#endasm
	/* Call "real" main routine */
	x = main(argc, argv);
	bp;
#asm
	SPHL		;restore the stack pointer
#endasm
	exit(x);	/* Return exit code */
}

exit(retval)
{
	/* Pass return code value to C/NIX, and then warm start */
	/* CP/M Plus allows only 0xff00 .. 0xff7f as user */
	/*  error returns */
	bdos(GSRETCODE, retval<0? 0xff00 | retval&0x7f: retval);
	bdos(SYSRST,0);
}
*/
				if (c >= 'A' && c <= 'Z') c += 'a'-'A';
				break;
	